/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.builddefinition.BuildDefinitionServiceException;
import org.apache.maven.continuum.project.builder.ContinuumProjectBuildingResult;
import org.apache.maven.continuum.web.action.AddMavenProjectAction;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class AddMavenTwoProjectAction
extends AddMavenProjectAction {
    public static final String ERROR_UPLOADING_M2_PROJECT_WITH_MODULES = "add.m2.project.upload.modules.error";
    public static final String ERROR_READING_POM_EXCEPTION_MESSAGE = "Error reading POM";
    public static final String FILE_SCHEME = "file:/";
    private boolean nonRecursiveProject;

    protected ContinuumProjectBuildingResult doExecute(String pomUrl, int selectedProjectGroup, boolean checkProtocol, boolean scmUseCache) throws ContinuumException {
        ContinuumProjectBuildingResult result = null;
        if (!checkProtocol) {
            MavenXpp3Reader m2pomReader = new MavenXpp3Reader();
            try {
                Model model;
                List modules;
                String filePath = pomUrl;
                if (!filePath.startsWith("file://") && filePath.startsWith(FILE_SCHEME)) {
                    filePath = StringUtils.replace((String)filePath, (String)FILE_SCHEME, (String)"file://");
                }
                if (filePath.startsWith(FILE_SCHEME)) {
                    filePath = filePath.substring(FILE_SCHEME.length());
                }
                if ((modules = (model = m2pomReader.read((Reader)new FileReader(filePath))).getModules()) != null && modules.size() != 0) {
                    result = new ContinuumProjectBuildingResult();
                    result.addError(ERROR_UPLOADING_M2_PROJECT_WITH_MODULES);
                }
            }
            catch (FileNotFoundException e) {
                throw new ContinuumException(ERROR_READING_POM_EXCEPTION_MESSAGE, (Throwable)e);
            }
            catch (IOException e) {
                throw new ContinuumException(ERROR_READING_POM_EXCEPTION_MESSAGE, (Throwable)e);
            }
            catch (XmlPullParserException e) {
                throw new ContinuumException(ERROR_READING_POM_EXCEPTION_MESSAGE, (Throwable)e);
            }
        }
        if (result == null) {
            result = this.getContinuum().addMavenTwoProject(pomUrl, selectedProjectGroup, checkProtocol, scmUseCache, !this.isNonRecursiveProject(), this.getBuildDefinitionTemplateId());
        }
        return result;
    }

    public String doDefault() throws BuildDefinitionServiceException {
        return super.doDefault();
    }

    public File getM2PomFile() {
        return this.getPomFile();
    }

    public void setM2PomFile(File pomFile) {
        this.setPomFile(pomFile);
    }

    public String getM2PomUrl() {
        return this.getPomUrl();
    }

    public void setM2PomUrl(String pomUrl) {
        this.setPomUrl(pomUrl);
    }

    public boolean isNonRecursiveProject() {
        return this.nonRecursiveProject;
    }

    public void setNonRecursiveProject(boolean nonRecursiveProject) {
        this.nonRecursiveProject = nonRecursiveProject;
    }
}

