/*
 * Decompiled with CFR 0.152.
 */
package org.apache.continuum.web.action.admin;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.Preparable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.continuum.model.repository.AbstractPurgeConfiguration;
import org.apache.continuum.model.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.model.repository.LocalRepository;
import org.apache.continuum.model.repository.RepositoryPurgeConfiguration;
import org.apache.continuum.purge.ContinuumPurgeManager;
import org.apache.continuum.purge.PurgeConfigurationService;
import org.apache.continuum.repository.RepositoryService;
import org.apache.maven.continuum.configuration.ConfigurationService;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.web.action.ContinuumConfirmAction;
import org.codehaus.plexus.redback.xwork.interceptor.SecureAction;
import org.codehaus.plexus.redback.xwork.interceptor.SecureActionBundle;
import org.codehaus.plexus.redback.xwork.interceptor.SecureActionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgeConfigurationAction
extends ContinuumConfirmAction
implements Preparable,
SecureAction {
    private static final String PURGE_TYPE_REPOSITORY = "repository";
    private static final String PURGE_TYPE_DIRECTORY = "directory";
    private static final String PURGE_DIRECTORY_RELEASES = "releases";
    private static final String PURGE_DIRECTORY_BUILDOUTPUT = "buildOutput";
    private static final int DEFAULT_RETENTION_COUNT = 2;
    private static final int DEFAULT_DAYS_OLDER = 100;
    private String purgeType;
    private String directoryType;
    private String description;
    private String message;
    private boolean deleteAll;
    private boolean deleteReleasedSnapshots;
    private boolean enabled;
    private boolean confirmed;
    private boolean defaultPurgeConfiguration;
    private int retentionCount;
    private int daysOlder;
    private int repositoryId;
    private int scheduleId;
    private int purgeConfigId;
    private AbstractPurgeConfiguration purgeConfig;
    private Map<Integer, String> repositories;
    private Map<Integer, String> schedules;
    private List<RepositoryPurgeConfiguration> repoPurgeConfigs;
    private List<DirectoryPurgeConfiguration> dirPurgeConfigs;
    private List<String> directoryTypes;
    private PurgeConfigurationService purgeConfigService;
    private RepositoryService repositoryService;

    public void prepare() throws Exception {
        super.prepare();
        if (this.schedules == null) {
            this.schedules = new HashMap();
            Collection allSchedules = this.getContinuum().getSchedules();
            for (Schedule schedule : allSchedules) {
                this.schedules.put(new Integer(schedule.getId()), schedule.getName());
            }
        }
        if (this.repositories == null) {
            this.repositories = new HashMap();
            List allRepositories = this.repositoryService.getAllLocalRepositories();
            for (LocalRepository repository : allRepositories) {
                this.repositories.put(new Integer(repository.getId()), repository.getName());
            }
        }
        this.directoryTypes = new ArrayList();
        this.directoryTypes.add(PURGE_DIRECTORY_RELEASES);
        this.directoryTypes.add(PURGE_DIRECTORY_BUILDOUTPUT);
    }

    public String input() throws Exception {
        if (this.purgeConfigId != 0) {
            this.purgeConfig = this.purgeConfigService.getPurgeConfiguration(this.purgeConfigId);
            if (this.purgeConfig instanceof RepositoryPurgeConfiguration) {
                RepositoryPurgeConfiguration repoPurge = (RepositoryPurgeConfiguration)this.purgeConfig;
                this.purgeType = PURGE_TYPE_REPOSITORY;
                this.daysOlder = repoPurge.getDaysOlder();
                this.retentionCount = repoPurge.getRetentionCount();
                this.deleteAll = repoPurge.isDeleteAll();
                this.deleteReleasedSnapshots = repoPurge.isDeleteReleasedSnapshots();
                this.enabled = repoPurge.isEnabled();
                this.defaultPurgeConfiguration = repoPurge.isDefaultPurge();
                this.description = repoPurge.getDescription();
                if (repoPurge.getRepository() != null) {
                    this.repositoryId = repoPurge.getRepository().getId();
                }
                if (repoPurge.getSchedule() != null) {
                    this.scheduleId = repoPurge.getSchedule().getId();
                }
            } else if (this.purgeConfig instanceof DirectoryPurgeConfiguration) {
                DirectoryPurgeConfiguration dirPurge = (DirectoryPurgeConfiguration)this.purgeConfig;
                this.purgeType = PURGE_TYPE_DIRECTORY;
                this.daysOlder = dirPurge.getDaysOlder();
                this.retentionCount = dirPurge.getRetentionCount();
                this.directoryType = dirPurge.getDirectoryType();
                this.deleteAll = dirPurge.isDeleteAll();
                this.enabled = dirPurge.isEnabled();
                this.defaultPurgeConfiguration = dirPurge.isDefaultPurge();
                this.description = dirPurge.getDescription();
                if (dirPurge.getSchedule() != null) {
                    this.scheduleId = dirPurge.getSchedule().getId();
                }
            }
        } else {
            this.retentionCount = 2;
            this.daysOlder = 100;
        }
        return "input";
    }

    public String list() throws Exception {
        String errorMessage = ServletActionContext.getRequest().getParameter("errorMessage");
        if (errorMessage != null) {
            this.addActionError(errorMessage);
        }
        this.repoPurgeConfigs = this.purgeConfigService.getAllRepositoryPurgeConfigurations();
        this.dirPurgeConfigs = this.purgeConfigService.getAllDirectoryPurgeConfigurations();
        return "success";
    }

    public String save() throws Exception {
        if (this.purgeConfigId == 0) {
            this.purgeConfig = this.purgeType.equals(PURGE_TYPE_REPOSITORY) ? new RepositoryPurgeConfiguration() : new DirectoryPurgeConfiguration();
            this.purgeConfig = this.setupPurgeConfiguration(this.purgeConfig);
            this.purgeConfig = this.purgeConfigService.addPurgeConfiguration(this.purgeConfig);
        } else {
            this.purgeConfig = this.purgeConfigService.getPurgeConfiguration(this.purgeConfigId);
            this.purgeConfig = this.setupPurgeConfiguration(this.purgeConfig);
            this.purgeConfigService.updatePurgeConfiguration(this.purgeConfig);
        }
        if (this.purgeConfig.isDefaultPurge()) {
            this.updateDefaultPurgeConfiguration();
        }
        return "success";
    }

    public String remove() throws Exception {
        this.purgeConfigService.removePurgeConfiguration(this.purgeConfigId);
        return "success";
    }

    public String purge() throws Exception {
        ContinuumPurgeManager purgeManager = this.getContinuum().getPurgeManager();
        if (this.purgeConfigId > 0) {
            this.purgeConfig = this.purgeConfigService.getPurgeConfiguration(this.purgeConfigId);
            if (this.purgeConfig instanceof RepositoryPurgeConfiguration) {
                RepositoryPurgeConfiguration repoPurge = (RepositoryPurgeConfiguration)this.purgeConfig;
                if (purgeManager.isRepositoryInUse(repoPurge.getRepository().getId())) {
                    this.message = "repository.error.purge.in.use";
                    return "error";
                }
                purgeManager.purgeRepository(repoPurge);
            } else {
                DirectoryPurgeConfiguration dirPurge = (DirectoryPurgeConfiguration)this.purgeConfig;
                purgeManager.purgeDirectory(dirPurge);
            }
        }
        return "success";
    }

    public String getPurgeType() {
        return this.purgeType;
    }

    public void setPurgeType(String purgeType) {
        this.purgeType = purgeType;
    }

    public String getDirectoryType() {
        return this.directoryType;
    }

    public void setDirectoryType(String directoryType) {
        this.directoryType = directoryType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isDeleteAll() {
        return this.deleteAll;
    }

    public void setDeleteAll(boolean deleteAll) {
        this.deleteAll = deleteAll;
    }

    public boolean isDeleteReleasedSnapshots() {
        return this.deleteReleasedSnapshots;
    }

    public void setDeleteReleasedSnapshots(boolean deleteReleasedSnapshots) {
        this.deleteReleasedSnapshots = deleteReleasedSnapshots;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public boolean isDefaultPurgeConfiguration() {
        return this.defaultPurgeConfiguration;
    }

    public void setDefaultPurgeConfiguration(boolean defaultPurgeConfiguration) {
        this.defaultPurgeConfiguration = defaultPurgeConfiguration;
    }

    public int getRetentionCount() {
        return this.retentionCount;
    }

    public void setRetentionCount(int retentionCount) {
        this.retentionCount = retentionCount;
    }

    public int getDaysOlder() {
        return this.daysOlder;
    }

    public void setDaysOlder(int daysOlder) {
        this.daysOlder = daysOlder;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(int repositoryId) {
        this.repositoryId = repositoryId;
    }

    public int getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(int scheduleId) {
        this.scheduleId = scheduleId;
    }

    public int getPurgeConfigId() {
        return this.purgeConfigId;
    }

    public void setPurgeConfigId(int purgeConfigId) {
        this.purgeConfigId = purgeConfigId;
    }

    public AbstractPurgeConfiguration getPurgeConfig() {
        return this.purgeConfig;
    }

    public void setPurgeConfig(AbstractPurgeConfiguration purgeConfig) {
        this.purgeConfig = purgeConfig;
    }

    public Map<Integer, String> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(Map<Integer, String> repositories) {
        this.repositories = repositories;
    }

    public Map<Integer, String> getSchedules() {
        return this.schedules;
    }

    public void setSchedules(Map<Integer, String> schedules) {
        this.schedules = schedules;
    }

    public List<RepositoryPurgeConfiguration> getRepoPurgeConfigs() {
        return this.repoPurgeConfigs;
    }

    public void setRepoPurgeConfigs(List<RepositoryPurgeConfiguration> repoPurgeConfigs) {
        this.repoPurgeConfigs = repoPurgeConfigs;
    }

    public List<DirectoryPurgeConfiguration> getDirPurgeConfigs() {
        return this.dirPurgeConfigs;
    }

    public void setDirPurgeConfigs(List<DirectoryPurgeConfiguration> dirPurgeConfigs) {
        this.dirPurgeConfigs = dirPurgeConfigs;
    }

    public List<String> getDirectoryTypes() {
        return this.directoryTypes;
    }

    public void setDirectoryTypes(List<String> directoryTypes) {
        this.directoryTypes = directoryTypes;
    }

    private AbstractPurgeConfiguration setupPurgeConfiguration(AbstractPurgeConfiguration purgeConfiguration) throws Exception {
        if (purgeConfiguration instanceof RepositoryPurgeConfiguration) {
            return this.buildRepoPurgeConfiguration();
        }
        return this.buildDirPurgeConfiguration();
    }

    private RepositoryPurgeConfiguration buildRepoPurgeConfiguration() throws Exception {
        RepositoryPurgeConfiguration repoPurge = (RepositoryPurgeConfiguration)this.purgeConfig;
        repoPurge.setDeleteAll(this.deleteAll);
        repoPurge.setDeleteReleasedSnapshots(this.deleteReleasedSnapshots);
        repoPurge.setDaysOlder(this.daysOlder);
        repoPurge.setRetentionCount(this.retentionCount);
        repoPurge.setEnabled(this.enabled);
        repoPurge.setDefaultPurge(this.defaultPurgeConfiguration);
        repoPurge.setDescription(this.description);
        repoPurge.setDefaultPurge(this.defaultPurgeConfiguration);
        if (this.repositoryId != 0) {
            LocalRepository repository = this.repositoryService.getLocalRepository(this.repositoryId);
            repoPurge.setRepository(repository);
        }
        if (this.scheduleId > 0) {
            Schedule schedule = this.getContinuum().getSchedule(this.scheduleId);
            repoPurge.setSchedule(schedule);
        }
        return repoPurge;
    }

    private DirectoryPurgeConfiguration buildDirPurgeConfiguration() throws Exception {
        DirectoryPurgeConfiguration dirPurge = (DirectoryPurgeConfiguration)this.purgeConfig;
        dirPurge.setDeleteAll(this.deleteAll);
        dirPurge.setEnabled(this.enabled);
        dirPurge.setDaysOlder(this.daysOlder);
        dirPurge.setRetentionCount(this.retentionCount);
        dirPurge.setDescription(this.description);
        dirPurge.setDirectoryType(this.directoryType);
        dirPurge.setDefaultPurge(this.defaultPurgeConfiguration);
        if (this.scheduleId > 0) {
            Schedule schedule = this.getContinuum().getSchedule(this.scheduleId);
            dirPurge.setSchedule(schedule);
        }
        ConfigurationService configService = this.getContinuum().getConfiguration();
        String path = null;
        if (this.directoryType.equals(PURGE_DIRECTORY_RELEASES)) {
            path = configService.getWorkingDirectory().getAbsolutePath();
        } else if (this.directoryType.equals(PURGE_DIRECTORY_BUILDOUTPUT)) {
            path = configService.getBuildOutputDirectory().getAbsolutePath();
        }
        dirPurge.setLocation(path);
        return dirPurge;
    }

    private void updateDefaultPurgeConfiguration() throws Exception {
        DirectoryPurgeConfiguration dirPurge;
        if (this.purgeConfig instanceof RepositoryPurgeConfiguration) {
            RepositoryPurgeConfiguration repoPurge = this.purgeConfigService.getDefaultPurgeConfigurationForRepository(this.repositoryId);
            if (repoPurge != null && repoPurge.getId() != this.purgeConfig.getId()) {
                repoPurge.setDefaultPurge(false);
                this.purgeConfigService.updateRepositoryPurgeConfiguration(repoPurge);
            }
        } else if (this.purgeConfig instanceof DirectoryPurgeConfiguration && (dirPurge = this.purgeConfigService.getDefaultPurgeConfigurationForDirectoryType(this.directoryType)) != null && dirPurge.getId() != this.purgeConfig.getId()) {
            dirPurge.setDefaultPurge(false);
            this.purgeConfigService.updateDirectoryPurgeConfiguration(dirPurge);
        }
    }

    public SecureActionBundle getSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("continuum-manage-purging", "*");
        return bundle;
    }
}

