/*
 * Decompiled with CFR 0.152.
 */
package org.apache.continuum.web.action.admin;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.Preparable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.continuum.model.repository.LocalRepository;
import org.apache.continuum.model.repository.RepositoryPurgeConfiguration;
import org.apache.continuum.purge.ContinuumPurgeManager;
import org.apache.continuum.purge.PurgeConfigurationService;
import org.apache.continuum.repository.RepositoryService;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.web.action.ContinuumConfirmAction;
import org.codehaus.plexus.redback.xwork.interceptor.SecureAction;
import org.codehaus.plexus.redback.xwork.interceptor.SecureActionBundle;
import org.codehaus.plexus.redback.xwork.interceptor.SecureActionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalRepositoryAction
extends ContinuumConfirmAction
implements Preparable,
SecureAction {
    private static final String LAYOUT_DEFAULT = "default";
    private static final String LAYOUT_LEGACY = "legacy";
    private boolean confirmed;
    private boolean defaultRepo;
    private LocalRepository repository;
    private List<LocalRepository> repositories;
    private List<ProjectGroup> groups;
    private List<String> layouts;
    private Map<String, Boolean> defaultPurgeMap;
    private String message;
    private RepositoryService repositoryService;
    private PurgeConfigurationService purgeConfigService;

    public void prepare() throws Exception {
        super.prepare();
        this.layouts = new ArrayList();
        this.layouts.add(LAYOUT_DEFAULT);
        this.layouts.add(LAYOUT_LEGACY);
    }

    public String input() throws Exception {
        this.defaultRepo = false;
        if (this.repository != null && this.repository.getId() > 0) {
            this.repository = this.repositoryService.getLocalRepository(this.repository.getId());
            if (this.repository.getName().equals("DEFAULT")) {
                this.defaultRepo = true;
            }
        }
        return "input";
    }

    public String list() throws Exception {
        String errorMessage = ServletActionContext.getRequest().getParameter("errorMessage");
        if (errorMessage != null) {
            this.addActionError(errorMessage);
        }
        this.repositories = this.repositoryService.getAllLocalRepositories();
        this.defaultPurgeMap = new HashMap();
        for (LocalRepository repo : this.repositories) {
            RepositoryPurgeConfiguration purgeConfig = this.purgeConfigService.getDefaultPurgeConfigurationForRepository(repo.getId());
            if (purgeConfig == null) {
                this.defaultPurgeMap.put(repo.getName(), Boolean.FALSE);
                continue;
            }
            this.defaultPurgeMap.put(repo.getName(), Boolean.TRUE);
        }
        return "success";
    }

    public String save() throws Exception {
        List allRepositories = this.repositoryService.getAllLocalRepositories();
        for (LocalRepository repo : allRepositories) {
            if (this.repository.getId() == repo.getId()) continue;
            if (this.repository.getName().equals(repo.getName())) {
                this.addActionError("repository.error.name.unique");
            }
            if (!this.repository.getLocation().equals(repo.getLocation())) continue;
            this.addActionError("repository.error.location.unique");
        }
        if (this.repository.getName().trim().equals("")) {
            this.addActionError("repository.error.name.cannot.be.spaces");
        }
        if (this.repository.getLocation().trim().equals("")) {
            this.addActionError("repository.error.location.cannot.be.spaces");
        }
        if (this.hasActionErrors()) {
            return "input";
        }
        if (this.repository.getId() == 0) {
            this.repository = this.repositoryService.addLocalRepository(this.repository);
            this.createDefaultPurgeConfiguration();
        } else {
            ContinuumPurgeManager purgeManager = this.getContinuum().getPurgeManager();
            if (purgeManager.isRepositoryInUse(this.repository.getId())) {
                this.addActionError("repository.error.save.in.use");
                return "error";
            }
            LocalRepository retrievedRepo = this.repositoryService.getLocalRepository(this.repository.getId());
            retrievedRepo.setName(this.repository.getName());
            retrievedRepo.setLocation(this.repository.getLocation());
            retrievedRepo.setLayout(this.repository.getLayout());
            this.repositoryService.updateLocalRepository(retrievedRepo);
        }
        return "success";
    }

    public String remove() throws Exception {
        ContinuumPurgeManager purgeManager = this.getContinuum().getPurgeManager();
        if (purgeManager.isRepositoryInUse(this.repository.getId())) {
            this.message = "repository.error.remove.in.use";
            return "error";
        }
        this.repository = this.repositoryService.getLocalRepository(this.repository.getId());
        if (this.repository.getName().equals("DEFAULT")) {
            this.message = "repository.error.remove.default";
            return "error";
        }
        if (!this.confirmed) {
            return "confirm";
        }
        this.repositoryService.removeLocalRepository(this.repository.getId());
        return "success";
    }

    public String doPurge() throws Exception {
        ContinuumPurgeManager purgeManager = this.getContinuum().getPurgeManager();
        if (purgeManager.isRepositoryInUse(this.repository.getId())) {
            this.message = "repository.error.purge.in.use";
            return "error";
        }
        RepositoryPurgeConfiguration purgeConfig = this.purgeConfigService.getDefaultPurgeConfigurationForRepository(this.repository.getId());
        if (purgeConfig != null) {
            purgeManager.purgeRepository(purgeConfig);
        }
        return "success";
    }

    public LocalRepository getRepository() {
        return this.repository;
    }

    public void setRepository(LocalRepository repository) {
        this.repository = repository;
    }

    public List<LocalRepository> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<LocalRepository> repositories) {
        this.repositories = repositories;
    }

    public List<ProjectGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<ProjectGroup> groups) {
        this.groups = groups;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public boolean isDefaultRepo() {
        return this.defaultRepo;
    }

    public void setDefaultRepo(boolean defaultRepo) {
        this.defaultRepo = defaultRepo;
    }

    public List<String> getLayouts() {
        return this.layouts;
    }

    public Map<String, Boolean> getDefaultPurgeMap() {
        return this.defaultPurgeMap;
    }

    public void setDefaultPurgeMap(Map<String, Boolean> defaultPurgeMap) {
        this.defaultPurgeMap = defaultPurgeMap;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private void createDefaultPurgeConfiguration() throws Exception {
        RepositoryPurgeConfiguration repoPurge = new RepositoryPurgeConfiguration();
        repoPurge.setRepository(this.repository);
        repoPurge.setDefaultPurge(true);
        this.purgeConfigService.addRepositoryPurgeConfiguration(repoPurge);
    }

    public SecureActionBundle getSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("continuum-manage-repositories", "*");
        return bundle;
    }
}

