/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.reports.surefire;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.continuum.reports.surefire.ReportFailure;
import org.apache.maven.continuum.reports.surefire.ReportTestCase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportTestSuite
extends DefaultHandler {
    private List<ReportTestCase> testCases;
    private int numberOfErrors;
    private int numberOfFailures;
    private int numberOfTests;
    private String name;
    private String fullClassName;
    private String packageName;
    private float timeElapsed;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private StringBuffer currentElement;
    private ReportTestCase testCase;
    private List<ReportFailure> reportFailures;

    public void parse(String xmlPath) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(new File(xmlPath), (DefaultHandler)this);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if ("testsuite".equals(qName)) {
                this.numberOfErrors = Integer.parseInt(attributes.getValue("errors"));
                this.numberOfFailures = Integer.parseInt(attributes.getValue("failures"));
                this.numberOfTests = Integer.parseInt(attributes.getValue("tests"));
                Number time = this.numberFormat.parse(attributes.getValue("time"));
                this.timeElapsed = time.floatValue();
                if (attributes.getValue("group") != null && !"".equals(attributes.getValue("group"))) {
                    this.packageName = attributes.getValue("group");
                    this.name = attributes.getValue("name");
                    this.fullClassName = this.packageName + "." + this.name;
                } else {
                    this.fullClassName = attributes.getValue("name");
                    this.name = this.fullClassName.substring(this.fullClassName.lastIndexOf(".") + 1, this.fullClassName.length());
                    int lastDotPosition = this.fullClassName.lastIndexOf(".");
                    this.packageName = lastDotPosition < 0 ? "" : this.fullClassName.substring(0, lastDotPosition);
                }
                this.testCases = new LinkedList<ReportTestCase>();
            } else if ("testcase".equals(qName)) {
                this.currentElement = new StringBuffer();
                this.testCase = new ReportTestCase();
                this.testCase.setFullClassName(this.fullClassName);
                this.testCase.setName(attributes.getValue("name"));
                this.testCase.setClassName(this.name);
                String timeAsString = attributes.getValue("time");
                Number time = new Integer(0);
                if (timeAsString != null) {
                    time = this.numberFormat.parse(timeAsString);
                }
                this.testCase.setTime(((Number)time).floatValue());
                this.testCase.setFullName(this.packageName + "." + this.name + "." + this.testCase.getName());
            } else if ("failure".equals(qName)) {
                this.testCase.setFailureType(attributes.getValue("type"));
                this.testCase.setFailureMessage(attributes.getValue("message"));
            } else if ("error".equals(qName)) {
                this.testCase.setFailureType(attributes.getValue("type"));
                this.testCase.setFailureMessage(attributes.getValue("message"));
            }
        }
        catch (ParseException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("testcase".equals(qName)) {
            this.testCases.add(this.testCase);
        } else if ("failure".equals(qName)) {
            this.testCase.setFailureDetails(this.currentElement.toString());
            this.addReportFailure(new ReportFailure(this.testCase.getFailureType(), this.testCase.getFailureDetails(), this.testCase.getName()));
        } else if ("error".equals(qName)) {
            this.testCase.setFailureDetails(this.currentElement.toString());
            this.addReportFailure(new ReportFailure(this.testCase.getFailureType(), this.testCase.getFailureDetails(), this.testCase.getName()));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        if (!"".equals(s.trim())) {
            this.currentElement.append(s);
        }
    }

    public List<ReportTestCase> getTestCases() {
        return this.testCases;
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public void setNumberOfErrors(int numberOfErrors) {
        this.numberOfErrors = numberOfErrors;
    }

    public int getNumberOfFailures() {
        return this.numberOfFailures;
    }

    public void setNumberOfFailures(int numberOfFailures) {
        this.numberOfFailures = numberOfFailures;
    }

    public int getNumberOfTests() {
        return this.numberOfTests;
    }

    public void setNumberOfTests(int numberOfTests) {
        this.numberOfTests = numberOfTests;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFName() {
        return this.name;
    }

    public void setFName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public float getTimeElapsed() {
        return this.timeElapsed;
    }

    public void setTimeElapsed(float timeElapsed) {
        this.timeElapsed = timeElapsed;
    }

    public void setTestCases(List<ReportTestCase> testCases) {
        this.testCases = Collections.unmodifiableList(testCases);
    }

    public List<ReportFailure> getReportFailures() {
        return this.reportFailures == null ? Collections.EMPTY_LIST : this.reportFailures;
    }

    public void setReportFailures(List<ReportFailure> reportFailures) {
        this.reportFailures = reportFailures;
    }

    public void addReportFailure(ReportFailure reportFailure) {
        if (this.reportFailures == null) {
            this.reportFailures = new LinkedList<ReportFailure>();
        }
        this.reportFailures.add(reportFailure);
    }
}

