/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.reports.surefire;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.continuum.configuration.ConfigurationException;
import org.apache.maven.continuum.configuration.ConfigurationService;
import org.apache.maven.continuum.reports.surefire.ReportTestResult;
import org.apache.maven.continuum.reports.surefire.ReportTestSuite;
import org.apache.maven.continuum.reports.surefire.ReportTestSuiteGenerator;
import org.apache.maven.continuum.reports.surefire.ReportTestSuiteGeneratorException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReportTestSuiteGenerator
implements ReportTestSuiteGenerator,
Initializable {
    private ConfigurationService configurationService;
    private List<String> defaultIncludes;
    private List<String> defaultexcludes;

    public void initialize() throws InitializationException {
        this.defaultIncludes = new ArrayList<String>(1);
        this.defaultIncludes.add("*.xml");
        this.defaultexcludes = new ArrayList<String>(1);
        this.defaultexcludes.add("*.txt");
    }

    @Override
    public List<ReportTestSuite> generateReports(File directory, List<String> includes, List<String> excludes) throws ReportTestSuiteGeneratorException {
        if (directory == null) {
            return Collections.EMPTY_LIST;
        }
        if (!directory.exists()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<ReportTestSuite> reportTestSuites = new LinkedList<ReportTestSuite>();
        String[] includesArray = null;
        includesArray = includes == null ? new String[]{} : includes.toArray(new String[includes.size()]);
        String[] excludesArray = null;
        excludesArray = excludes == null ? new String[]{} : excludes.toArray(new String[excludes.size()]);
        String[] xmlReportFiles = this.getIncludedFiles(directory, includesArray, excludesArray);
        if (xmlReportFiles == null) {
            return Collections.EMPTY_LIST;
        }
        if (xmlReportFiles.length == 0) {
            return Collections.EMPTY_LIST;
        }
        for (int index = 0; index < xmlReportFiles.length; ++index) {
            ReportTestSuite testSuite = new ReportTestSuite();
            String currentReport = xmlReportFiles[index];
            try {
                testSuite.parse(directory + File.separator + currentReport);
            }
            catch (ParserConfigurationException e) {
                throw new ReportTestSuiteGeneratorException("Error setting up parser for Surefire XML report", e);
            }
            catch (SAXException e) {
                throw new ReportTestSuiteGeneratorException("Error parsing Surefire XML report " + currentReport, e);
            }
            catch (IOException e) {
                throw new ReportTestSuiteGeneratorException("Error reading Surefire XML report " + currentReport, e);
            }
            reportTestSuites.add(testSuite);
        }
        return reportTestSuites;
    }

    @Override
    public List<ReportTestSuite> generateReports(File directory) throws ReportTestSuiteGeneratorException {
        return this.generateReports(directory, this.defaultIncludes, this.defaultexcludes);
    }

    @Override
    public List<ReportTestSuite> generateReports(int buildId, int projectId) throws ReportTestSuiteGeneratorException {
        try {
            File directory = this.configurationService.getTestReportsDirectory(buildId, projectId);
            return this.generateReports(directory);
        }
        catch (ConfigurationException e) {
            throw new ReportTestSuiteGeneratorException(e.getMessage(), e);
        }
    }

    @Override
    public ReportTestResult generateReportTestResult(int buildId, int projectId) throws ReportTestSuiteGeneratorException {
        List<ReportTestSuite> reportTestSuites = this.generateReports(buildId, projectId);
        ReportTestResult reportTestResult = new ReportTestResult();
        for (ReportTestSuite reportTestSuite : reportTestSuites) {
            reportTestResult.addReportTestSuite(reportTestSuite);
        }
        return reportTestResult;
    }

    private String[] getIncludedFiles(File directory, String[] includes, String[] excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

