/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.release.phase;

import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.plexus.PlexusLogger;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmUrlUtils;
import org.apache.maven.scm.provider.git.gitexe.command.branch.GitBranchCommand;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;

public class UpdateWorkingCopyPhase
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;
    private boolean copyUpdated = false;

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ScmProvider provider;
        ScmRepository repository;
        ReleaseResult relResult = new ReleaseResult();
        this.logInfo(relResult, "Updating local copy against the scm...");
        String providerType = ScmUrlUtils.getProvider((String)releaseDescriptor.getScmSourceUrl());
        String scmSpecificUrl = releaseDescriptor.getScmSourceUrl().substring(providerType.length() + 5);
        if (providerType.contains("git") && scmSpecificUrl.startsWith("ssh")) {
            scmSpecificUrl = scmSpecificUrl.substring("ssh".length() + 3);
            int indexAt = scmSpecificUrl.indexOf("@");
            String sshScmUsername = "";
            String sshScmPassword = "";
            if (indexAt >= 0) {
                String userInfo;
                sshScmUsername = userInfo = scmSpecificUrl.substring(0, indexAt);
                int indexPwdSep = userInfo.indexOf(":");
                if (indexPwdSep < 0) {
                    sshScmUsername = userInfo.substring(indexPwdSep + 1);
                } else {
                    sshScmUsername = userInfo.substring(0, indexPwdSep);
                    sshScmPassword = userInfo.substring(indexPwdSep + 1);
                }
            }
            if (!StringUtils.isBlank((String)sshScmUsername)) {
                releaseDescriptor.setScmUsername(sshScmUsername);
                if (!StringUtils.isBlank((String)sshScmPassword)) {
                    releaseDescriptor.setScmPassword(sshScmPassword);
                } else {
                    releaseDescriptor.setScmPassword(null);
                }
            }
        }
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, settings);
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage() + " for URL: " + releaseDescriptor.getScmSourceUrl(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), (Throwable)e);
        }
        UpdateScmResult updateScmResult = null;
        CheckOutScmResult checkOutScmResult = null;
        File workingDirectory = new File(releaseDescriptor.getWorkingDirectory());
        ScmFileSet workingDirSet = new ScmFileSet(workingDirectory);
        try {
            if (!workingDirectory.exists()) {
                workingDirectory.mkdirs();
            }
            ScmBranch scmTag = null;
            ScmProviderRepository providerRepo = repository.getProviderRepository();
            if (providerRepo instanceof GitScmProviderRepository) {
                String branchName = GitBranchCommand.getCurrentBranch((ScmLogger)new PlexusLogger(this.getLogger()), (GitScmProviderRepository)((GitScmProviderRepository)providerRepo), (ScmFileSet)workingDirSet);
                scmTag = new ScmBranch(branchName);
            }
            if (workingDirectory.listFiles().length > 1) {
                updateScmResult = provider.update(repository, workingDirSet, scmTag);
            } else {
                checkOutScmResult = provider.checkOut(repository, new ScmFileSet(workingDirectory));
                checkOutScmResult = provider.checkOut(repository, workingDirSet, (ScmVersion)scmTag);
            }
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error occurred while updating your local copy: " + e.getMessage(), (Throwable)e);
        }
        if (updateScmResult != null) {
            if (!updateScmResult.isSuccess()) {
                throw new ReleaseScmCommandException("Unable to update current working copy", (ScmResult)updateScmResult);
            }
            this.copyUpdated = updateScmResult.getUpdatedFiles().size() > 0;
        } else {
            if (!checkOutScmResult.isSuccess()) {
                throw new ReleaseScmCommandException("Unable to checkout project", (ScmResult)checkOutScmResult);
            }
            this.copyUpdated = checkOutScmResult.getCheckedOutFiles().size() > 0;
        }
        relResult.setResultCode(0);
        return relResult;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, settings, reactorProjects);
    }

    public boolean isCopyUpdated() {
        return this.copyUpdated;
    }

    public void setCopyUpdated(boolean copyUpdated) {
        this.copyUpdated = copyUpdated;
    }

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, releaseEnvironment.getSettings(), reactorProjects);
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, releaseEnvironment.getSettings(), reactorProjects);
    }
}

