/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.release.phase;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.continuum.release.ContinuumReleaseException;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MissingProjectException;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectSorter;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateReactorProjectsPhase
extends AbstractReleasePhase
implements Contextualizable {
    private MavenProjectBuilder projectBuilder;
    private MavenSettingsBuilder settingsBuilder;
    private PlexusContainer container;
    private static final char SET_SYSTEM_PROPERTY = 'D';
    private static final char ACTIVATE_PROFILES = 'P';

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        try {
            reactorProjects.addAll(this.getReactorProjects(releaseDescriptor));
        }
        catch (ContinuumReleaseException e) {
            throw new ReleaseExecutionException("Unable to get reactor projects: " + e.getMessage(), (Throwable)e);
        }
        result.setResultCode(0);
        return result;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, settings, reactorProjects);
    }

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, releaseEnvironment.getSettings(), reactorProjects);
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, releaseEnvironment.getSettings(), reactorProjects);
    }

    private List getReactorProjects(ReleaseDescriptor descriptor) throws ContinuumReleaseException {
        List<Object> reactorProjects = new ArrayList<MavenProject>();
        try {
            String arguments = descriptor.getAdditionalArguments();
            ArtifactRepository repository = this.getLocalRepository(arguments);
            ProfileManager profileManager = this.getProfileManager(this.getSettings());
            if (arguments != null) {
                this.activateProfiles(arguments, profileManager);
            }
            MavenProject project = this.projectBuilder.build(this.getProjectDescriptorFile(descriptor), repository, profileManager);
            reactorProjects.add(project);
            this.addModules(reactorProjects, project, repository);
        }
        catch (ParseException e) {
            throw new ContinuumReleaseException("Unable to parse arguments.", (Throwable)e);
        }
        catch (ProjectBuildingException e) {
            throw new ContinuumReleaseException("Failed to build project.", (Throwable)e);
        }
        try {
            reactorProjects = new ProjectSorter(reactorProjects).getSortedProjects();
        }
        catch (CycleDetectedException e) {
            throw new ContinuumReleaseException("Failed to sort projects.", (Throwable)e);
        }
        catch (DuplicateProjectException e) {
            throw new ContinuumReleaseException("Failed to sort projects.", (Throwable)e);
        }
        catch (MissingProjectException e) {
            throw new ContinuumReleaseException("Failed to sort projects.", (Throwable)e);
        }
        return reactorProjects;
    }

    private void addModules(List<MavenProject> reactorProjects, MavenProject project, ArtifactRepository repository) throws ContinuumReleaseException {
        for (Object o : project.getModules()) {
            String moduleDir = StringUtils.replace((String)o.toString(), (char)'\\', (char)'/');
            File pomFile = new File(project.getBasedir(), moduleDir + "/pom.xml");
            try {
                MavenProject reactorProject = this.projectBuilder.build(pomFile, repository, this.getProfileManager(this.getSettings()));
                reactorProjects.add(reactorProject);
                this.addModules(reactorProjects, reactorProject, repository);
            }
            catch (ProjectBuildingException e) {
                throw new ContinuumReleaseException("Failed to build project.", (Throwable)e);
            }
        }
    }

    private File getProjectDescriptorFile(ReleaseDescriptor descriptor) {
        String parentPath = descriptor.getWorkingDirectory();
        String pomFilename = descriptor.getPomFileName();
        if (pomFilename == null) {
            pomFilename = "pom.xml";
        }
        return new File(parentPath, pomFilename);
    }

    private ArtifactRepository getLocalRepository(String arguments) throws ContinuumReleaseException {
        String localRepository = null;
        boolean found = false;
        if (arguments != null) {
            String[] args;
            for (String arg : args = arguments.split(" ")) {
                if (arg.contains("-Dmaven.repo.local=")) {
                    localRepository = arg.substring(arg.indexOf("=") + 1);
                    if (localRepository.endsWith("\"")) {
                        localRepository = localRepository.substring(0, localRepository.indexOf("\""));
                        break;
                    }
                    found = true;
                    continue;
                }
                if (!found || !(localRepository = localRepository + " " + arg).endsWith("\"")) continue;
                localRepository = localRepository.substring(0, localRepository.indexOf("\""));
                break;
            }
        }
        if (localRepository == null) {
            localRepository = this.getSettings().getLocalRepository();
        }
        return new DefaultArtifactRepository("local-repository", "file://" + localRepository, (ArtifactRepositoryLayout)new DefaultRepositoryLayout());
    }

    private ProfileManager getProfileManager(Settings settings) {
        Properties props = new Properties();
        return new DefaultProfileManager(this.container, settings, props);
    }

    private Settings getSettings() throws ContinuumReleaseException {
        try {
            return this.settingsBuilder.buildSettings();
        }
        catch (IOException e) {
            throw new ContinuumReleaseException("Failed to get Maven Settings.", (Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new ContinuumReleaseException("Failed to get Maven Settings.", (Throwable)e);
        }
    }

    private void activateProfiles(String arguments, ProfileManager profileManager) throws ParseException {
        String[] profileOptionValues;
        GnuParser parser = new GnuParser();
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"activate-profiles");
        OptionBuilder.withDescription((String)"Comma-delimited list of profiles to activate");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'P'));
        OptionBuilder.withLongOpt((String)"define");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Define a system property");
        options.addOption(OptionBuilder.create((char)'D'));
        String[] args = StringUtils.split((String)arguments);
        CommandLine commandLine = parser.parse(options, args);
        if (commandLine.hasOption('P') && (profileOptionValues = commandLine.getOptionValues('P')) != null) {
            for (int i = 0; i < profileOptionValues.length; ++i) {
                StringTokenizer profileTokens = new StringTokenizer(profileOptionValues[i], ",");
                while (profileTokens.hasMoreTokens()) {
                    String profileAction = profileTokens.nextToken().trim();
                    if (profileAction.startsWith("-") || profileAction.startsWith("!")) {
                        profileManager.explicitlyDeactivate(profileAction.substring(1));
                        continue;
                    }
                    if (profileAction.startsWith("+")) {
                        profileManager.explicitlyActivate(profileAction.substring(1));
                        continue;
                    }
                    profileManager.explicitlyActivate(profileAction);
                }
            }
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

