/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.release.executors;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.continuum.model.repository.LocalRepository;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.continuum.release.ContinuumReleaseException;
import org.apache.maven.continuum.release.executors.AbstractReleaseTaskExecutor;
import org.apache.maven.continuum.release.tasks.PerformReleaseProjectTask;
import org.apache.maven.continuum.release.tasks.ReleaseProjectTask;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MissingProjectException;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectSorter;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseManagerListener;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.DefaultReleaseEnvironment;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.taskqueue.execution.TaskExecutionException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformReleaseTaskExecutor
extends AbstractReleaseTaskExecutor
implements Contextualizable {
    private MavenProjectBuilder projectBuilder;
    private ProfileManager profileManager;
    private PlexusContainer container;
    private LocalRepository repository;

    @Override
    public void execute(ReleaseProjectTask task) throws TaskExecutionException {
        List<MavenProject> reactorProjects;
        PerformReleaseProjectTask performTask = (PerformReleaseProjectTask)task;
        ReleaseManagerListener listener = performTask.getListener();
        ReleaseDescriptor descriptor = performTask.getDescriptor();
        descriptor.setUseReleaseProfile(performTask.isUseReleaseProfile());
        descriptor.setPerformGoals(performTask.getGoals());
        descriptor.setCheckoutDirectory(performTask.getBuildDirectory().getAbsolutePath());
        this.repository = performTask.getLocalRepository();
        try {
            if (!StringUtils.isEmpty((String)descriptor.getWorkingDirectory())) {
                MavenProject mavenProject = this.getMavenProject(performTask);
                reactorProjects = this.getReactorProjects(descriptor, mavenProject);
            } else {
                descriptor.setCheckoutDirectory(performTask.getBuildDirectory().getAbsolutePath());
                MavenProject project = new MavenProject();
                project.setFile(new File(descriptor.getCheckoutDirectory(), "pom.xml"));
                reactorProjects = Collections.singletonList(project);
            }
        }
        catch (ContinuumReleaseException e) {
            ReleaseResult result = this.createReleaseResult();
            result.appendError((Exception)((Object)e));
            this.continuumReleaseManager.getReleaseResults().put(performTask.getReleaseId(), result);
            performTask.getListener().error(e.getMessage());
            throw new TaskExecutionException("Failed to build reactor projects.", (Throwable)e);
        }
        ReleaseResult result = this.releaseManager.performWithResult(descriptor, new DefaultReleaseEnvironment().setSettings(this.settings), reactorProjects, listener);
        result.setStartTime(this.getStartTime());
        if (result.getResultCode() == 0) {
            this.continuumReleaseManager.getPreparedReleases().remove(performTask.getReleaseId());
        }
        this.continuumReleaseManager.getReleaseResults().put(performTask.getReleaseId(), result);
    }

    protected List<MavenProject> getReactorProjects(ReleaseDescriptor descriptor, MavenProject project) throws ContinuumReleaseException {
        List<Object> reactorProjects = new ArrayList<MavenProject>();
        reactorProjects.add(project);
        this.addModules(reactorProjects, project);
        try {
            reactorProjects = new ProjectSorter(reactorProjects).getSortedProjects();
        }
        catch (CycleDetectedException e) {
            throw new ContinuumReleaseException("Failed to sort projects.", (Throwable)e);
        }
        catch (DuplicateProjectException e) {
            throw new ContinuumReleaseException("Failed to sort projects.", (Throwable)e);
        }
        catch (MissingProjectException e) {
            throw new ContinuumReleaseException("Failed to sort projects.", (Throwable)e);
        }
        return reactorProjects;
    }

    private void addModules(List<MavenProject> reactorProjects, MavenProject project) throws ContinuumReleaseException {
        for (Object o : project.getModules()) {
            String moduleDir = o.toString();
            File pomFile = new File(project.getBasedir(), moduleDir + "/pom.xml");
            try {
                MavenProject reactorProject = this.projectBuilder.build(pomFile, this.getLocalRepository(), this.getProfileManager(this.settings));
                reactorProjects.add(reactorProject);
                this.addModules(reactorProjects, reactorProject);
            }
            catch (ProjectBuildingException e) {
                throw new ContinuumReleaseException("Failed to build project.", (Throwable)e);
            }
        }
    }

    private File getProjectDescriptorFile(ReleaseDescriptor descriptor) {
        String parentPath = descriptor.getWorkingDirectory();
        String pomFilename = descriptor.getPomFileName();
        if (pomFilename == null) {
            pomFilename = "pom.xml";
        }
        return new File(parentPath, pomFilename);
    }

    private ArtifactRepository getLocalRepository() {
        if (this.repository == null) {
            return new DefaultArtifactRepository("local-repository", "file://" + this.settings.getLocalRepository(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout());
        }
        return new DefaultArtifactRepository(this.repository.getName(), "file://" + this.repository.getLocation(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout());
    }

    private ProfileManager getProfileManager(Settings settings) {
        if (this.profileManager == null) {
            this.profileManager = new DefaultProfileManager(this.container, settings);
        }
        return this.profileManager;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    protected MavenProject getMavenProject(PerformReleaseProjectTask releaseTask) throws ContinuumReleaseException {
        MavenProject project;
        ReleaseDescriptor descriptor = releaseTask.getDescriptor();
        try {
            project = this.projectBuilder.build(this.getProjectDescriptorFile(descriptor), this.getLocalRepository(), this.getProfileManager(this.settings));
        }
        catch (ProjectBuildingException e) {
            throw new ContinuumReleaseException("Failed to build project.", (Throwable)e);
        }
        return project;
    }
}

