/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.release;

import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.apache.continuum.model.release.ReleaseListenerSummary;
import org.apache.continuum.model.repository.LocalRepository;
import org.apache.continuum.release.config.ContinuumReleaseDescriptor;
import org.apache.continuum.taskqueue.manager.TaskQueueManagerException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.release.ContinuumReleaseException;
import org.apache.maven.continuum.release.ContinuumReleaseManager;
import org.apache.maven.continuum.release.ContinuumReleaseManagerListener;
import org.apache.maven.continuum.release.DefaultReleaseManagerListener;
import org.apache.maven.continuum.release.tasks.PerformReleaseProjectTask;
import org.apache.maven.continuum.release.tasks.PrepareReleaseProjectTask;
import org.apache.maven.continuum.release.tasks.RollbackReleaseProjectTask;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.shared.release.ReleaseManagerListener;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseDescriptorStore;
import org.apache.maven.shared.release.config.ReleaseDescriptorStoreException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.TaskQueue;
import org.codehaus.plexus.taskqueue.TaskQueueException;
import org.codehaus.plexus.taskqueue.execution.TaskQueueExecutor;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContinuumReleaseManager
implements ContinuumReleaseManager,
Contextualizable {
    private static final String PLEXUS_KEY_PERFORM_RELEASE_TASKQUEUE_EXECUTOR = "perform-release";
    private static final String PLEXUS_KEY_PREPARE_RELEASE_TASKQUEUE_EXECUTOR = "prepare-release";
    private static final String PLEXUS_KEY_ROLLBACK_RELEASE_TASKQUEUE_EXECUTOR = "rollback-release";
    private ReleaseDescriptorStore releaseStore;
    private TaskQueue prepareReleaseQueue;
    private TaskQueue performReleaseQueue;
    private TaskQueue rollbackReleaseQueue;
    private ScmManager scmManager;
    private PlexusContainer container;
    private Map<String, ContinuumReleaseManagerListener> listeners;
    private static Map<String, ReleaseDescriptor> preparedReleases;
    private static Map releaseResults;

    public String prepare(Project project, Properties releaseProperties, Map<String, String> relVersions, Map<String, String> devVersions, ContinuumReleaseManagerListener listener, String workingDirectory) throws ContinuumReleaseException {
        return this.prepare(project, releaseProperties, relVersions, devVersions, listener, workingDirectory, null, null);
    }

    public String prepare(Project project, Properties releaseProperties, Map<String, String> relVersions, Map<String, String> devVersions, ContinuumReleaseManagerListener listener, String workingDirectory, Map<String, String> environments, String executable) throws ContinuumReleaseException {
        String releaseId = project.getGroupId() + ":" + project.getArtifactId();
        ReleaseDescriptor descriptor = this.getReleaseDescriptor(project, releaseProperties, relVersions, devVersions, environments, workingDirectory, executable);
        if (listener == null) {
            listener = new DefaultReleaseManagerListener();
            listener.setUsername(releaseProperties.getProperty("release-by"));
        }
        while (this.getPreparedReleases().get(releaseId) != null) {
            releaseId = releaseId + ":" + String.valueOf(System.currentTimeMillis());
        }
        this.getListeners().put(releaseId, listener);
        try {
            this.prepareReleaseQueue.put((Task)new PrepareReleaseProjectTask(releaseId, descriptor, (ReleaseManagerListener)listener));
        }
        catch (TaskQueueException e) {
            throw new ContinuumReleaseException("Failed to add prepare release task in queue.", (Throwable)e);
        }
        return releaseId;
    }

    public void perform(String releaseId, File buildDirectory, String goals, String arguments, boolean useReleaseProfile, ContinuumReleaseManagerListener listener) throws ContinuumReleaseException {
        this.perform(releaseId, buildDirectory, goals, arguments, useReleaseProfile, listener, null);
    }

    public void perform(String releaseId, File buildDirectory, String goals, String arguments, boolean useReleaseProfile, ContinuumReleaseManagerListener listener, LocalRepository repository) throws ContinuumReleaseException {
        ReleaseDescriptor descriptor = this.getPreparedReleases().get(releaseId);
        if (descriptor != null) {
            this.perform(releaseId, descriptor, buildDirectory, goals, arguments, useReleaseProfile, listener, repository);
        }
    }

    public void perform(String releaseId, String workingDirectory, File buildDirectory, String goals, String arguments, boolean useReleaseProfile, ContinuumReleaseManagerListener listener) throws ContinuumReleaseException {
        ReleaseDescriptor descriptor = this.readReleaseDescriptor(workingDirectory);
        this.perform(releaseId, descriptor, buildDirectory, goals, arguments, useReleaseProfile, listener, null);
    }

    private void perform(String releaseId, ReleaseDescriptor descriptor, File buildDirectory, String goals, String arguments, boolean useReleaseProfile, ContinuumReleaseManagerListener listener, LocalRepository repository) throws ContinuumReleaseException {
        if (descriptor != null) {
            descriptor.setAdditionalArguments(arguments);
        }
        if (listener == null) {
            listener = new DefaultReleaseManagerListener();
            if (descriptor instanceof ContinuumReleaseDescriptor) {
                listener.setUsername(((ContinuumReleaseDescriptor)descriptor).getReleaseBy());
            }
        }
        try {
            this.getListeners().put(releaseId, listener);
            this.performReleaseQueue.put((Task)new PerformReleaseProjectTask(releaseId, descriptor, buildDirectory, goals, useReleaseProfile, (ReleaseManagerListener)listener, repository));
        }
        catch (TaskQueueException e) {
            throw new ContinuumReleaseException("Failed to add perform release task in queue.", (Throwable)e);
        }
    }

    public void rollback(String releaseId, String workingDirectory, ContinuumReleaseManagerListener listener) throws ContinuumReleaseException {
        ReleaseDescriptor descriptor = this.readReleaseDescriptor(workingDirectory);
        if (listener == null) {
            listener = new DefaultReleaseManagerListener();
            if (descriptor instanceof ContinuumReleaseDescriptor) {
                listener.setUsername(((ContinuumReleaseDescriptor)descriptor).getReleaseBy());
            }
        }
        this.rollback(releaseId, descriptor, listener);
    }

    private void rollback(String releaseId, ReleaseDescriptor descriptor, ContinuumReleaseManagerListener listener) throws ContinuumReleaseException {
        RollbackReleaseProjectTask releaseTask = new RollbackReleaseProjectTask(releaseId, descriptor, (ReleaseManagerListener)listener);
        try {
            this.rollbackReleaseQueue.put((Task)releaseTask);
        }
        catch (TaskQueueException e) {
            throw new ContinuumReleaseException("Failed to rollback release.", (Throwable)e);
        }
    }

    public Map<String, ReleaseDescriptor> getPreparedReleases() {
        if (preparedReleases == null) {
            preparedReleases = Collections.synchronizedMap(new LinkedHashMap());
        }
        return preparedReleases;
    }

    public Map<String, String> getPreparedReleasesForProject(String groupId, String artifactId) {
        String key = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
        LinkedHashMap<String, String> projectPreparedReleases = new LinkedHashMap<String, String>();
        Map<String, ReleaseDescriptor> preparedReleases = this.getPreparedReleases();
        for (String releaseId : preparedReleases.keySet()) {
            if (!releaseId.equals(key) && !releaseId.startsWith(key + ":")) continue;
            ReleaseDescriptor descriptor = preparedReleases.get(releaseId);
            projectPreparedReleases.put(releaseId, descriptor.getReleaseVersions().get(key).toString());
        }
        return projectPreparedReleases;
    }

    public Map getReleaseResults() {
        if (releaseResults == null) {
            releaseResults = new Hashtable();
        }
        return releaseResults;
    }

    private ReleaseDescriptor getReleaseDescriptor(Project project, Properties releaseProperties, Map<String, String> relVersions, Map<String, String> devVersions, Map<String, String> environments, String workingDirectory, String executable) {
        LocalRepository repository;
        ContinuumReleaseDescriptor descriptor = new ContinuumReleaseDescriptor();
        descriptor.setWorkingDirectory(workingDirectory);
        descriptor.setScmSourceUrl(project.getScmUrl());
        descriptor.setScmReleaseLabel(releaseProperties.getProperty("scm-tag"));
        descriptor.setScmTagBase(releaseProperties.getProperty("scm-tagbase"));
        descriptor.setReleaseVersions(relVersions);
        descriptor.setDevelopmentVersions(devVersions);
        descriptor.setPreparationGoals(releaseProperties.getProperty("preparation-goals"));
        descriptor.setAdditionalArguments(releaseProperties.getProperty("arguments"));
        descriptor.setAddSchema(Boolean.valueOf(releaseProperties.getProperty("add-schema")));
        descriptor.setAutoVersionSubmodules(Boolean.valueOf(releaseProperties.getProperty("auto-version-submodules")));
        String useEditMode = releaseProperties.getProperty("use-edit-mode");
        if (BooleanUtils.toBoolean((String)useEditMode)) {
            descriptor.setScmUseEditMode(Boolean.valueOf(useEditMode));
        }
        if ((repository = project.getProjectGroup().getLocalRepository()) != null) {
            String args = descriptor.getAdditionalArguments();
            if (StringUtils.isNotEmpty((String)args)) {
                descriptor.setAdditionalArguments(args + " \"-Dmaven.repo.local=" + repository.getLocation() + "\"");
            } else {
                descriptor.setAdditionalArguments("\"-Dmaven.repo.local=" + repository.getLocation() + "\"");
            }
        }
        if (releaseProperties.containsKey("scm-username")) {
            descriptor.setScmUsername(releaseProperties.getProperty("scm-username"));
        }
        if (releaseProperties.containsKey("scm-password")) {
            descriptor.setScmPassword(releaseProperties.getProperty("scm-password"));
        }
        if (releaseProperties.containsKey("scm-comment-prefix")) {
            descriptor.setScmCommentPrefix(releaseProperties.getProperty("scm-comment-prefix"));
        }
        if (releaseProperties.containsKey("use-release-profile")) {
            descriptor.setUseReleaseProfile(Boolean.valueOf(releaseProperties.getProperty("use-release-profile")));
        }
        descriptor.setInteractive(false);
        descriptor.setEnvironments(environments);
        descriptor.setExecutable(executable);
        descriptor.setReleaseBy(releaseProperties.getProperty("release-by"));
        return descriptor;
    }

    private ReleaseDescriptor readReleaseDescriptor(String workingDirectory) throws ContinuumReleaseException {
        ContinuumReleaseDescriptor descriptor = new ContinuumReleaseDescriptor();
        descriptor.setWorkingDirectory(workingDirectory);
        try {
            descriptor = this.releaseStore.read((ReleaseDescriptor)descriptor);
        }
        catch (ReleaseDescriptorStoreException e) {
            throw new ContinuumReleaseException("Failed to parse descriptor file.", (Throwable)e);
        }
        return descriptor;
    }

    public Map<String, ContinuumReleaseManagerListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new Hashtable<String, ContinuumReleaseManagerListener>();
        }
        return this.listeners;
    }

    public String sanitizeTagName(String scmUrl, String tagName) throws Exception {
        ScmRepository scmRepo = this.scmManager.makeScmRepository(scmUrl);
        ScmProvider scmProvider = this.scmManager.getProviderByRepository(scmRepo);
        return scmProvider.sanitizeTagName(tagName);
    }

    public ReleaseListenerSummary getListener(String releaseId) {
        ContinuumReleaseManagerListener listener = this.getListeners().get(releaseId);
        if (listener != null) {
            ReleaseListenerSummary listenerSummary = new ReleaseListenerSummary();
            listenerSummary.setGoalName(listener.getGoalName());
            listenerSummary.setError(listener.getError());
            listenerSummary.setInProgress(listener.getInProgress());
            listenerSummary.setState(listener.getState());
            listenerSummary.setPhases(listener.getPhases());
            listenerSummary.setCompletedPhases(listener.getCompletedPhases());
            listenerSummary.setUsername(listener.getUsername());
            return listenerSummary;
        }
        return null;
    }

    public boolean isExecutingRelease() throws Exception {
        return this.prepareReleaseQueue.getQueueSnapshot().size() > 0 || this.performReleaseQueue.getQueueSnapshot().size() > 0 || this.rollbackReleaseQueue.getQueueSnapshot().size() > 0 || this.getPerformReleaseTaskQueueExecutor().getCurrentTask() != null || this.getPrepareReleaseTaskQueueExecutor().getCurrentTask() != null || this.getRollbackReleaseTaskQueueExecutor().getCurrentTask() != null;
    }

    public TaskQueueExecutor getPerformReleaseTaskQueueExecutor() throws TaskQueueManagerException {
        try {
            return (TaskQueueExecutor)this.container.lookup(TaskQueueExecutor.class, PLEXUS_KEY_PERFORM_RELEASE_TASKQUEUE_EXECUTOR);
        }
        catch (ComponentLookupException e) {
            throw new TaskQueueManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public TaskQueueExecutor getPrepareReleaseTaskQueueExecutor() throws TaskQueueManagerException {
        try {
            return (TaskQueueExecutor)this.container.lookup(TaskQueueExecutor.class, PLEXUS_KEY_PREPARE_RELEASE_TASKQUEUE_EXECUTOR);
        }
        catch (ComponentLookupException e) {
            throw new TaskQueueManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public TaskQueueExecutor getRollbackReleaseTaskQueueExecutor() throws TaskQueueManagerException {
        try {
            return (TaskQueueExecutor)this.container.lookup(TaskQueueExecutor.class, PLEXUS_KEY_ROLLBACK_RELEASE_TASKQUEUE_EXECUTOR);
        }
        catch (ComponentLookupException e) {
            throw new TaskQueueManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

