/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.release.phase;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;

public class UpdateWorkingCopyPhase
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;
    private boolean copyUpdated = false;

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        UpdateScmResult result;
        ScmProvider provider;
        ScmRepository repository;
        ReleaseResult relResult = new ReleaseResult();
        this.logInfo(relResult, "Updating local copy against the scm...");
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, settings);
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage() + " for URL: " + releaseDescriptor.getScmSourceUrl(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), (Throwable)e);
        }
        try {
            result = provider.update(repository, new ScmFileSet(new File(releaseDescriptor.getWorkingDirectory())), (ScmVersion)null);
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error occurred while updating your local copy: " + e.getMessage(), (Throwable)e);
        }
        if (!result.isSuccess()) {
            throw new ReleaseScmCommandException("Unable to update current working copy", (ScmResult)result);
        }
        this.copyUpdated = result.getUpdatedFiles().size() > 0;
        relResult.setResultCode(0);
        return relResult;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, settings, reactorProjects);
    }

    public boolean isCopyUpdated() {
        return this.copyUpdated;
    }

    public void setCopyUpdated(boolean copyUpdated) {
        this.copyUpdated = copyUpdated;
    }
}

