/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.release.phase;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.continuum.release.ContinuumReleaseException;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectSorter;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class GenerateReactorProjectsPhase
extends AbstractReleasePhase
implements Contextualizable {
    private MavenProjectBuilder projectBuilder;
    private MavenSettingsBuilder settingsBuilder;
    private PlexusContainer container;

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        try {
            reactorProjects.addAll(this.getReactorProjects(releaseDescriptor));
        }
        catch (ContinuumReleaseException e) {
            throw new ReleaseExecutionException("Unable to get reactor projects: " + e.getMessage(), (Throwable)e);
        }
        result.setResultCode(0);
        return result;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, settings, reactorProjects);
    }

    private List getReactorProjects(ReleaseDescriptor descriptor) throws ContinuumReleaseException {
        List<Object> reactorProjects = new ArrayList<MavenProject>();
        try {
            ArtifactRepository repository = this.getLocalRepository(descriptor.getAdditionalArguments());
            MavenProject project = this.projectBuilder.buildWithDependencies(this.getProjectDescriptorFile(descriptor), repository, this.getProfileManager(this.getSettings()));
            reactorProjects.add(project);
            this.addModules(reactorProjects, project, repository);
        }
        catch (ProjectBuildingException e) {
            throw new ContinuumReleaseException("Failed to build project.", (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new ContinuumReleaseException("Failed to build project.", (Throwable)e);
        }
        catch (ArtifactResolutionException e) {
            throw new ContinuumReleaseException("Failed to build project.", (Throwable)e);
        }
        try {
            reactorProjects = new ProjectSorter(reactorProjects).getSortedProjects();
        }
        catch (CycleDetectedException e) {
            throw new ContinuumReleaseException("Failed to sort projects.", (Throwable)e);
        }
        catch (DuplicateProjectException e) {
            throw new ContinuumReleaseException("Failed to sort projects.", (Throwable)e);
        }
        return reactorProjects;
    }

    private void addModules(List reactorProjects, MavenProject project, ArtifactRepository repository) throws ContinuumReleaseException {
        Iterator modules = project.getModules().iterator();
        while (modules.hasNext()) {
            String moduleDir = modules.next().toString();
            File pomFile = new File(project.getBasedir(), moduleDir + "/pom.xml");
            try {
                MavenProject reactorProject = this.projectBuilder.buildWithDependencies(pomFile, repository, this.getProfileManager(this.getSettings()));
                reactorProjects.add(reactorProject);
                this.addModules(reactorProjects, reactorProject, repository);
            }
            catch (ProjectBuildingException e) {
                throw new ContinuumReleaseException("Failed to build project.", (Throwable)e);
            }
            catch (ArtifactNotFoundException e) {
                throw new ContinuumReleaseException("Failed to build project.", (Throwable)e);
            }
            catch (ArtifactResolutionException e) {
                throw new ContinuumReleaseException("Failed to build project.", (Throwable)e);
            }
        }
    }

    private File getProjectDescriptorFile(ReleaseDescriptor descriptor) {
        String parentPath = descriptor.getWorkingDirectory();
        String pomFilename = descriptor.getPomFileName();
        if (pomFilename == null) {
            pomFilename = "pom.xml";
        }
        return new File(parentPath, pomFilename);
    }

    private ArtifactRepository getLocalRepository(String arguments) throws ContinuumReleaseException {
        String localRepository = null;
        if (arguments != null) {
            String[] args = arguments.split(" ");
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].contains("-Dmaven.repo.local=")) continue;
                localRepository = args[i].substring(args[i].indexOf("=") + 1);
                break;
            }
        }
        if (localRepository == null) {
            localRepository = this.getSettings().getLocalRepository();
        } else if (localRepository.endsWith("\"")) {
            localRepository = localRepository.substring(0, localRepository.indexOf("\""));
        }
        return new DefaultArtifactRepository("local-repository", "file://" + localRepository, (ArtifactRepositoryLayout)new DefaultRepositoryLayout());
    }

    private ProfileManager getProfileManager(Settings settings) {
        return new DefaultProfileManager(this.container, settings);
    }

    private Settings getSettings() throws ContinuumReleaseException {
        try {
            return this.settingsBuilder.buildSettings();
        }
        catch (IOException e) {
            throw new ContinuumReleaseException("Failed to get Maven Settings.", (Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new ContinuumReleaseException("Failed to get Maven Settings.", (Throwable)e);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

