/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.release.executors;

import java.util.ArrayList;
import org.apache.maven.continuum.release.executors.AbstractReleaseTaskExecutor;
import org.apache.maven.continuum.release.tasks.ReleaseProjectTask;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseManagerListener;
import org.codehaus.plexus.taskqueue.execution.TaskExecutionException;

public class RollbackReleaseTaskExecutor
extends AbstractReleaseTaskExecutor {
    private static final int ERROR = 99;

    protected void execute(ReleaseProjectTask releaseTask) throws TaskExecutionException {
        try {
            this.releaseManager.rollback(releaseTask.getDescriptor(), this.settings, new ArrayList(), releaseTask.getListener());
        }
        catch (ReleaseExecutionException e) {
            this.updateListener(releaseTask.getListener(), e.getMessage(), 99);
            throw new TaskExecutionException("Failed to rollback release", (Throwable)e);
        }
        catch (ReleaseFailureException e) {
            this.updateListener(releaseTask.getListener(), e.getMessage(), 99);
            throw new TaskExecutionException("Failed to rollback release", (Throwable)e);
        }
    }

    private void updateListener(ReleaseManagerListener listener, String name, int state) {
        listener.error(name);
    }
}

