/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.release.executors;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.continuum.model.repository.LocalRepository;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.continuum.release.ContinuumReleaseException;
import org.apache.maven.continuum.release.executors.AbstractReleaseTaskExecutor;
import org.apache.maven.continuum.release.tasks.PerformReleaseProjectTask;
import org.apache.maven.continuum.release.tasks.ReleaseProjectTask;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectSorter;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseManagerListener;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.taskqueue.execution.TaskExecutionException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformReleaseTaskExecutor
extends AbstractReleaseTaskExecutor
implements Contextualizable {
    private MavenProjectBuilder projectBuilder;
    private ProfileManager profileManager;
    private PlexusContainer container;
    private LocalRepository repository;

    @Override
    public void execute(ReleaseProjectTask task) throws TaskExecutionException {
        PerformReleaseProjectTask performTask = (PerformReleaseProjectTask)task;
        ReleaseManagerListener listener = performTask.getListener();
        ReleaseDescriptor descriptor = performTask.getDescriptor();
        descriptor.setUseReleaseProfile(performTask.isUseReleaseProfile());
        descriptor.setPerformGoals(performTask.getGoals());
        descriptor.setCheckoutDirectory(performTask.getBuildDirectory().getAbsolutePath());
        this.repository = performTask.getLocalRepository();
        List<MavenProject> reactorProjects = this.getReactorProjects(performTask);
        ReleaseResult result = this.releaseManager.performWithResult(descriptor, this.settings, reactorProjects, listener);
        result.setStartTime(this.getStartTime());
        if (result.getResultCode() == 0) {
            this.continuumReleaseManager.getPreparedReleases().remove(performTask.getReleaseId());
        }
        this.continuumReleaseManager.getReleaseResults().put(performTask.getReleaseId(), result);
    }

    protected List<MavenProject> getReactorProjects(PerformReleaseProjectTask releaseTask) throws TaskExecutionException {
        List<MavenProject> reactorProjects;
        ReleaseDescriptor descriptor = releaseTask.getDescriptor();
        if (StringUtils.isEmpty((String)descriptor.getWorkingDirectory())) {
            descriptor.setCheckoutDirectory(releaseTask.getBuildDirectory().getAbsolutePath());
            return null;
        }
        try {
            reactorProjects = this.getReactorProjects(descriptor);
        }
        catch (ContinuumReleaseException e) {
            ReleaseResult result = this.createReleaseResult();
            result.appendError((Exception)((Object)e));
            this.continuumReleaseManager.getReleaseResults().put(releaseTask.getReleaseId(), result);
            releaseTask.getListener().error(e.getMessage());
            throw new TaskExecutionException("Failed to build reactor projects.", (Throwable)e);
        }
        return reactorProjects;
    }

    protected List<MavenProject> getReactorProjects(ReleaseDescriptor descriptor) throws ContinuumReleaseException {
        ArrayList<MavenProject> reactorProjects = new ArrayList<MavenProject>();
        try {
            MavenProject project = this.projectBuilder.build(this.getProjectDescriptorFile(descriptor), this.getLocalRepository(), this.getProfileManager(this.settings));
            reactorProjects.add(project);
            this.addModules(reactorProjects, project);
        }
        catch (ProjectBuildingException e) {
            throw new ContinuumReleaseException("Failed to build project.", (Throwable)e);
        }
        try {
            reactorProjects = new ProjectSorter(reactorProjects).getSortedProjects();
        }
        catch (CycleDetectedException e) {
            throw new ContinuumReleaseException("Failed to sort projects.", (Throwable)e);
        }
        catch (DuplicateProjectException e) {
            throw new ContinuumReleaseException("Failed to sort projects.", (Throwable)e);
        }
        return reactorProjects;
    }

    private void addModules(List reactorProjects, MavenProject project) throws ContinuumReleaseException {
        Iterator modules = project.getModules().iterator();
        while (modules.hasNext()) {
            String moduleDir = modules.next().toString();
            File pomFile = new File(project.getBasedir(), moduleDir + "/pom.xml");
            System.out.println(pomFile.getAbsolutePath());
            try {
                MavenProject reactorProject = this.projectBuilder.build(pomFile, this.getLocalRepository(), this.getProfileManager(this.settings));
                reactorProjects.add(reactorProject);
                this.addModules(reactorProjects, reactorProject);
            }
            catch (ProjectBuildingException e) {
                throw new ContinuumReleaseException("Failed to build project.", (Throwable)e);
            }
        }
    }

    private File getProjectDescriptorFile(ReleaseDescriptor descriptor) {
        String parentPath = descriptor.getWorkingDirectory();
        String pomFilename = descriptor.getPomFileName();
        if (pomFilename == null) {
            pomFilename = "pom.xml";
        }
        return new File(parentPath, pomFilename);
    }

    private ArtifactRepository getLocalRepository() {
        if (this.repository == null) {
            return new DefaultArtifactRepository("local-repository", "file://" + this.settings.getLocalRepository(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout());
        }
        return new DefaultArtifactRepository(this.repository.getName(), "file://" + this.repository.getLocation(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout());
    }

    private ProfileManager getProfileManager(Settings settings) {
        if (this.profileManager == null) {
            this.profileManager = new DefaultProfileManager(this.container, settings);
        }
        return this.profileManager;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

