/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.release.executors;

import java.io.IOException;
import org.apache.maven.continuum.release.ContinuumReleaseException;
import org.apache.maven.continuum.release.ContinuumReleaseManager;
import org.apache.maven.continuum.release.executors.ReleaseTaskExecutor;
import org.apache.maven.continuum.release.tasks.ReleaseProjectTask;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseManager;
import org.apache.maven.shared.release.ReleaseResult;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.execution.TaskExecutionException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractReleaseTaskExecutor
implements ReleaseTaskExecutor {
    protected ContinuumReleaseManager continuumReleaseManager;
    protected ReleaseManager releaseManager;
    private MavenSettingsBuilder settingsBuilder;
    protected Settings settings;
    private long startTime;

    public void executeTask(Task task) throws TaskExecutionException {
        ReleaseProjectTask releaseTask = (ReleaseProjectTask)task;
        this.setUp(releaseTask);
        this.execute(releaseTask);
    }

    protected void setUp(ReleaseProjectTask releaseTask) throws TaskExecutionException {
        this.setStartTime(System.currentTimeMillis());
        try {
            this.settings = this.getSettings();
        }
        catch (ContinuumReleaseException e) {
            ReleaseResult result = this.createReleaseResult();
            result.appendError((Exception)((Object)e));
            this.continuumReleaseManager.getReleaseResults().put(releaseTask.getReleaseId(), result);
            releaseTask.getListener().error(e.getMessage());
            throw new TaskExecutionException("Failed to build reactor projects.", (Throwable)e);
        }
    }

    protected abstract void execute(ReleaseProjectTask var1) throws TaskExecutionException;

    private Settings getSettings() throws ContinuumReleaseException {
        try {
            this.settings = this.settingsBuilder.buildSettings(false);
        }
        catch (IOException e) {
            throw new ContinuumReleaseException("Failed to get Maven Settings.", (Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new ContinuumReleaseException("Failed to get Maven Settings.", (Throwable)e);
        }
        return this.settings;
    }

    protected ReleaseResult createReleaseResult() {
        ReleaseResult result = new ReleaseResult();
        result.setStartTime(this.getStartTime());
        result.setEndTime(System.currentTimeMillis());
        return result;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected void setStartTime(long startTime) {
        this.startTime = startTime;
    }
}

