/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.release;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.apache.continuum.model.repository.LocalRepository;
import org.apache.continuum.release.config.ContinuumReleaseDescriptor;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.release.ContinuumReleaseException;
import org.apache.maven.continuum.release.ContinuumReleaseManager;
import org.apache.maven.continuum.release.ContinuumReleaseManagerListener;
import org.apache.maven.continuum.release.tasks.PerformReleaseProjectTask;
import org.apache.maven.continuum.release.tasks.PrepareReleaseProjectTask;
import org.apache.maven.continuum.release.tasks.RollbackReleaseProjectTask;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.shared.release.ReleaseManagerListener;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseDescriptorStore;
import org.apache.maven.shared.release.config.ReleaseDescriptorStoreException;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.TaskQueue;
import org.codehaus.plexus.taskqueue.TaskQueueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContinuumReleaseManager
implements ContinuumReleaseManager {
    private ReleaseDescriptorStore releaseStore;
    private TaskQueue prepareReleaseQueue;
    private TaskQueue performReleaseQueue;
    private TaskQueue rollbackReleaseQueue;
    private ScmManager scmManager;
    private Map<String, ContinuumReleaseManagerListener> listeners;
    private static Map preparedReleases;
    private static Map releaseResults;

    public String prepare(Project project, Properties releaseProperties, Map<String, String> relVersions, Map<String, String> devVersions, ContinuumReleaseManagerListener listener, String workingDirectory) throws ContinuumReleaseException {
        return this.prepare(project, releaseProperties, relVersions, devVersions, listener, workingDirectory, null, null);
    }

    public String prepare(Project project, Properties releaseProperties, Map<String, String> relVersions, Map<String, String> devVersions, ContinuumReleaseManagerListener listener, String workingDirectory, Map<String, String> environments, String executable) throws ContinuumReleaseException {
        String releaseId = project.getGroupId() + ":" + project.getArtifactId();
        ReleaseDescriptor descriptor = this.getReleaseDescriptor(project, releaseProperties, relVersions, devVersions, environments, workingDirectory, executable);
        this.getListeners().put(releaseId, listener);
        try {
            this.prepareReleaseQueue.put((Task)new PrepareReleaseProjectTask(releaseId, descriptor, (ReleaseManagerListener)listener));
        }
        catch (TaskQueueException e) {
            throw new ContinuumReleaseException("Failed to add prepare release task in queue.", (Throwable)e);
        }
        return releaseId;
    }

    public void perform(String releaseId, File buildDirectory, String goals, String arguments, boolean useReleaseProfile, ContinuumReleaseManagerListener listener) throws ContinuumReleaseException {
        this.perform(releaseId, buildDirectory, goals, arguments, useReleaseProfile, listener, null);
    }

    public void perform(String releaseId, File buildDirectory, String goals, String arguments, boolean useReleaseProfile, ContinuumReleaseManagerListener listener, LocalRepository repository) throws ContinuumReleaseException {
        ReleaseDescriptor descriptor = (ReleaseDescriptor)this.getPreparedReleases().get(releaseId);
        if (descriptor != null) {
            this.perform(releaseId, descriptor, buildDirectory, goals, arguments, useReleaseProfile, listener, repository);
        }
    }

    public void perform(String releaseId, String workingDirectory, File buildDirectory, String goals, String arguments, boolean useReleaseProfile, ContinuumReleaseManagerListener listener) throws ContinuumReleaseException {
        ReleaseDescriptor descriptor = this.readReleaseDescriptor(workingDirectory);
        this.perform(releaseId, descriptor, buildDirectory, goals, arguments, useReleaseProfile, listener, null);
    }

    private void perform(String releaseId, ReleaseDescriptor descriptor, File buildDirectory, String goals, String arguments, boolean useReleaseProfile, ContinuumReleaseManagerListener listener, LocalRepository repository) throws ContinuumReleaseException {
        if (descriptor != null) {
            descriptor.setAdditionalArguments(arguments);
        }
        try {
            this.getListeners().put(releaseId, listener);
            this.performReleaseQueue.put((Task)new PerformReleaseProjectTask(releaseId, descriptor, buildDirectory, goals, useReleaseProfile, (ReleaseManagerListener)listener, repository));
        }
        catch (TaskQueueException e) {
            throw new ContinuumReleaseException("Failed to add perform release task in queue.", (Throwable)e);
        }
    }

    public void rollback(String releaseId, String workingDirectory, ContinuumReleaseManagerListener listener) throws ContinuumReleaseException {
        ReleaseDescriptor descriptor = this.readReleaseDescriptor(workingDirectory);
        this.rollback(releaseId, descriptor, listener);
    }

    private void rollback(String releaseId, ReleaseDescriptor descriptor, ContinuumReleaseManagerListener listener) throws ContinuumReleaseException {
        RollbackReleaseProjectTask releaseTask = new RollbackReleaseProjectTask(releaseId, descriptor, (ReleaseManagerListener)listener);
        try {
            this.rollbackReleaseQueue.put((Task)releaseTask);
        }
        catch (TaskQueueException e) {
            throw new ContinuumReleaseException("Failed to rollback release.", (Throwable)e);
        }
    }

    public Map getPreparedReleases() {
        if (preparedReleases == null) {
            preparedReleases = new Hashtable();
        }
        return preparedReleases;
    }

    public Map getReleaseResults() {
        if (releaseResults == null) {
            releaseResults = new Hashtable();
        }
        return releaseResults;
    }

    private ReleaseDescriptor getReleaseDescriptor(Project project, Properties releaseProperties, Map<String, String> relVersions, Map<String, String> devVersions, Map<String, String> environments, String workingDirectory, String executable) {
        LocalRepository repository;
        ContinuumReleaseDescriptor descriptor = new ContinuumReleaseDescriptor();
        descriptor.setWorkingDirectory(workingDirectory);
        descriptor.setScmSourceUrl(project.getScmUrl());
        descriptor.setScmReleaseLabel(releaseProperties.getProperty("tag"));
        descriptor.setScmTagBase(releaseProperties.getProperty("tagBase"));
        descriptor.setReleaseVersions(relVersions);
        descriptor.setDevelopmentVersions(devVersions);
        descriptor.setPreparationGoals(releaseProperties.getProperty("prepareGoals"));
        descriptor.setAdditionalArguments(releaseProperties.getProperty("arguments"));
        descriptor.setAddSchema(Boolean.valueOf(releaseProperties.getProperty("addSchema")));
        descriptor.setAutoVersionSubmodules(Boolean.valueOf(releaseProperties.getProperty("autoVersionSubmodules")));
        String useEditMode = releaseProperties.getProperty("useEditMode");
        if (BooleanUtils.toBoolean((String)useEditMode)) {
            descriptor.setScmUseEditMode(Boolean.valueOf(useEditMode));
        }
        if ((repository = project.getProjectGroup().getLocalRepository()) != null) {
            descriptor.setAdditionalArguments("\"-Dmaven.repo.local=" + repository.getLocation() + "\"");
        }
        if (releaseProperties.containsKey("username")) {
            descriptor.setScmUsername(releaseProperties.getProperty("username"));
        }
        if (releaseProperties.containsKey("password")) {
            descriptor.setScmPassword(releaseProperties.getProperty("password"));
        }
        if (releaseProperties.containsKey("commentPrefix")) {
            descriptor.setScmCommentPrefix(releaseProperties.getProperty("commentPrefix"));
        }
        if (releaseProperties.containsKey("useReleaseProfile")) {
            descriptor.setUseReleaseProfile(Boolean.valueOf(releaseProperties.getProperty("useReleaseProfile")));
        }
        descriptor.setInteractive(false);
        descriptor.setEnvironments(environments);
        descriptor.setExecutable(executable);
        return descriptor;
    }

    private ReleaseDescriptor readReleaseDescriptor(String workingDirectory) throws ContinuumReleaseException {
        ContinuumReleaseDescriptor descriptor = new ContinuumReleaseDescriptor();
        descriptor.setWorkingDirectory(workingDirectory);
        try {
            descriptor = this.releaseStore.read((ReleaseDescriptor)descriptor);
        }
        catch (ReleaseDescriptorStoreException e) {
            throw new ContinuumReleaseException("Failed to parse descriptor file.", (Throwable)e);
        }
        return descriptor;
    }

    public Map<String, ContinuumReleaseManagerListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new Hashtable<String, ContinuumReleaseManagerListener>();
        }
        return this.listeners;
    }

    public String sanitizeTagName(String scmUrl, String tagName) throws Exception {
        ScmRepository scmRepo = this.scmManager.makeScmRepository(scmUrl);
        ScmProvider scmProvider = this.scmManager.getProviderByRepository(scmRepo);
        return scmProvider.sanitizeTagName(tagName);
    }
}

