/*
 * Decompiled with CFR 0.152.
 */
package org.apache.continuum.release.phase;

import java.io.File;
import java.util.Map;
import org.apache.continuum.release.config.ContinuumReleaseDescriptor;
import org.apache.continuum.utils.shell.ShellCommandHelper;
import org.apache.maven.continuum.installation.InstallationService;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractRunGoalsPhase;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractContinuumRunGoalsPhase
extends AbstractRunGoalsPhase {
    private ShellCommandHelper shellCommandHelper;
    private InstallationService installationService;

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, File workingDirectory, String additionalArguments) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        try {
            String goals = this.getGoals(releaseDescriptor);
            if (!StringUtils.isEmpty((String)goals)) {
                Map<String, String> environments = null;
                String executable = null;
                if (releaseDescriptor instanceof ContinuumReleaseDescriptor) {
                    environments = ((ContinuumReleaseDescriptor)releaseDescriptor).getEnvironments();
                    executable = ((ContinuumReleaseDescriptor)releaseDescriptor).getExecutable();
                }
                this.shellCommandHelper.executeGoals(this.determineWorkingDirectory(workingDirectory, releaseDescriptor.getScmRelativePathProjectDirectory()), executable, goals, releaseDescriptor.isInteractive(), additionalArguments, result, environments);
            }
        }
        catch (Exception e) {
            throw new ReleaseExecutionException(result.getOutput(), (Throwable)e);
        }
        result.setResultCode(0);
        return result;
    }
}

