/*
 * Decompiled with CFR 0.152.
 */
package org.apache.continuum.release.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.continuum.release.config.ContinuumReleaseDescriptor;
import org.apache.maven.model.Scm;
import org.apache.maven.shared.release.config.PropertiesReleaseDescriptorStore;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseDescriptorStoreException;
import org.apache.maven.shared.release.config.ReleaseUtils;
import org.codehaus.plexus.util.IOUtil;

public class ContinuumPropertiesReleaseDescriptorStore
extends PropertiesReleaseDescriptorStore {
    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public ReleaseDescriptor read(ReleaseDescriptor mergeDescriptor, File file) throws ReleaseDescriptorStoreException {
        Properties properties = new Properties();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            properties.load(inStream);
        }
        catch (FileNotFoundException e) {
            this.getLogger().debug(file.getName() + " not found - using empty properties");
            IOUtil.close((InputStream)inStream);
        }
        catch (IOException e2) {
            throw new ReleaseDescriptorStoreException("Error reading properties file '" + file.getName() + "': " + e2.getMessage(), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    IOUtil.close(inStream);
                    throw throwable;
                }
            }
        }
        IOUtil.close((InputStream)inStream);
        ContinuumReleaseDescriptor releaseDescriptor = new ContinuumReleaseDescriptor();
        releaseDescriptor.setCompletedPhase(properties.getProperty("completedPhase"));
        releaseDescriptor.setScmSourceUrl(properties.getProperty("scm.url"));
        releaseDescriptor.setScmUsername(properties.getProperty("scm.username"));
        releaseDescriptor.setScmPassword(properties.getProperty("scm.password"));
        releaseDescriptor.setScmPrivateKey(properties.getProperty("scm.privateKey"));
        releaseDescriptor.setScmPrivateKeyPassPhrase(properties.getProperty("scm.passphrase"));
        releaseDescriptor.setScmTagBase(properties.getProperty("scm.tagBase"));
        releaseDescriptor.setScmReleaseLabel(properties.getProperty("scm.tag"));
        releaseDescriptor.setScmCommentPrefix(properties.getProperty("scm.commentPrefix"));
        releaseDescriptor.setAdditionalArguments(properties.getProperty("exec.additionalArguments"));
        releaseDescriptor.setPomFileName(properties.getProperty("exec.pomFileName"));
        releaseDescriptor.setPreparationGoals(properties.getProperty("preparationGoals"));
        this.loadResolvedDependencies(properties, releaseDescriptor);
        for (String property : properties.keySet()) {
            if (property.startsWith("project.rel.")) {
                releaseDescriptor.mapReleaseVersion(property.substring("project.rel.".length()), properties.getProperty(property));
                continue;
            }
            if (property.startsWith("project.dev.")) {
                releaseDescriptor.mapDevelopmentVersion(property.substring("project.dev.".length()), properties.getProperty(property));
                continue;
            }
            if (property.startsWith("project.scm.")) {
                int index = property.lastIndexOf(46);
                if (index <= "project.scm.".length()) continue;
                String key = property.substring("project.scm.".length(), index);
                if (releaseDescriptor.getOriginalScmInfo().containsKey(key)) continue;
                if (properties.getProperty("project.scm." + key + ".empty") != null) {
                    releaseDescriptor.mapOriginalScmInfo(key, null);
                    continue;
                }
                Scm scm = new Scm();
                scm.setConnection(properties.getProperty("project.scm." + key + ".connection"));
                scm.setDeveloperConnection(properties.getProperty("project.scm." + key + ".developerConnection"));
                scm.setUrl(properties.getProperty("project.scm." + key + ".url"));
                scm.setTag(properties.getProperty("project.scm." + key + ".tag"));
                releaseDescriptor.mapOriginalScmInfo(key, scm);
                continue;
            }
            if (!property.startsWith("build.env.")) continue;
            releaseDescriptor.mapEnvironments(property.substring("build.env.".length()), properties.getProperty(property));
        }
        if (mergeDescriptor != null) {
            releaseDescriptor = (ContinuumReleaseDescriptor)ReleaseUtils.merge((ReleaseDescriptor)releaseDescriptor, (ReleaseDescriptor)mergeDescriptor);
            releaseDescriptor.setEnvironments(((ContinuumReleaseDescriptor)mergeDescriptor).getEnvironments());
        }
        return releaseDescriptor;
    }

    public void write(ReleaseDescriptor configFile, File file) throws ReleaseDescriptorStoreException {
        ContinuumReleaseDescriptor config = (ContinuumReleaseDescriptor)configFile;
        Properties properties = new Properties();
        properties.setProperty("completedPhase", config.getCompletedPhase());
        properties.setProperty("scm.url", config.getScmSourceUrl());
        if (config.getScmUsername() != null) {
            properties.setProperty("scm.username", config.getScmUsername());
        }
        if (config.getScmPassword() != null) {
            properties.setProperty("scm.password", config.getScmPassword());
        }
        if (config.getScmPrivateKey() != null) {
            properties.setProperty("scm.privateKey", config.getScmPrivateKey());
        }
        if (config.getScmPrivateKeyPassPhrase() != null) {
            properties.setProperty("scm.passphrase", config.getScmPrivateKeyPassPhrase());
        }
        if (config.getScmTagBase() != null) {
            properties.setProperty("scm.tagBase", config.getScmTagBase());
        }
        if (config.getScmReleaseLabel() != null) {
            properties.setProperty("scm.tag", config.getScmReleaseLabel());
        }
        if (config.getScmCommentPrefix() != null) {
            properties.setProperty("scm.commentPrefix", config.getScmCommentPrefix());
        }
        if (config.getAdditionalArguments() != null) {
            properties.setProperty("exec.additionalArguments", config.getAdditionalArguments());
        }
        if (config.getPomFileName() != null) {
            properties.setProperty("exec.pomFileName", config.getPomFileName());
        }
        if (config.getPreparationGoals() != null) {
            properties.setProperty("preparationGoals", config.getPreparationGoals());
        }
        for (Map.Entry entry : config.getReleaseVersions().entrySet()) {
            properties.setProperty("project.rel." + entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : config.getDevelopmentVersions().entrySet()) {
            properties.setProperty("project.dev." + entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : config.getOriginalScmInfo().entrySet()) {
            Scm scm = (Scm)entry.getValue();
            String prefix = "project.scm." + entry.getKey();
            if (scm != null) {
                if (scm.getConnection() != null) {
                    properties.setProperty(prefix + ".connection", scm.getConnection());
                }
                if (scm.getDeveloperConnection() != null) {
                    properties.setProperty(prefix + ".developerConnection", scm.getDeveloperConnection());
                }
                if (scm.getUrl() != null) {
                    properties.setProperty(prefix + ".url", scm.getUrl());
                }
                if (scm.getTag() == null) continue;
                properties.setProperty(prefix + ".tag", scm.getTag());
                continue;
            }
            properties.setProperty(prefix + ".empty", "true");
        }
        for (Map.Entry<Object, Object> entry : config.getEnvironments().entrySet()) {
            properties.setProperty("build.env." + entry.getKey(), (String)entry.getValue());
        }
        if (config.getResolvedSnapshotDependencies() != null && config.getResolvedSnapshotDependencies().size() > 0) {
            this.processResolvedDependencies(properties, config.getResolvedSnapshotDependencies());
        }
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(file);
            properties.store(outStream, "release configuration");
        }
        catch (IOException iOException) {
            try {
                throw new ReleaseDescriptorStoreException("Error writing properties file '" + file.getName() + "': " + iOException.getMessage(), (Throwable)iOException);
            }
            catch (Throwable throwable) {
                IOUtil.close(outStream);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)outStream);
    }

    private void processResolvedDependencies(Properties prop, Map resolvedDependencies) {
        Set entries = resolvedDependencies.entrySet();
        for (Map.Entry currentEntry : entries) {
            Map versionMap = (Map)currentEntry.getValue();
            prop.setProperty("dependency." + currentEntry.getKey() + ".release", (String)versionMap.get("rel"));
            prop.setProperty("dependency." + currentEntry.getKey() + ".development", (String)versionMap.get("dev"));
        }
    }

    private static File getDefaultReleasePropertiesFile(ReleaseDescriptor mergeDescriptor) {
        return new File(mergeDescriptor.getWorkingDirectory(), "release.properties");
    }

    private void loadResolvedDependencies(Properties prop, ReleaseDescriptor descriptor) {
        HashMap resolvedDependencies = new HashMap();
        Set<Map.Entry<Object, Object>> entries = prop.entrySet();
        for (Map.Entry<Object, Object> currentEntry : entries) {
            String versionType;
            int endIndex;
            String propertyName = (String)currentEntry.getKey();
            if (!propertyName.startsWith("dependency.")) continue;
            Map<String, Object> versionMap = new HashMap();
            int startIndex = propertyName.lastIndexOf("dependency.");
            if (propertyName.indexOf(".development") != -1) {
                endIndex = propertyName.indexOf(".development");
                versionType = "dev";
            } else {
                endIndex = propertyName.indexOf(".release");
                versionType = "rel";
            }
            String artifactVersionlessKey = propertyName.substring(startIndex, endIndex);
            if (resolvedDependencies.containsKey(artifactVersionlessKey)) {
                versionMap = (Map)resolvedDependencies.get(artifactVersionlessKey);
            } else {
                versionMap = new HashMap();
                resolvedDependencies.put(artifactVersionlessKey, versionMap);
            }
            versionMap.put(versionType, currentEntry.getValue());
        }
        descriptor.setResolvedSnapshotDependencies(resolvedDependencies);
    }
}

