/*
 * $Id$
 */

package org.apache.continuum.release.model.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import org.apache.continuum.release.model.PreparedRelease;
import org.apache.continuum.release.model.PreparedReleaseModel;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class ContinuumPrepareReleasesModelXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class ContinuumPrepareReleasesModelXpp3Writer {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field NAMESPACE.
     */
    private String NAMESPACE;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write.
     * 
     * @param writer
     * @param preparedReleaseModel
     * @throws java.io.IOException
     */
    public void write(Writer writer, PreparedReleaseModel preparedReleaseModel)
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( preparedReleaseModel.getModelEncoding(), null );
        writePreparedReleaseModel( preparedReleaseModel, "prepared-releases", serializer );
        serializer.endDocument();
    } //-- void write(Writer, PreparedReleaseModel) 

    /**
     * Method writePreparedRelease.
     * 
     * @param preparedRelease
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writePreparedRelease(PreparedRelease preparedRelease, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( preparedRelease != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( preparedRelease.getReleaseId() != null )
            {
                serializer.startTag( NAMESPACE, "releaseId" ).text( preparedRelease.getReleaseId() ).endTag( NAMESPACE, "releaseId" );
            }
            if ( preparedRelease.getReleaseName() != null )
            {
                serializer.startTag( NAMESPACE, "releaseName" ).text( preparedRelease.getReleaseName() ).endTag( NAMESPACE, "releaseName" );
            }
            if ( preparedRelease.getBuildAgentUrl() != null )
            {
                serializer.startTag( NAMESPACE, "buildAgentUrl" ).text( preparedRelease.getBuildAgentUrl() ).endTag( NAMESPACE, "buildAgentUrl" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writePreparedRelease(PreparedRelease, String, XmlSerializer) 

    /**
     * Method writePreparedReleaseModel.
     * 
     * @param preparedReleaseModel
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writePreparedReleaseModel(PreparedReleaseModel preparedReleaseModel, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( preparedReleaseModel != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( preparedReleaseModel.getPreparedReleases() != null && preparedReleaseModel.getPreparedReleases().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "preparedReleases" );
                for ( Iterator iter = preparedReleaseModel.getPreparedReleases().iterator(); iter.hasNext(); )
                {
                    PreparedRelease o = (PreparedRelease) iter.next();
                    writePreparedRelease( o, "preparedRelease", serializer );
                }
                serializer.endTag( NAMESPACE, "preparedReleases" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writePreparedReleaseModel(PreparedReleaseModel, String, XmlSerializer) 


}
