/*
 * Decompiled with CFR 0.152.
 */
package org.apache.continuum.distributed.transport.slave;

import com.atlassian.xmlrpc.AuthenticationInfo;
import com.atlassian.xmlrpc.BindingException;
import com.atlassian.xmlrpc.DefaultBinder;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.continuum.distributed.transport.slave.SlaveBuildAgentTransportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveBuildAgentTransportClient
implements SlaveBuildAgentTransportService {
    private static final Logger log = LoggerFactory.getLogger(SlaveBuildAgentTransportClient.class);
    private SlaveBuildAgentTransportService slave;

    public SlaveBuildAgentTransportClient(URL serviceUrl) throws Exception {
        this(serviceUrl, null, null);
    }

    public SlaveBuildAgentTransportClient(URL serviceUrl, String login, String password) throws Exception {
        DefaultBinder binder = new DefaultBinder();
        AuthenticationInfo authnInfo = new AuthenticationInfo(login, password);
        try {
            this.slave = (SlaveBuildAgentTransportService)binder.bind(SlaveBuildAgentTransportService.class, serviceUrl, authnInfo);
        }
        catch (BindingException e) {
            log.error("Can't bind service interface " + SlaveBuildAgentTransportService.class.getName() + " to " + serviceUrl.toExternalForm() + " using " + authnInfo.getUsername() + ", " + authnInfo.getPassword(), (Throwable)e);
            throw new Exception("Can't bind service interface " + SlaveBuildAgentTransportService.class.getName() + " to " + serviceUrl.toExternalForm() + " using " + authnInfo.getUsername() + ", " + authnInfo.getPassword(), e);
        }
    }

    public Boolean buildProjects(List<Map<String, Object>> projectsBuildContext) throws Exception {
        Boolean result;
        try {
            result = this.slave.buildProjects(projectsBuildContext);
            log.info("Building projects.");
        }
        catch (Exception e) {
            log.error("Failed to build projects.", (Throwable)e);
            throw new Exception("Failed to build projects.", e);
        }
        return result;
    }

    public List<Map<String, String>> getAvailableInstallations() throws Exception {
        List installations;
        try {
            installations = this.slave.getAvailableInstallations();
            log.info("Available installations: " + installations.size());
        }
        catch (Exception e) {
            log.error("Failed to get available installations.", (Throwable)e);
            throw new Exception("Failed to get available installations.", e);
        }
        return installations;
    }

    public Map<String, Object> getBuildResult(int projectId) throws Exception {
        Map buildResult;
        try {
            buildResult = this.slave.getBuildResult(projectId);
            log.info("Build result for project '" + projectId + "' acquired.");
        }
        catch (Exception e) {
            log.error("Failed to get build result for project '" + projectId + "'", (Throwable)e);
            throw new Exception("Failed to get build result for project '" + projectId + "'", e);
        }
        return buildResult;
    }

    public Map<String, Object> getProjectCurrentlyBuilding() throws Exception {
        Map map;
        try {
            map = this.slave.getProjectCurrentlyBuilding();
            log.info("Retrieving currently building project");
        }
        catch (Exception e) {
            log.error("Failed to get the currently building project", (Throwable)e);
            throw new Exception("Failed to get the currently building project", e);
        }
        return map;
    }

    public Boolean ping() throws Exception {
        Boolean result;
        try {
            result = this.slave.ping();
            log.info("Ping " + (result != false ? "ok" : "failed"));
        }
        catch (Exception e) {
            log.info("Ping error");
            throw new Exception("Ping error", e);
        }
        return result;
    }

    public Boolean cancelBuild() throws Exception {
        Boolean result;
        try {
            result = this.slave.cancelBuild();
            log.info("Cancelled build");
        }
        catch (Exception e) {
            log.error("Error cancelling build");
            throw new Exception("Error cancelling build", e);
        }
        return result;
    }

    public String generateWorkingCopyContent(int projectId, String directory, String baseUrl, String imagesBaseUrl) throws Exception {
        String result;
        try {
            result = this.slave.generateWorkingCopyContent(projectId, directory, baseUrl, imagesBaseUrl);
            log.info("Generated working copy content for project '" + projectId + "'");
        }
        catch (Exception e) {
            log.error("Error generating working copy content for project '" + projectId + "'", (Throwable)e);
            throw new Exception("Error generating working copy content for project '" + projectId + "'", e);
        }
        return result;
    }

    public String getProjectFileContent(int projectId, String directory, String filename) throws Exception {
        String result;
        try {
            result = this.slave.getProjectFileContent(projectId, directory, filename);
            log.info("Retrieved project '" + projectId + "' file content");
        }
        catch (Exception e) {
            log.error("Error retrieving project '" + projectId + "' file content", (Throwable)e);
            throw new Exception("Error retrieving project '" + projectId + "' file content", e);
        }
        return result;
    }

    public Map getReleasePluginParameters(int projectId, String pomFilename) throws Exception {
        Map result;
        try {
            result = this.slave.getReleasePluginParameters(projectId, pomFilename);
            log.info("Retrieving release plugin parameters for project '" + projectId + "'");
        }
        catch (Exception e) {
            log.error("Error retrieving release plugin parameters for project '" + projectId + "'", (Throwable)e);
            throw new Exception("Error retrieving release plugin parameters for project '" + projectId + "'", e);
        }
        return result;
    }

    public List<Map<String, String>> processProject(int projectId, String pomFilename, boolean autoVersionSubmodules) throws Exception {
        List result;
        try {
            result = this.slave.processProject(projectId, pomFilename, autoVersionSubmodules);
            log.info("Processing project '" + projectId + "'");
        }
        catch (Exception e) {
            log.error("Error processing project '" + projectId + "'", (Throwable)e);
            throw new Exception("Error processing project '" + projectId + "'", e);
        }
        return result;
    }

    public String releasePrepare(Map project, Map properties, Map releaseVersion, Map developmentVersion, Map environments, String username) throws Exception {
        String releaseId;
        try {
            releaseId = this.slave.releasePrepare(project, properties, releaseVersion, developmentVersion, environments, username);
            log.info("Preparing release '" + releaseId + "'");
        }
        catch (Exception e) {
            log.error("Error while preparing release", (Throwable)e);
            throw new Exception("Error while preparing release", e);
        }
        return releaseId;
    }

    public Map<String, Object> getReleaseResult(String releaseId) throws Exception {
        Map result;
        try {
            result = this.slave.getReleaseResult(releaseId);
            log.info("Retrieving release result, releaseId=" + releaseId);
        }
        catch (Exception e) {
            log.error("Error retrieving release result, releaseId=" + releaseId, (Throwable)e);
            throw new Exception("Error retrieving release result, releaseId=" + releaseId, e);
        }
        return result;
    }

    public Map getListener(String releaseId) throws Exception {
        Map result;
        try {
            result = this.slave.getListener(releaseId);
            log.info("Retrieving listener for releaseId=" + releaseId);
        }
        catch (Exception e) {
            log.error("Error retrieving listener for releaseId=" + releaseId, (Throwable)e);
            throw new Exception("Error retrieving listener for releaseId=" + releaseId, e);
        }
        return result;
    }

    public Boolean removeListener(String releaseId) throws Exception {
        Boolean result;
        try {
            this.slave.removeListener(releaseId);
            result = Boolean.FALSE;
            log.info("Removing listener for releaseId=" + releaseId);
        }
        catch (Exception e) {
            log.error("Error removing listener for releaseId=" + releaseId, (Throwable)e);
            throw new Exception("Error removing listener for releaseId=" + releaseId, e);
        }
        return result;
    }

    public String getPreparedReleaseName(String releaseId) throws Exception {
        String result;
        try {
            result = this.slave.getPreparedReleaseName(releaseId);
            log.info("Retrieving prepared release name, releaseId=" + releaseId);
        }
        catch (Exception e) {
            log.error("Error while retrieving prepared release name, releaseId=" + releaseId);
            throw new Exception("Error while retrieving prepared release name, releaseId=" + releaseId);
        }
        return result;
    }

    public Boolean releasePerform(String releaseId, String goals, String arguments, boolean useReleaseProfile, Map repository, String username) throws Exception {
        Boolean result;
        try {
            this.slave.releasePerform(releaseId, goals, arguments, useReleaseProfile, repository, username);
            result = Boolean.FALSE;
            log.info("Performing release of releaseId=" + releaseId);
        }
        catch (Exception e) {
            log.error("Error performing release of releaseId=" + releaseId, (Throwable)e);
            throw new Exception("Error performing release of releaseId=" + releaseId, e);
        }
        return result;
    }

    public String releasePerformFromScm(String goals, String arguments, boolean useReleaseProfile, Map repository, String scmUrl, String scmUsername, String scmPassword, String scmTag, String scmTagBase, Map environments, String username) throws Exception {
        String result;
        try {
            result = this.slave.releasePerformFromScm(goals, arguments, useReleaseProfile, repository, scmUrl, scmUsername, scmPassword, scmTag, scmTagBase, environments, username);
            log.info("Performing release of scmUrl=" + scmUrl);
        }
        catch (Exception e) {
            log.error("Error performing release from scm '" + scmUrl + "'", (Throwable)e);
            throw new Exception("Error performing release from scm '" + scmUrl + "'", e);
        }
        return result;
    }

    public String releaseCleanup(String releaseId) throws Exception {
        String result;
        try {
            result = this.slave.releaseCleanup(releaseId);
            log.info("Cleanup release, releaseId=" + releaseId);
        }
        catch (Exception e) {
            log.error("Error cleaning up release, releaseId=" + releaseId, (Throwable)e);
            throw new Exception("Error cleaning up release, releaseId=" + releaseId, e);
        }
        return result;
    }

    public Boolean releaseRollback(String releaseId, int projectId) throws Exception {
        Boolean result;
        try {
            this.slave.releaseRollback(releaseId, projectId);
            result = Boolean.TRUE;
            log.info("Rollback release. releaseId=" + releaseId + ", projectId=" + projectId);
        }
        catch (Exception e) {
            log.error("Failed to rollback release. releaseId=" + releaseId + ", projectId=" + projectId);
            throw new Exception("Failed to rollback release. releaseId=" + releaseId + ", projectId=" + projectId);
        }
        return result;
    }

    public Integer getBuildSizeOfAgent() throws Exception {
        Integer size;
        try {
            size = this.slave.getBuildSizeOfAgent();
            log.info("Retrieving build size of agent");
        }
        catch (Exception e) {
            log.error("Failed to retrieve build size of agent", (Throwable)e);
            throw new Exception("Failed to retrieve build size of agent", e);
        }
        return size;
    }

    public Map<String, Object> getProjectCurrentlyPreparingBuild() throws Exception {
        Map projects;
        try {
            projects = this.slave.getProjectCurrentlyPreparingBuild();
            log.info("Retrieving projects currently preparing build");
        }
        catch (Exception e) {
            log.error("Failed to retrieve projects currently preparing build", (Throwable)e);
            throw new Exception("Failed to retrieve projects currently preparing build", e);
        }
        return projects;
    }

    public List<Map<String, Object>> getProjectsAndBuildDefinitionsCurrentlyPreparingBuild() throws Exception {
        List projects;
        try {
            projects = this.slave.getProjectsAndBuildDefinitionsCurrentlyPreparingBuild();
            log.info("Retrieving projects currently preparing build");
        }
        catch (Exception e) {
            log.error("Failed to retrieve projects currently preparing build", (Throwable)e);
            throw new Exception("Failed to retrieve projects currently preparing build", e);
        }
        return projects;
    }

    public List<Map<String, Object>> getProjectsInBuildQueue() throws Exception {
        List projects;
        try {
            projects = this.slave.getProjectsInBuildQueue();
            log.info("Retrieving projects in build queue");
        }
        catch (Exception e) {
            log.error("Failed to retrieve projects in build queue", (Throwable)e);
            throw new Exception("Failed to retrieve projects in build queue", e);
        }
        return projects;
    }

    public List<Map<String, Object>> getProjectsInPrepareBuildQueue() throws Exception {
        List projects;
        try {
            projects = this.slave.getProjectsInPrepareBuildQueue();
            log.info("Retrieving projects in prepare build queue");
        }
        catch (Exception e) {
            log.error("Failed to retrieve projects in prepare build queue", (Throwable)e);
            throw new Exception("Failed to retrieve projects in prepare build queue", e);
        }
        return projects;
    }

    public List<Map<String, Object>> getProjectsAndBuildDefinitionsInPrepareBuildQueue() throws Exception {
        List projects;
        try {
            projects = this.slave.getProjectsAndBuildDefinitionsInPrepareBuildQueue();
            log.info("Retrieving projects in prepare build queue");
        }
        catch (Exception e) {
            log.error("Failed to retrieve projects in prepare build queue", (Throwable)e);
            throw new Exception("Failed to retrieve projects in prepare build queue", e);
        }
        return projects;
    }

    public Boolean isProjectGroupInQueue(int projectGroupId) throws Exception {
        Boolean result;
        try {
            result = this.slave.isProjectGroupInQueue(projectGroupId);
            log.info("Checking if project group '" + projectGroupId + "' is in queue");
        }
        catch (Exception e) {
            log.error("Failed to check if project group '" + projectGroupId + "' is in queue", (Throwable)e);
            throw new Exception("Failed to check if project group '" + projectGroupId + "' is in queue", e);
        }
        return result;
    }

    public Boolean isProjectScmRootInQueue(int projectScmRootId, List<Integer> projectIds) throws Exception {
        Boolean result;
        try {
            result = this.slave.isProjectScmRootInQueue(projectScmRootId, projectIds);
            log.info("Checking if project scm root '" + projectScmRootId + "' is in queue");
        }
        catch (Exception e) {
            log.error("Failed to check if project scm root '" + projectScmRootId + "' is in queue", (Throwable)e);
            throw new Exception("Failed to check if project scm root '" + projectScmRootId + "' is in queue", e);
        }
        return result;
    }

    public Boolean isProjectCurrentlyBuilding(int projectId) throws Exception {
        Boolean result;
        try {
            result = this.slave.isProjectCurrentlyBuilding(projectId);
            log.info("Checking if project " + projectId + " is currently building in agent");
        }
        catch (Exception e) {
            log.error("Failed to check if project " + projectId + " is currently building in agent", (Throwable)e);
            throw new Exception("Failed to check if project " + projectId + " is currently building in agent", e);
        }
        return result;
    }

    public Boolean isProjectInBuildQueue(int projectId) throws Exception {
        Boolean result;
        try {
            result = this.slave.isProjectInBuildQueue(projectId);
            log.info("Checking if project " + projectId + "is in build queue of agent");
        }
        catch (Exception e) {
            log.error("Failed to check if project " + projectId + " is in build queue of agent", (Throwable)e);
            throw new Exception("Failed to check if project " + projectId + " is in build queue of agent", e);
        }
        return result;
    }

    public Boolean removeFromPrepareBuildQueue(int projectGroupId, int scmRootId) throws Exception {
        Boolean result;
        try {
            result = this.slave.removeFromPrepareBuildQueue(projectGroupId, scmRootId);
            log.debug("Remove projects from prepare build queue. projectGroupId=" + projectGroupId + ", scmRootId=" + scmRootId);
        }
        catch (Exception e) {
            log.error("Failed to remove projects from prepare build queue. projectGroupId=" + projectGroupId + ", scmRootId=" + scmRootId);
            throw new Exception("Failed to remove from prepare build queue. projectGroupId=" + projectGroupId + " scmRootId=" + scmRootId, e);
        }
        return result;
    }

    public Boolean removeFromPrepareBuildQueue(List<String> hashCodes) throws Exception {
        Boolean result;
        try {
            result = this.slave.removeFromPrepareBuildQueue(hashCodes);
            log.info("Removing projects from prepare build queue of agent");
        }
        catch (Exception e) {
            log.error("Failed to remove projects from prepare build queue of agent", (Throwable)e);
            throw new Exception("Failed to remove projects from prepare build queue of agent", e);
        }
        return result;
    }

    public Boolean removeFromBuildQueue(int projectId, int buildDefinitionId) throws Exception {
        Boolean result;
        try {
            result = this.slave.removeFromBuildQueue(projectId, buildDefinitionId);
            log.info("Removing project '" + projectId + "' from build queue of agent");
        }
        catch (Exception e) {
            log.error("Failed to remove project '" + projectId + "' from build queue of agent", (Throwable)e);
            throw new Exception("Failed to remove project '" + projectId + "' from build queue of agent", e);
        }
        return result;
    }

    public Boolean removeFromBuildQueue(List<String> hashCodes) throws Exception {
        Boolean result;
        try {
            result = this.slave.removeFromBuildQueue(hashCodes);
            log.info("Removing projects from build queue of agent");
        }
        catch (Exception e) {
            log.error("Failed to remove projects from build queue of agent", (Throwable)e);
            throw new Exception("Failed to remove projects from build queue of agent", e);
        }
        return result;
    }
}

