/*
 * Decompiled with CFR 0.152.
 */
package org.apache.continuum.distributed.transport.master;

import com.atlassian.xmlrpc.AuthenticationInfo;
import com.atlassian.xmlrpc.BindingException;
import com.atlassian.xmlrpc.DefaultBinder;
import java.net.URL;
import java.util.Map;
import org.apache.continuum.distributed.commons.utils.ContinuumDistributedUtil;
import org.apache.continuum.distributed.transport.master.MasterBuildAgentTransportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterBuildAgentTransportClient
implements MasterBuildAgentTransportService {
    private static final Logger log = LoggerFactory.getLogger(MasterBuildAgentTransportClient.class);
    MasterBuildAgentTransportService master;

    public MasterBuildAgentTransportClient(URL serviceUrl) throws Exception {
        this(serviceUrl, null, null);
    }

    public MasterBuildAgentTransportClient(URL serviceUrl, String login, String password) throws Exception {
        DefaultBinder binder = new DefaultBinder();
        AuthenticationInfo authnInfo = new AuthenticationInfo(login, password);
        try {
            this.master = (MasterBuildAgentTransportService)binder.bind(MasterBuildAgentTransportService.class, serviceUrl, authnInfo);
        }
        catch (BindingException e) {
            log.error("Can't bind service interface " + MasterBuildAgentTransportService.class.getName() + " to " + serviceUrl.toExternalForm() + " using " + authnInfo.getUsername() + ", " + authnInfo.getPassword(), (Throwable)e);
            throw new Exception("Can't bind service interface " + MasterBuildAgentTransportService.class.getName() + " to " + serviceUrl.toExternalForm() + " using " + authnInfo.getUsername() + ", " + authnInfo.getPassword(), e);
        }
    }

    public Boolean returnBuildResult(Map<String, Object> buildResult) throws Exception {
        Boolean result;
        String projectInfo = ContinuumDistributedUtil.getProjectNameAndId(buildResult);
        try {
            result = this.master.returnBuildResult(buildResult);
            log.info("Returning the build result for project " + projectInfo + ".");
        }
        catch (Exception e) {
            log.error("Failed to return the build result for project " + projectInfo + ".", (Throwable)e);
            throw new Exception("Failed to return the build result for project " + projectInfo + ".", e);
        }
        return result;
    }

    public Boolean ping() throws Exception {
        Boolean result;
        try {
            result = this.master.ping();
            log.info("Ping " + (result != false ? "ok" : "failed"));
        }
        catch (Exception e) {
            log.info("Ping error");
            throw new Exception("Ping error", e);
        }
        return result;
    }

    public Boolean prepareBuildFinished(Map<String, Object> prepareBuildResult) throws Exception {
        Boolean result;
        String projectInfo = ContinuumDistributedUtil.getProjectNameAndId(prepareBuildResult);
        try {
            result = this.master.prepareBuildFinished(prepareBuildResult);
            log.info("Prepare build finished for project " + projectInfo + ".");
        }
        catch (Exception e) {
            log.error("Failed to finish prepare build for project " + projectInfo + ".");
            throw new Exception("Failed to finish prepare build for project " + projectInfo + ".", e);
        }
        return result;
    }

    public Boolean startProjectBuild(Integer projectId) throws Exception {
        Boolean result;
        try {
            result = this.master.startProjectBuild(projectId);
            log.info("Return project currently building, projectId=" + projectId);
        }
        catch (Exception e) {
            log.error("Failed to return project currently building, projectId=" + projectId, (Throwable)e);
            throw new Exception("Failed to return project currently building, projectId=" + projectId, e);
        }
        return result;
    }

    public Boolean startPrepareBuild(Map<String, Object> prepareBuildResult) throws Exception {
        Boolean result;
        String projectInfo = ContinuumDistributedUtil.getProjectNameAndId(prepareBuildResult);
        try {
            result = this.master.startPrepareBuild(prepareBuildResult);
            log.info("Start prepare build for project " + projectInfo);
        }
        catch (Exception e) {
            log.error("Failed to start prepare build for project " + projectInfo, (Throwable)e);
            throw new Exception("Failed to start prepare build for project " + projectInfo, e);
        }
        return result;
    }

    public Map<String, String> getEnvironments(Integer buildDefinitionId, String installationType) throws Exception {
        Map result;
        try {
            result = this.master.getEnvironments(buildDefinitionId, installationType);
            log.info("Retrieved environments. buildDefinitionId=" + buildDefinitionId + ", installationType=" + installationType);
        }
        catch (Exception e) {
            log.error("Failed to retrieve environments. buildDefinitionId=" + buildDefinitionId + ", installationType=" + installationType, (Throwable)e);
            throw new Exception("Failed to retrieve environments. buildDefinitionId=" + buildDefinitionId + ", installationType=" + installationType, e);
        }
        return result;
    }

    public Boolean updateProject(Map<String, Object> project) throws Exception {
        Boolean result;
        String projectInfo = ContinuumDistributedUtil.getProjectNameAndId(project);
        try {
            result = this.master.updateProject(project);
            log.info("Updating project " + projectInfo);
        }
        catch (Exception e) {
            log.error("Failed to update project " + projectInfo, (Throwable)e);
            throw new Exception("Failed to update project " + projectInfo, e);
        }
        return result;
    }

    public Boolean shouldBuild(Map<String, Object> context) throws Exception {
        Boolean result;
        String projectInfo = ContinuumDistributedUtil.getProjectNameAndId(context);
        try {
            result = this.master.shouldBuild(context);
            log.info("Checking if project " + projectInfo + " should build");
        }
        catch (Exception e) {
            log.error("Failed to determine if project " + projectInfo + " should build", (Throwable)e);
            throw new Exception("Failed to determine if project " + projectInfo + " should build", e);
        }
        return result;
    }
}

