/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.simple;

import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.RDFTermFactory;
import org.apache.commons.rdf.api.Triple;
import org.apache.commons.rdf.simple.SimpleRDFTermFactory;
import org.apache.commons.rdf.simple.Types;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestWritingGraph {
    private static final long TRIPLES = Long.getLong("triples", 200000L);
    private static boolean KEEP_FILES = Boolean.getBoolean("keepfiles");
    private static Graph graph;
    private static RDFTermFactory factory;

    @BeforeClass
    public static void createGraph() throws Exception {
        factory = new SimpleRDFTermFactory();
        graph = factory.createGraph();
        IRI subject = factory.createIRI("subj");
        IRI predicate = factory.createIRI("pred");
        ArrayList types = new ArrayList(Types.values());
        types.remove(Types.RDF_LANGSTRING);
        Collections.shuffle(types);
        int i = 0;
        while ((long)i < TRIPLES) {
            if (i % 11 == 0) {
                graph.add((BlankNodeOrIRI)subject, predicate, (RDFTerm)factory.createBlankNode("Example " + i));
            } else if (i % 5 == 0) {
                graph.add((BlankNodeOrIRI)subject, predicate, (RDFTerm)factory.createLiteral("Example " + i, "en"));
            } else if (i % 3 == 0) {
                graph.add((BlankNodeOrIRI)subject, predicate, (RDFTerm)factory.createLiteral("Example " + i, (IRI)types.get(i % types.size())));
            } else {
                graph.add((BlankNodeOrIRI)subject, predicate, (RDFTerm)factory.createLiteral("Example " + i));
            }
            ++i;
        }
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        graph.clear();
        graph = null;
    }

    @Test
    public void createGraphTiming() throws Exception {
        TestWritingGraph.createGraph();
    }

    @Test
    public void countQuery() {
        IRI subject = factory.createIRI("subj");
        IRI predicate = factory.createIRI("pred");
        long count = ((Stream)((Stream)graph.getTriples((BlankNodeOrIRI)subject, predicate, null).unordered()).parallel()).count();
        Assert.assertEquals((long)count, (long)TRIPLES);
    }

    public static String tripleAsString(Triple t) {
        return t.getSubject().ntriplesString() + " " + t.getPredicate().ntriplesString() + " " + t.getObject().ntriplesString() + " .";
    }

    @Test
    public void writeGraphFromStream() throws Exception {
        Path graphFile = Files.createTempFile("graph", ".nt", new FileAttribute[0]);
        if (KEEP_FILES) {
            System.out.println("From stream: " + graphFile);
        } else {
            graphFile.toFile().deleteOnExit();
        }
        Stream<CharSequence> stream = graph.getTriples().map(TestWritingGraph::tripleAsString);
        Files.write(graphFile, stream::iterator, Charset.forName("UTF-8"), new OpenOption[0]);
    }

    @Test
    public void writeGraphFromStreamFiltered() throws Exception {
        Path graphFile = Files.createTempFile("graph", ".nt", new FileAttribute[0]);
        if (KEEP_FILES) {
            System.out.println("Filtered stream: " + graphFile);
        } else {
            graphFile.toFile().deleteOnExit();
        }
        IRI subject = factory.createIRI("subj");
        IRI predicate = factory.createIRI("pred");
        Stream<CharSequence> stream = graph.getTriples((BlankNodeOrIRI)subject, predicate, null).map(TestWritingGraph::tripleAsString);
        Files.write(graphFile, stream::iterator, Charset.forName("UTF-8"), new OpenOption[0]);
    }

    @Test
    public void writeGraphFromStreamFilteredNoMatches() throws Exception {
        Path graphFile = Files.createTempFile("graph-empty-", ".nt", new FileAttribute[0]);
        if (KEEP_FILES) {
            System.out.println("Filtered stream: " + graphFile);
        } else {
            graphFile.toFile().deleteOnExit();
        }
        IRI subject = factory.createIRI("nonexistent");
        IRI predicate = factory.createIRI("pred");
        Stream<CharSequence> stream = graph.getTriples((BlankNodeOrIRI)subject, predicate, null).map(Object::toString);
        Files.write(graphFile, stream::iterator, Charset.forName("UTF-8"), new OpenOption[0]);
    }
}

