/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class AtomicIntegerFactory
extends BasePooledObjectFactory<AtomicInteger> {
    private long activateLatency = 0L;
    private long passivateLatency = 0L;
    private long createLatency = 0L;
    private long destroyLatency = 0L;
    private long validateLatency = 0L;

    public void activateObject(PooledObject<AtomicInteger> p) {
        ((AtomicInteger)p.getObject()).incrementAndGet();
        try {
            Thread.sleep(this.activateLatency);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public AtomicInteger create() {
        try {
            Thread.sleep(this.createLatency);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new AtomicInteger(0);
    }

    public void destroyObject(PooledObject<AtomicInteger> p) {
        try {
            Thread.sleep(this.destroyLatency);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void passivateObject(PooledObject<AtomicInteger> p) {
        ((AtomicInteger)p.getObject()).decrementAndGet();
        try {
            Thread.sleep(this.passivateLatency);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setActivateLatency(long activateLatency) {
        this.activateLatency = activateLatency;
    }

    public void setCreateLatency(long createLatency) {
        this.createLatency = createLatency;
    }

    public void setDestroyLatency(long destroyLatency) {
        this.destroyLatency = destroyLatency;
    }

    public void setPassivateLatency(long passivateLatency) {
        this.passivateLatency = passivateLatency;
    }

    public void setValidateLatency(long validateLatency) {
        this.validateLatency = validateLatency;
    }

    public boolean validateObject(PooledObject<AtomicInteger> instance) {
        try {
            Thread.sleep(this.validateLatency);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return ((AtomicInteger)instance.getObject()).intValue() == 1;
    }

    public PooledObject<AtomicInteger> wrap(AtomicInteger integer) {
        return new DefaultPooledObject((Object)integer);
    }
}

