/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.proxy;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.commons.pool2.proxy.ProxiedObjectPool;
import org.apache.commons.pool2.proxy.ProxySource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseTestProxiedObjectPool {
    private static final String DATA1 = "data1";
    private static final int ABANDONED_TIMEOUT_SECS = 3;
    private ObjectPool<TestObject> pool = null;
    private StringWriter log = null;

    @Before
    public void setUp() {
        this.log = new StringWriter();
        PrintWriter pw = new PrintWriter(this.log);
        AbandonedConfig abandonedConfig = new AbandonedConfig();
        abandonedConfig.setLogAbandoned(true);
        abandonedConfig.setRemoveAbandonedOnBorrow(true);
        abandonedConfig.setUseUsageTracking(true);
        abandonedConfig.setRemoveAbandonedTimeout(3);
        abandonedConfig.setLogWriter(pw);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(3);
        TestObjectFactory factory = new TestObjectFactory();
        GenericObjectPool innerPool = new GenericObjectPool((PooledObjectFactory)factory, config, abandonedConfig);
        this.pool = new ProxiedObjectPool((ObjectPool)innerPool, this.getproxySource());
    }

    protected abstract ProxySource<TestObject> getproxySource();

    @Test
    public void testBorrowObject() throws Exception {
        TestObject obj = (TestObject)this.pool.borrowObject();
        Assert.assertNotNull((Object)obj);
        obj.setData(DATA1);
        Assert.assertEquals((Object)DATA1, (Object)obj.getData());
        this.pool.returnObject((Object)obj);
    }

    @Test(expected=IllegalStateException.class)
    public void testAccessAfterReturn() throws Exception {
        TestObject obj = (TestObject)this.pool.borrowObject();
        Assert.assertNotNull((Object)obj);
        obj.setData(DATA1);
        Assert.assertEquals((Object)DATA1, (Object)obj.getData());
        this.pool.returnObject((Object)obj);
        Assert.assertNotNull((Object)obj);
        obj.getData();
    }

    @Test(expected=IllegalStateException.class)
    public void testAccessAfterInvalidate() throws Exception {
        TestObject obj = (TestObject)this.pool.borrowObject();
        Assert.assertNotNull((Object)obj);
        obj.setData(DATA1);
        Assert.assertEquals((Object)DATA1, (Object)obj.getData());
        this.pool.invalidateObject((Object)obj);
        Assert.assertNotNull((Object)obj);
        obj.getData();
    }

    @Test
    public void testUsageTracking() throws Exception {
        TestObject obj = (TestObject)this.pool.borrowObject();
        Assert.assertNotNull((Object)obj);
        obj.setData(DATA1);
        Thread.sleep(5000L);
        this.pool.borrowObject();
        String logOutput = this.log.getBuffer().toString();
        Assert.assertTrue((boolean)logOutput.contains("Pooled object created"));
        Assert.assertTrue((boolean)logOutput.contains("The last code to use this object was"));
    }

    @Test
    public void testPassThroughMethods01() throws Exception {
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        this.pool.addObject();
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)1L, (long)this.pool.getNumIdle());
        this.pool.clear();
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
    }

    @Test(expected=IllegalStateException.class)
    public void testPassThroughMethods02() throws Exception {
        this.pool.close();
        this.pool.addObject();
    }

    private static class TestObjectImpl
    implements TestObject {
        private String data;

        private TestObjectImpl() {
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public void setData(String data) {
            this.data = data;
        }
    }

    protected static interface TestObject {
        public String getData();

        public void setData(String var1);
    }

    private static class TestObjectFactory
    extends BasePooledObjectFactory<TestObject> {
        private TestObjectFactory() {
        }

        public TestObject create() throws Exception {
            return new TestObjectImpl();
        }

        public PooledObject<TestObject> wrap(TestObject value) {
            return new DefaultPooledObject((Object)value);
        }
    }
}

