/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.Waiter;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class WaiterFactory<K>
implements PooledObjectFactory<Waiter>,
KeyedPooledObjectFactory<K, Waiter> {
    private final long activateLatency;
    private final long destroyLatency;
    private final long makeLatency;
    private final long passivateLatency;
    private final long validateLatency;
    private final long waiterLatency;
    private final double passivateInvalidationProbability;
    private long activeCount = 0L;
    private final Map<K, Integer> activeCounts = new HashMap<K, Integer>();
    private final long maxActive;
    private final long maxActivePerKey;

    public WaiterFactory(long activateLatency, long destroyLatency, long makeLatency, long passivateLatency, long validateLatency, long waiterLatency, long maxActive, long maxActivePerKey, double passivateInvalidationProbability) {
        this.activateLatency = activateLatency;
        this.destroyLatency = destroyLatency;
        this.makeLatency = makeLatency;
        this.passivateLatency = passivateLatency;
        this.validateLatency = validateLatency;
        this.waiterLatency = waiterLatency;
        this.maxActive = maxActive;
        this.maxActivePerKey = maxActivePerKey;
        this.passivateInvalidationProbability = passivateInvalidationProbability;
    }

    public WaiterFactory(long activateLatency, long destroyLatency, long makeLatency, long passivateLatency, long validateLatency, long waiterLatency) {
        this(activateLatency, destroyLatency, makeLatency, passivateLatency, validateLatency, waiterLatency, Long.MAX_VALUE, Long.MAX_VALUE, 0.0);
    }

    public WaiterFactory(long activateLatency, long destroyLatency, long makeLatency, long passivateLatency, long validateLatency, long waiterLatency, long maxActive) {
        this(activateLatency, destroyLatency, makeLatency, passivateLatency, validateLatency, waiterLatency, maxActive, Long.MAX_VALUE, 0.0);
    }

    public void activateObject(PooledObject<Waiter> obj) throws Exception {
        this.doWait(this.activateLatency);
        ((Waiter)obj.getObject()).setActive(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(PooledObject<Waiter> obj) throws Exception {
        this.doWait(this.destroyLatency);
        ((Waiter)obj.getObject()).setValid(false);
        ((Waiter)obj.getObject()).setActive(false);
        WaiterFactory waiterFactory = this;
        synchronized (waiterFactory) {
            --this.activeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledObject<Waiter> makeObject() throws Exception {
        WaiterFactory waiterFactory = this;
        synchronized (waiterFactory) {
            if (this.activeCount >= this.maxActive) {
                throw new IllegalStateException("Too many active instances: " + this.activeCount + " in circulation with maxActive = " + this.maxActive);
            }
            ++this.activeCount;
        }
        this.doWait(this.makeLatency);
        return new DefaultPooledObject((Object)new Waiter(false, true, this.waiterLatency));
    }

    public void passivateObject(PooledObject<Waiter> obj) throws Exception {
        ((Waiter)obj.getObject()).setActive(false);
        this.doWait(this.passivateLatency);
        if (Math.random() < this.passivateInvalidationProbability) {
            ((Waiter)obj.getObject()).setValid(false);
        }
    }

    public boolean validateObject(PooledObject<Waiter> obj) {
        this.doWait(this.validateLatency);
        return ((Waiter)obj.getObject()).isValid();
    }

    protected void doWait(long latency) {
        if (latency == 0L) {
            return;
        }
        try {
            Thread.sleep(latency);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void reset() {
        this.activeCount = 0L;
        if (this.activeCounts.isEmpty()) {
            return;
        }
        for (K key : this.activeCounts.keySet()) {
            this.activeCounts.put(key, 0);
        }
    }

    public synchronized long getMaxActive() {
        return this.maxActive;
    }

    public void activateObject(K key, PooledObject<Waiter> obj) throws Exception {
        this.activateObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(K key, PooledObject<Waiter> obj) throws Exception {
        this.destroyObject(obj);
        WaiterFactory waiterFactory = this;
        synchronized (waiterFactory) {
            Integer count = this.activeCounts.get(key);
            this.activeCounts.put(key, count - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledObject<Waiter> makeObject(K key) throws Exception {
        WaiterFactory waiterFactory = this;
        synchronized (waiterFactory) {
            Integer count = this.activeCounts.get(key);
            if (count == null) {
                count = 1;
                this.activeCounts.put(key, count);
            } else {
                if ((long)count.intValue() >= this.maxActivePerKey) {
                    throw new IllegalStateException("Too many active instances for key = " + key + ": " + count + " in circulation " + "with maxActivePerKey = " + this.maxActivePerKey);
                }
                this.activeCounts.put(key, count + 1);
            }
        }
        return this.makeObject();
    }

    public void passivateObject(K key, PooledObject<Waiter> obj) throws Exception {
        this.passivateObject(obj);
    }

    public boolean validateObject(K key, PooledObject<Waiter> obj) {
        return this.validateObject(obj);
    }
}

