/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.text.SimpleDateFormat;
import java.util.Set;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObjectInfo;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.commons.pool2.impl.TestGenericObjectPool;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultPooledObjectInfo {
    @Test
    public void testTiming() throws Exception {
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new TestGenericObjectPool.SimpleFactory());
        long t1 = System.currentTimeMillis();
        Thread.sleep(50L);
        String s1 = (String)pool.borrowObject();
        Thread.sleep(50L);
        long t2 = System.currentTimeMillis();
        Thread.sleep(50L);
        pool.returnObject((Object)s1);
        Thread.sleep(50L);
        long t3 = System.currentTimeMillis();
        Thread.sleep(50L);
        pool.borrowObject();
        Thread.sleep(50L);
        long t4 = System.currentTimeMillis();
        Set strings = pool.listAllObjects();
        Assert.assertEquals((long)1L, (long)strings.size());
        DefaultPooledObjectInfo s1Info = (DefaultPooledObjectInfo)strings.iterator().next();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        Assert.assertTrue((s1Info.getCreateTime() > t1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)sdf.format(s1Info.getCreateTime()), (Object)s1Info.getCreateTimeFormatted());
        Assert.assertTrue((s1Info.getCreateTime() < t2 ? 1 : 0) != 0);
        Assert.assertTrue((s1Info.getLastReturnTime() > t2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)sdf.format(s1Info.getLastReturnTime()), (Object)s1Info.getLastReturnTimeFormatted());
        Assert.assertTrue((s1Info.getLastReturnTime() < t3 ? 1 : 0) != 0);
        Assert.assertTrue((s1Info.getLastBorrowTime() > t3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)sdf.format(s1Info.getLastBorrowTime()), (Object)s1Info.getLastBorrowTimeFormatted());
        Assert.assertTrue((s1Info.getLastBorrowTime() < t4 ? 1 : 0) != 0);
    }

    @Test
    public void testGetPooledObjectType() throws Exception {
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new TestGenericObjectPool.SimpleFactory());
        pool.borrowObject();
        Set strings = pool.listAllObjects();
        Assert.assertEquals((long)1L, (long)strings.size());
        DefaultPooledObjectInfo s1Info = (DefaultPooledObjectInfo)strings.iterator().next();
        Assert.assertEquals((Object)String.class.getName(), (Object)s1Info.getPooledObjectType());
    }

    @Test
    public void testGetPooledObjectToString() throws Exception {
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new TestGenericObjectPool.SimpleFactory());
        String s1 = (String)pool.borrowObject();
        Set strings = pool.listAllObjects();
        Assert.assertEquals((long)1L, (long)strings.size());
        DefaultPooledObjectInfo s1Info = (DefaultPooledObjectInfo)strings.iterator().next();
        Assert.assertEquals((Object)s1, (Object)s1Info.getPooledObjectToString());
    }

    @Test
    public void testGetLastBorrowTrace() throws Exception {
        AbandonedConfig abandonedConfig = new AbandonedConfig();
        abandonedConfig.setRemoveAbandonedOnBorrow(true);
        abandonedConfig.setRemoveAbandonedTimeout(1);
        abandonedConfig.setLogAbandoned(true);
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new TestGenericObjectPool.SimpleFactory(), new GenericObjectPoolConfig(), abandonedConfig);
        try {
            pool.borrowObject();
        }
        catch (DefaultPooledObject.AbandonedObjectCreatedException abandonedObjectCreatedException) {
            // empty catch block
        }
        Set strings = pool.listAllObjects();
        DefaultPooledObjectInfo s1Info = (DefaultPooledObjectInfo)strings.iterator().next();
        String lastBorrowTrace = s1Info.getLastBorrowTrace();
        Assert.assertTrue((boolean)lastBorrowTrace.startsWith(DefaultPooledObject.AbandonedObjectCreatedException.class.getName()));
    }
}

