/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool2.MethodCall;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.PrivateException;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class MethodCallPoolableObjectFactory
implements PooledObjectFactory<Object> {
    private final List<MethodCall> methodCalls = new ArrayList<MethodCall>();
    private int count = 0;
    private boolean valid = true;
    private boolean makeObjectFail;
    private boolean activateObjectFail;
    private boolean validateObjectFail;
    private boolean passivateObjectFail;
    private boolean destroyObjectFail;

    public void reset() {
        this.count = 0;
        this.getMethodCalls().clear();
        this.setMakeObjectFail(false);
        this.setActivateObjectFail(false);
        this.setValid(true);
        this.setValidateObjectFail(false);
        this.setPassivateObjectFail(false);
        this.setDestroyObjectFail(false);
    }

    public List<MethodCall> getMethodCalls() {
        return this.methodCalls;
    }

    public int getCurrentCount() {
        return this.count;
    }

    public void setCurrentCount(int count) {
        this.count = count;
    }

    public boolean isMakeObjectFail() {
        return this.makeObjectFail;
    }

    public void setMakeObjectFail(boolean makeObjectFail) {
        this.makeObjectFail = makeObjectFail;
    }

    public boolean isDestroyObjectFail() {
        return this.destroyObjectFail;
    }

    public void setDestroyObjectFail(boolean destroyObjectFail) {
        this.destroyObjectFail = destroyObjectFail;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValidateObjectFail() {
        return this.validateObjectFail;
    }

    public void setValidateObjectFail(boolean validateObjectFail) {
        this.validateObjectFail = validateObjectFail;
    }

    public boolean isActivateObjectFail() {
        return this.activateObjectFail;
    }

    public void setActivateObjectFail(boolean activateObjectFail) {
        this.activateObjectFail = activateObjectFail;
    }

    public boolean isPassivateObjectFail() {
        return this.passivateObjectFail;
    }

    public void setPassivateObjectFail(boolean passivateObjectFail) {
        this.passivateObjectFail = passivateObjectFail;
    }

    public PooledObject<Object> makeObject() throws Exception {
        MethodCall call = new MethodCall("makeObject");
        this.methodCalls.add(call);
        int originalCount = this.count++;
        if (this.makeObjectFail) {
            throw new PrivateException("makeObject");
        }
        Integer obj = new Integer(originalCount);
        call.setReturned(obj);
        return new DefaultPooledObject((Object)obj);
    }

    public void activateObject(PooledObject<Object> obj) throws Exception {
        this.methodCalls.add(new MethodCall("activateObject", obj.getObject()));
        if (this.activateObjectFail) {
            throw new PrivateException("activateObject");
        }
    }

    public boolean validateObject(PooledObject<Object> obj) {
        MethodCall call = new MethodCall("validateObject", obj.getObject());
        this.methodCalls.add(call);
        if (this.validateObjectFail) {
            throw new PrivateException("validateObject");
        }
        boolean r = this.valid;
        call.returned(r);
        return r;
    }

    public void passivateObject(PooledObject<Object> obj) throws Exception {
        this.methodCalls.add(new MethodCall("passivateObject", obj.getObject()));
        if (this.passivateObjectFail) {
            throw new PrivateException("passivateObject");
        }
    }

    public void destroyObject(PooledObject<Object> obj) throws Exception {
        this.methodCalls.add(new MethodCall("destroyObject", obj.getObject()));
        if (this.destroyObjectFail) {
            throw new PrivateException("destroyObject");
        }
    }
}

