/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.extras.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.jcs.jcache.extras.web.JCacheFilter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JCacheFilterTest {
    private final ThreadLocal<ByteArrayOutputStream> outputStreamAsBytes = new ThreadLocal<ByteArrayOutputStream>(){

        @Override
        protected ByteArrayOutputStream initialValue() {
            return new ByteArrayOutputStream();
        }
    };
    private final ThreadLocal<ServletOutputStream> outputStream = new ThreadLocal<ServletOutputStream>(){

        @Override
        protected ServletOutputStream initialValue() {
            return new ServletOutputStream(){

                public void write(int b) throws IOException {
                    ((ByteArrayOutputStream)JCacheFilterTest.this.outputStreamAsBytes.get()).write(b);
                }
            };
        }

        @Override
        public void remove() {
            super.remove();
            JCacheFilterTest.this.outputStreamAsBytes.remove();
        }
    };

    @Before
    @After
    public void cleanup() {
        this.outputStream.remove();
    }

    @Test
    public void testFilterNoOutput() throws ServletException, IOException {
        JCacheFilter filter = this.initFilter();
        final AtomicInteger counter = new AtomicInteger(0);
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                counter.incrementAndGet();
                response.getWriter().write("");
            }
        };
        filter.doFilter((ServletRequest)new HttpServletRequestWrapper(this.newProxy(HttpServletRequest.class)), (ServletResponse)new HttpServletResponseWrapper(this.newProxy(HttpServletResponse.class)), chain);
        Assert.assertEquals((long)1L, (long)counter.get());
        Assert.assertEquals((Object)"", (Object)new String(this.outputStreamAsBytes.get().toByteArray()));
        this.outputStream.remove();
        filter.doFilter((ServletRequest)new HttpServletRequestWrapper(this.newProxy(HttpServletRequest.class)), (ServletResponse)new HttpServletResponseWrapper(this.newProxy(HttpServletResponse.class)), chain);
        Assert.assertEquals((long)1L, (long)counter.get());
        Assert.assertEquals((Object)"", (Object)new String(this.outputStreamAsBytes.get().toByteArray()));
        filter.destroy();
    }

    @Test
    public void testFilter() throws ServletException, IOException {
        JCacheFilter filter = this.initFilter();
        final AtomicInteger counter = new AtomicInteger(0);
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                counter.incrementAndGet();
                response.getWriter().write("Hello!");
            }
        };
        filter.doFilter((ServletRequest)new HttpServletRequestWrapper(this.newProxy(HttpServletRequest.class)), (ServletResponse)new HttpServletResponseWrapper(this.newProxy(HttpServletResponse.class)), chain);
        Assert.assertEquals((long)1L, (long)counter.get());
        Assert.assertEquals((Object)"Hello!", (Object)new String(this.outputStreamAsBytes.get().toByteArray()));
        this.outputStream.remove();
        filter.doFilter((ServletRequest)new HttpServletRequestWrapper(this.newProxy(HttpServletRequest.class)), (ServletResponse)new HttpServletResponseWrapper(this.newProxy(HttpServletResponse.class)), chain);
        Assert.assertEquals((long)1L, (long)counter.get());
        Assert.assertEquals((Object)"Hello!", (Object)new String(this.outputStreamAsBytes.get().toByteArray()));
        filter.destroy();
    }

    private JCacheFilter initFilter() throws ServletException {
        JCacheFilter filter = new JCacheFilter();
        filter.init(new FilterConfig(){

            public String getFilterName() {
                return null;
            }

            public ServletContext getServletContext() {
                return (ServletContext)JCacheFilterTest.this.newProxy(ServletContext.class);
            }

            public String getInitParameter(String name) {
                return null;
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.enumeration(Collections.emptySet());
            }
        });
        return filter;
    }

    private <T> T newProxy(Class<T> clazz) {
        return clazz.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getReturnType().getName().equals("boolean")) {
                    return false;
                }
                if ("getCharacterEncoding".equals(method.getName())) {
                    return "UTF-8";
                }
                if ("getOutputStream".equals(method.getName())) {
                    return JCacheFilterTest.this.outputStream.get();
                }
                return null;
            }
        }));
    }
}

