/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.control;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.admin.JCSAdminBean;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheFactory;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.commons.jcs.engine.CompositeCacheAttributes;
import org.apache.commons.jcs.engine.ElementAttributes;
import org.apache.commons.jcs.engine.behavior.ICache;
import org.apache.commons.jcs.engine.behavior.ICacheType;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.behavior.IProvideScheduler;
import org.apache.commons.jcs.engine.behavior.IShutdownObserver;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheConfigurator;
import org.apache.commons.jcs.engine.control.event.ElementEventQueue;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventQueue;
import org.apache.commons.jcs.engine.stats.CacheStats;
import org.apache.commons.jcs.engine.stats.behavior.ICacheStats;
import org.apache.commons.jcs.utils.config.OptionConverter;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.jcs.utils.threadpool.ThreadPoolManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeCacheManager
implements IRemoteCacheConstants,
ICompositeCacheManager,
IProvideScheduler {
    private static final Log log = LogFactory.getLog(CompositeCacheManager.class);
    public static final String JMX_OBJECT_NAME = "org.apache.commons.jcs:type=JCSAdminBean";
    private static final String DEFAULT_REGION = "jcs.default";
    private final ConcurrentMap<String, ICache<?, ?>> caches = new ConcurrentHashMap();
    private final ReentrantLock cacheLock = new ReentrantLock();
    private final AtomicInteger clients = new AtomicInteger(0);
    private ICompositeCacheAttributes defaultCacheAttr = new CompositeCacheAttributes();
    private IElementAttributes defaultElementAttr = new ElementAttributes();
    private final ConcurrentMap<String, AuxiliaryCacheFactory> auxiliaryFactoryRegistry = new ConcurrentHashMap<String, AuxiliaryCacheFactory>();
    private final ConcurrentMap<String, AuxiliaryCacheAttributes> auxiliaryAttributeRegistry = new ConcurrentHashMap<String, AuxiliaryCacheAttributes>();
    private final ConcurrentMap<String, AuxiliaryCache<?, ?>> auxiliaryCaches = new ConcurrentHashMap();
    private Properties configurationProperties;
    private String defaultAuxValues;
    private static CompositeCacheManager instance;
    private static final boolean DEFAULT_USE_SYSTEM_PROPERTIES = true;
    private static final boolean DEFAULT_FORCE_RECONFIGURATION = false;
    private final LinkedHashSet<IShutdownObserver> shutdownObservers = new LinkedHashSet();
    private ScheduledExecutorService scheduledExecutor;
    private IElementEventQueue elementEventQueue;
    private ShutdownHook shutdownHook;
    private boolean isInitialized = false;
    private boolean isConfigured = false;
    private boolean isJMXRegistered = false;
    private String jmxName = "org.apache.commons.jcs:type=JCSAdminBean";

    public static synchronized CompositeCacheManager getInstance() throws CacheException {
        return CompositeCacheManager.getInstance("/cache.ccf");
    }

    public static synchronized CompositeCacheManager getInstance(String propsFilename) throws CacheException {
        if (instance == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Instance is null, creating with config [" + propsFilename + "]"));
            }
            instance = CompositeCacheManager.createInstance();
        }
        if (!instance.isInitialized()) {
            instance.initialize();
        }
        if (!instance.isConfigured()) {
            instance.configure(propsFilename);
        }
        CompositeCacheManager.instance.clients.incrementAndGet();
        return instance;
    }

    public static synchronized CompositeCacheManager getUnconfiguredInstance() {
        if (instance == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Instance is null, returning unconfigured instance");
            }
            instance = CompositeCacheManager.createInstance();
        }
        if (!instance.isInitialized()) {
            instance.initialize();
        }
        CompositeCacheManager.instance.clients.incrementAndGet();
        return instance;
    }

    protected static CompositeCacheManager createInstance() {
        return new CompositeCacheManager();
    }

    protected CompositeCacheManager() {
    }

    protected void initialize() {
        if (!this.isInitialized) {
            this.shutdownHook = new ShutdownHook();
            try {
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
            catch (AccessControlException e) {
                log.error((Object)"Could not register shutdown hook.", (Throwable)e);
            }
            this.scheduledExecutor = Executors.newScheduledThreadPool(4, new DaemonThreadFactory("JCS-Scheduler-", 1));
            if (!this.isJMXRegistered && this.jmxName != null) {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                JCSAdminBean adminBean = new JCSAdminBean(this);
                try {
                    ObjectName jmxObjectName = new ObjectName(this.jmxName);
                    mbs.registerMBean(adminBean, jmxObjectName);
                    this.isJMXRegistered = true;
                }
                catch (Exception e) {
                    log.warn((Object)"Could not register JMX bean.", (Throwable)e);
                }
            }
            this.elementEventQueue = new ElementEventQueue();
            this.isInitialized = true;
        }
    }

    public IElementEventQueue getElementEventQueue() {
        return this.elementEventQueue;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutor;
    }

    public void configure() throws CacheException {
        this.configure("/cache.ccf");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(String propFile) throws CacheException {
        log.info((Object)("Creating cache manager from config file: " + propFile));
        Properties props = new Properties();
        InputStream is = this.getClass().getResourceAsStream(propFile);
        if (is == null) throw new CacheException("Failed to read configuration file [" + propFile + "]");
        try {
            props.load(is);
            if (log.isDebugEnabled()) {
                log.debug((Object)("File [" + propFile + "] contained " + props.size() + " properties"));
            }
        }
        catch (IOException ex) {
            throw new CacheException("Failed to load properties for name [" + propFile + "]", ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignore) {}
        }
        this.configure(props);
    }

    public void configure(Properties props) {
        this.configure(props, true);
    }

    public void configure(Properties props, boolean useSystemProperties) {
        this.configure(props, useSystemProperties, false);
    }

    public synchronized void configure(Properties props, boolean useSystemProperties, boolean forceReconfiguration) {
        if (props == null) {
            log.error((Object)"No properties found.  Please configure the cache correctly.");
            return;
        }
        if (this.isConfigured) {
            if (!forceReconfiguration) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Configure called after the manager has been configured.  Force reconfiguration is false.  Doing nothing");
                }
                return;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"Configure called after the manager has been configured.  Force reconfiguration is true.  Reconfiguring as best we can.");
            }
        }
        if (useSystemProperties) {
            CompositeCacheConfigurator.overrideWithSystemProperties(props);
        }
        this.doConfigure(props);
    }

    private void doConfigure(Properties properties) {
        this.configurationProperties = properties;
        ThreadPoolManager.setProps(properties);
        ThreadPoolManager poolMgr = ThreadPoolManager.getInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)("ThreadPoolManager = " + poolMgr));
        }
        CompositeCacheConfigurator configurator = new CompositeCacheConfigurator();
        long start = System.currentTimeMillis();
        this.defaultAuxValues = OptionConverter.findAndSubst(DEFAULT_REGION, properties);
        log.info((Object)("Setting default auxiliaries to " + this.defaultAuxValues));
        this.defaultCacheAttr = configurator.parseCompositeCacheAttributes(properties, "", new CompositeCacheAttributes(), DEFAULT_REGION);
        log.info((Object)("setting defaultCompositeCacheAttributes to " + this.defaultCacheAttr));
        this.defaultElementAttr = configurator.parseElementAttributes(properties, "", new ElementAttributes(), DEFAULT_REGION);
        log.info((Object)("setting defaultElementAttributes to " + this.defaultElementAttr));
        configurator.parseSystemRegions(properties, this);
        configurator.parseRegions(properties, this);
        long end = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)("Finished configuration in " + (end - start) + " ms."));
        }
        this.isConfigured = true;
    }

    public ICompositeCacheAttributes getDefaultCacheAttributes() {
        return this.defaultCacheAttr.clone();
    }

    public IElementAttributes getDefaultElementAttributes() {
        return this.defaultElementAttr.clone();
    }

    @Override
    public <K, V> CompositeCache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, this.defaultCacheAttr.clone());
    }

    public <K, V> CompositeCache<K, V> getCache(String cacheName, ICompositeCacheAttributes cattr) {
        cattr.setCacheName(cacheName);
        return this.getCache(cattr, this.defaultElementAttr);
    }

    public <K, V> CompositeCache<K, V> getCache(String cacheName, ICompositeCacheAttributes cattr, IElementAttributes attr) {
        cattr.setCacheName(cacheName);
        return this.getCache(cattr, attr);
    }

    public <K, V> CompositeCache<K, V> getCache(ICompositeCacheAttributes cattr) {
        return this.getCache(cattr, this.defaultElementAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> CompositeCache<K, V> getCache(ICompositeCacheAttributes cattr, IElementAttributes attr) {
        CompositeCache cache;
        if (log.isDebugEnabled()) {
            log.debug((Object)("attr = " + attr));
        }
        if ((cache = (CompositeCache)this.caches.get(cattr.getCacheName())) == null) {
            this.cacheLock.lock();
            try {
                cache = (CompositeCache)this.caches.get(cattr.getCacheName());
                if (cache == null) {
                    cattr.setCacheName(cattr.getCacheName());
                    CompositeCacheConfigurator configurator = new CompositeCacheConfigurator();
                    cache = configurator.parseRegion(this.getConfigurationProperties(), this, cattr.getCacheName(), this.defaultAuxValues, cattr);
                    this.caches.put(cattr.getCacheName(), cache);
                }
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        return cache;
    }

    public void freeCache(String name) {
        this.freeCache(name, false);
    }

    public void freeCache(String name, boolean fromRemote) {
        CompositeCache cache = (CompositeCache)this.caches.remove(name);
        if (cache != null) {
            cache.dispose(fromRemote);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Class<CompositeCacheManager> clazz = CompositeCacheManager.class;
        synchronized (CompositeCacheManager.class) {
            this.elementEventQueue.dispose();
            this.scheduledExecutor.shutdownNow();
            ThreadPoolManager.dispose();
            LinkedHashSet<IShutdownObserver> linkedHashSet = this.shutdownObservers;
            synchronized (linkedHashSet) {
                for (IShutdownObserver observer : this.shutdownObservers) {
                    observer.shutdown();
                }
                this.shutdownObservers.clear();
            }
            if (this.isJMXRegistered) {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                try {
                    ObjectName jmxObjectName = new ObjectName(this.jmxName);
                    mbs.unregisterMBean(jmxObjectName);
                }
                catch (Exception e) {
                    log.warn((Object)"Could not unregister JMX bean.", (Throwable)e);
                }
                this.isJMXRegistered = false;
            }
            for (String name : this.getCacheNames()) {
                this.freeCache(name);
            }
            for (AuxiliaryCacheFactory factory : this.auxiliaryFactoryRegistry.values()) {
                factory.dispose();
            }
            this.auxiliaryAttributeRegistry.clear();
            this.auxiliaryFactoryRegistry.clear();
            if (this.shutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.shutdownHook = null;
            }
            this.isConfigured = false;
            this.isInitialized = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void release() {
        this.release(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(boolean fromRemote) {
        Class<CompositeCacheManager> clazz = CompositeCacheManager.class;
        synchronized (CompositeCacheManager.class) {
            if (this.clients.decrementAndGet() > 0 && log.isDebugEnabled()) {
                log.debug((Object)("Release called, but " + this.clients + " remain"));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Last client called release. There are " + this.caches.size() + " caches which will be disposed"));
            }
            for (ICache c : this.caches.values()) {
                CompositeCache cache = (CompositeCache)c;
                if (cache == null) continue;
                cache.dispose(fromRemote);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String[] getCacheNames() {
        return this.caches.keySet().toArray(new String[this.caches.size()]);
    }

    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.CACHE_HUB;
    }

    public void registryFacPut(AuxiliaryCacheFactory auxFac) {
        this.auxiliaryFactoryRegistry.put(auxFac.getName(), auxFac);
    }

    public AuxiliaryCacheFactory registryFacGet(String name) {
        return (AuxiliaryCacheFactory)this.auxiliaryFactoryRegistry.get(name);
    }

    public void registryAttrPut(AuxiliaryCacheAttributes auxAttr) {
        this.auxiliaryAttributeRegistry.put(auxAttr.getName(), auxAttr);
    }

    public AuxiliaryCacheAttributes registryAttrGet(String name) {
        return (AuxiliaryCacheAttributes)this.auxiliaryAttributeRegistry.get(name);
    }

    public void addCache(String cacheName, ICache<?, ?> cache) {
        this.caches.put(cacheName, cache);
    }

    public void addAuxiliaryCache(String auxName, String cacheName, AuxiliaryCache<?, ?> cache) {
        String key = String.format("aux.%s.region.%s", auxName, cacheName);
        this.auxiliaryCaches.put(key, cache);
    }

    @Override
    public <K, V> AuxiliaryCache<K, V> getAuxiliaryCache(String auxName, String cacheName) {
        String key = String.format("aux.%s.region.%s", auxName, cacheName);
        return (AuxiliaryCache)this.auxiliaryCaches.get(key);
    }

    @Override
    public String getStats() {
        ICacheStats[] stats = this.getStatistics();
        if (stats == null) {
            return "NONE";
        }
        StringBuilder buf = new StringBuilder();
        int statsLen = stats.length;
        for (int i = 0; i < statsLen; ++i) {
            buf.append("\n---------------------------\n");
            buf.append(stats[i]);
        }
        return buf.toString();
    }

    public ICacheStats[] getStatistics() {
        ArrayList<ICacheStats> cacheStats = new ArrayList<ICacheStats>();
        for (ICache c : this.caches.values()) {
            CompositeCache cache = (CompositeCache)c;
            if (cache == null) continue;
            cacheStats.add(cache.getStatistics());
        }
        ICacheStats[] stats = cacheStats.toArray(new CacheStats[0]);
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerShutdownObserver(IShutdownObserver observer) {
        LinkedHashSet<IShutdownObserver> linkedHashSet = this.shutdownObservers;
        synchronized (linkedHashSet) {
            this.shutdownObservers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterShutdownObserver(IShutdownObserver observer) {
        LinkedHashSet<IShutdownObserver> linkedHashSet = this.shutdownObservers;
        synchronized (linkedHashSet) {
            this.shutdownObservers.remove(observer);
        }
    }

    @Override
    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    public void setJmxName(String name) {
        if (this.isJMXRegistered) {
            throw new IllegalStateException("Too late, MBean registration is done");
        }
        this.jmxName = name;
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            if (CompositeCacheManager.this.isInitialized()) {
                log.info((Object)"Shutdown hook activated.  Shutdown was not called.  Shutting down JCS.");
                CompositeCacheManager.this.shutDown();
            }
        }
    }
}

