/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.util.ArrayList;
import org.apache.commons.jcs.engine.AbstractCacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheEventQueue<K, V>
extends AbstractCacheEventQueue<K, V> {
    private static final Log log = LogFactory.getLog(CacheEventQueue.class);
    private static final ICacheEventQueue.QueueType queueType = ICacheEventQueue.QueueType.SINGLE;
    private Thread processorThread;
    private final Object queueLock = new Object();
    private AbstractCacheEventQueue.Node head;
    private AbstractCacheEventQueue.Node tail = this.head = new AbstractCacheEventQueue.Node();
    private int size = 0;

    public CacheEventQueue(ICacheListener<K, V> listener, long listenerId, String cacheName) {
        this(listener, listenerId, cacheName, 10, 500);
    }

    public CacheEventQueue(ICacheListener<K, V> listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry) {
        this.initialize(listener, listenerId, cacheName, maxFailure, waitBeforeRetry, null);
    }

    @Override
    public void initialize(ICacheListener<K, V> listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry, String threadPoolName) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listener = listener;
        this.listenerId = listenerId;
        this.cacheName = cacheName;
        this.maxFailure = maxFailure <= 0 ? 3 : maxFailure;
        int n = this.waitBeforeRetry = waitBeforeRetry <= 0 ? 500 : waitBeforeRetry;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructed: " + this));
        }
    }

    @Override
    public ICacheEventQueue.QueueType getQueueType() {
        return queueType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopProcessing() {
        Object object = this.queueLock;
        synchronized (object) {
            this.destroyed = true;
            this.processorThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.queueLock;
        synchronized (object) {
            if (!this.destroyed) {
                this.destroyed = true;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Destroying queue, stats =  " + this.getStatistics()));
                }
                if (this.processorThread != null) {
                    this.processorThread.interrupt();
                    this.processorThread = null;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Cache event queue destroyed: " + this));
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)("Destroy was called after queue was destroyed.  Doing nothing.  Stats =  " + this.getStatistics()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void put(AbstractCacheEventQueue.AbstractCacheEvent event) {
        AbstractCacheEventQueue.Node newNode = new AbstractCacheEventQueue.Node();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event entering Queue for " + this.cacheName + ": " + event));
        }
        newNode.event = event;
        Object object = this.queueLock;
        synchronized (object) {
            ++this.size;
            this.tail.next = newNode;
            this.tail = newNode;
            if (this.isWorking()) {
                if (!this.isAlive()) {
                    this.destroyed = false;
                    this.processorThread = new QProcessor(this);
                    this.processorThread.start();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Cache event queue created: " + this));
                    }
                } else {
                    this.queueLock.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractCacheEventQueue.AbstractCacheEvent take() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.head == this.tail) {
                return null;
            }
            AbstractCacheEventQueue.Node node = this.head.next;
            AbstractCacheEventQueue.AbstractCacheEvent value = node.event;
            if (log.isDebugEnabled()) {
                log.debug((Object)("head.event = " + this.head.event));
                log.debug((Object)("node.event = " + node.event));
            }
            node.event = null;
            this.head = node;
            --this.size;
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Cache Event Queue");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<Boolean>("Working", super.isWorking()));
        elems.add(new StatElement<Boolean>("Alive", this.isAlive()));
        elems.add(new StatElement<Boolean>("Empty", this.isEmpty()));
        int sz = 0;
        Object object = this.queueLock;
        synchronized (object) {
            if (this.head == this.tail) {
                sz = 0;
            } else {
                AbstractCacheEventQueue.Node n = this.head;
                while (n != null) {
                    n = n.next;
                    ++sz;
                }
            }
            elems.add(new StatElement<Integer>("Size", sz));
        }
        stats.setStatElements(elems);
        return stats;
    }

    @Override
    public boolean isEmpty() {
        return this.tail == this.head;
    }

    @Override
    public int size() {
        return this.size;
    }

    private class QProcessor
    extends Thread {
        CacheEventQueue<K, V> queue;

        QProcessor(CacheEventQueue<K, V> aQueue) {
            super("CacheEventQueue.QProcessor-" + aQueue.cacheName);
            this.setDaemon(true);
            this.queue = aQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractCacheEventQueue.AbstractCacheEvent event = null;
            while (this.queue.isAlive()) {
                event = this.queue.take();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Event from queue = " + event));
                }
                if (event == null) {
                    Object object = CacheEventQueue.this.queueLock;
                    synchronized (object) {
                        try {
                            CacheEventQueue.this.queueLock.wait(this.queue.getWaitToDieMillis());
                        }
                        catch (InterruptedException e) {
                            log.warn((Object)"Interrupted while waiting for another event to come in before we die.");
                            return;
                        }
                        event = this.queue.take();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Event from queue after sleep = " + event));
                        }
                    }
                    if (event == null) {
                        this.queue.stopProcessing();
                    }
                }
                if (!this.queue.isWorking() || !this.queue.isAlive() || event == null) continue;
                event.run();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("QProcessor exiting for " + this.queue));
            }
        }
    }
}

