/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.struct;

import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.jcs.utils.struct.LRUMap;

public class LRUMapConcurrentTest
extends TestCase {
    private static int items = 20000;

    public LRUMapConcurrentTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(LRUMapConcurrentTest.class);
        final LRUMap map = new LRUMap(2000);
        suite.addTest((Test)new LRUMapConcurrentTest("conc1"){

            public void runTest() throws Exception {
                this.runConcurrentPutGetTests((LRUMap<String, String>)map, 2000);
            }
        });
        suite.addTest((Test)new LRUMapConcurrentTest("conc2"){

            public void runTest() throws Exception {
                this.runConcurrentPutGetTests((LRUMap<String, String>)map, 2000);
            }
        });
        suite.addTest((Test)new LRUMapConcurrentTest("conc3"){

            public void runTest() throws Exception {
                this.runConcurrentPutGetTests((LRUMap<String, String>)map, 2000);
            }
        });
        int max2 = 20000;
        final LRUMap map2 = new LRUMap(20000);
        suite.addTest((Test)new LRUMapConcurrentTest("concB1"){

            public void runTest() throws Exception {
                this.runConcurrentRangeTests((LRUMap<String, String>)map2, 10000, 20000);
            }
        });
        suite.addTest((Test)new LRUMapConcurrentTest("concB1"){

            public void runTest() throws Exception {
                this.runConcurrentRangeTests((LRUMap<String, String>)map2, 0, 9999);
            }
        });
        return suite;
    }

    public void testSimpleLoad() throws Exception {
        int i;
        LRUMap map = new LRUMap(items);
        for (i = 0; i < items; ++i) {
            map.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = items - 1; i >= 0; --i) {
            String res = (String)map.get((Object)(i + ":key"));
            LRUMapConcurrentTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
        map.remove((Object)"300:key");
        LRUMapConcurrentTest.assertNull((Object)map.get((Object)"300:key"));
    }

    public void testLRURemoval() throws Exception {
        int total = 10;
        LRUMap map = new LRUMap(total);
        map.setChunkSize(1);
        for (int i = 0; i < total; ++i) {
            map.put((Object)(i + ":key"), (Object)("data" + i));
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            LRUMapConcurrentTest.assertNotNull(it.next());
        }
        for (int i = total - 1; i >= 0; --i) {
            String res = (String)map.get((Object)(i + ":key"));
            LRUMapConcurrentTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
        map.put((Object)(total + ":key"), (Object)("data" + total));
        LRUMapConcurrentTest.assertNull((Object)map.get((Object)(total - 1 + ":key")));
    }

    public void testLRURemovalAgain() throws Exception {
        int i;
        int total = 10000;
        LRUMap map = new LRUMap(total);
        map.setChunkSize(1);
        for (i = 0; i < total * 2; ++i) {
            map.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = total - 1; i >= 0; --i) {
            LRUMapConcurrentTest.assertNull((Object)map.get((Object)(i + ":key")));
        }
        for (i = total * 2 - 1; i >= total; --i) {
            String res = (String)map.get((Object)(i + ":key"));
            LRUMapConcurrentTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
    }

    public void runConcurrentPutGetTests(LRUMap<String, String> map, int items) throws Exception {
        int i;
        for (i = 0; i < items; ++i) {
            map.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = items - 1; i >= 0; --i) {
            String res = (String)map.get((Object)(i + ":key"));
            LRUMapConcurrentTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
    }

    public void runConcurrentRangeTests(LRUMap<String, String> map, int start, int end) throws Exception {
        int i;
        for (i = start; i < end; ++i) {
            map.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = end - 1; i >= start; --i) {
            String res = (String)map.get((Object)(i + ":key"));
            LRUMapConcurrentTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
        map.remove((Object)(start + ":key"));
        LRUMapConcurrentTest.assertNull((Object)map.get((Object)(start + ":key")));
    }
}

