/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.struct;

import java.io.StringWriter;
import junit.framework.TestCase;
import org.apache.commons.jcs.TestLogConfigurationUtil;
import org.apache.commons.jcs.utils.struct.DoubleLinkedList;
import org.apache.commons.jcs.utils.struct.DoubleLinkedListNode;

public class DoubleLinkedListUnitTest
extends TestCase {
    public void testAddLast_Empty() {
        DoubleLinkedList list = new DoubleLinkedList();
        String payload1 = "payload1";
        DoubleLinkedListNode node1 = new DoubleLinkedListNode((Object)payload1);
        list.addLast(node1);
        DoubleLinkedListUnitTest.assertEquals((String)"Wrong last", (Object)node1, (Object)list.getLast());
    }

    public void testAddLast_NotEmpty() {
        DoubleLinkedList list = new DoubleLinkedList();
        String payload1 = "payload1";
        DoubleLinkedListNode node1 = new DoubleLinkedListNode((Object)payload1);
        String payload2 = "payload2";
        DoubleLinkedListNode node2 = new DoubleLinkedListNode((Object)payload2);
        list.addLast(node1);
        list.addLast(node2);
        DoubleLinkedListUnitTest.assertEquals((String)"Wrong last", (Object)node2, (Object)list.getLast());
    }

    public void testMakeLast_wasFirst() {
        DoubleLinkedList list = new DoubleLinkedList();
        String payload1 = "payload1";
        DoubleLinkedListNode node1 = new DoubleLinkedListNode((Object)payload1);
        String payload2 = "payload2";
        DoubleLinkedListNode node2 = new DoubleLinkedListNode((Object)payload2);
        list.addFirst(node2);
        list.addFirst(node1);
        list.makeLast(node1);
        DoubleLinkedListUnitTest.assertEquals((String)"Wrong size", (int)2, (int)list.size());
        DoubleLinkedListUnitTest.assertEquals((String)"Wrong last", (Object)node1, (Object)list.getLast());
        DoubleLinkedListUnitTest.assertEquals((String)"Wrong first", (Object)node2, (Object)list.getFirst());
    }

    public void testMakeLast_wasLast() {
        DoubleLinkedList list = new DoubleLinkedList();
        String payload1 = "payload1";
        DoubleLinkedListNode node1 = new DoubleLinkedListNode((Object)payload1);
        String payload2 = "payload2";
        DoubleLinkedListNode node2 = new DoubleLinkedListNode((Object)payload2);
        list.addFirst(node1);
        list.addFirst(node2);
        list.makeLast(node1);
        DoubleLinkedListUnitTest.assertEquals((String)"Wrong size", (int)2, (int)list.size());
        DoubleLinkedListUnitTest.assertEquals((String)"Wrong last", (Object)node1, (Object)list.getLast());
        DoubleLinkedListUnitTest.assertEquals((String)"Wrong first", (Object)node2, (Object)list.getFirst());
    }

    public void testMakeLast_wasAlone() {
        DoubleLinkedList list = new DoubleLinkedList();
        String payload1 = "payload1";
        DoubleLinkedListNode node1 = new DoubleLinkedListNode((Object)payload1);
        list.addFirst(node1);
        list.makeLast(node1);
        DoubleLinkedListUnitTest.assertEquals((String)"Wrong size", (int)1, (int)list.size());
        DoubleLinkedListUnitTest.assertEquals((String)"Wrong last", (Object)node1, (Object)list.getLast());
        DoubleLinkedListUnitTest.assertEquals((String)"Wrong first", (Object)node1, (Object)list.getFirst());
    }

    public void testMakeLast_wasInMiddle() {
        DoubleLinkedList list = new DoubleLinkedList();
        String payload1 = "payload1";
        DoubleLinkedListNode node1 = new DoubleLinkedListNode((Object)payload1);
        String payload2 = "payload2";
        DoubleLinkedListNode node2 = new DoubleLinkedListNode((Object)payload2);
        String payload3 = "payload3";
        DoubleLinkedListNode node3 = new DoubleLinkedListNode((Object)payload3);
        list.addFirst(node2);
        list.addFirst(node1);
        list.addFirst(node3);
        list.makeLast(node1);
        DoubleLinkedListUnitTest.assertEquals((String)"Wrong size", (int)3, (int)list.size());
        DoubleLinkedListUnitTest.assertEquals((String)"Wrong last", (Object)node1, (Object)list.getLast());
        DoubleLinkedListUnitTest.assertEquals((String)"Wrong first", (Object)node3, (Object)list.getFirst());
    }

    public void testDumpEntries_DebugTrue() {
        StringWriter stringWriter = new StringWriter();
        TestLogConfigurationUtil.configureLogger(stringWriter, DoubleLinkedList.class.getName());
        DoubleLinkedList list = new DoubleLinkedList();
        String payload1 = "payload1";
        DoubleLinkedListNode node1 = new DoubleLinkedListNode((Object)payload1);
        String payload2 = "payload2";
        DoubleLinkedListNode node2 = new DoubleLinkedListNode((Object)payload2);
        list.addLast(node1);
        list.addLast(node2);
        list.debugDumpEntries();
        String result = stringWriter.toString();
        DoubleLinkedListUnitTest.assertTrue((String)"Missing node in log dump", (result.indexOf(payload1) != -1 ? 1 : 0) != 0);
        DoubleLinkedListUnitTest.assertTrue((String)"Missing node in log dump", (result.indexOf(payload2) != -1 ? 1 : 0) != 0);
    }
}

