/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import junit.framework.TestCase;
import org.apache.commons.jcs.engine.CacheElement;
import org.apache.commons.jcs.engine.MockCacheServiceNonLocal;
import org.apache.commons.jcs.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICacheElement;

public class ZombieCacheServiceNonLocalUnitTest
extends TestCase {
    public void testUpdateThenWalk() throws Exception {
        MockCacheServiceNonLocal service = new MockCacheServiceNonLocal();
        ZombieCacheServiceNonLocal zombie = new ZombieCacheServiceNonLocal(10);
        String cacheName = "testUpdate";
        CacheElement element = new CacheElement(cacheName, (Object)"key", (Object)"value");
        zombie.update((ICacheElement)element, 123L);
        zombie.propagateEvents(service);
        ZombieCacheServiceNonLocalUnitTest.assertEquals((String)"Updated element is not as expected.", (Object)element, service.lastUpdate);
    }

    public void testUpdateThenWalk_zeroSize() throws Exception {
        MockCacheServiceNonLocal service = new MockCacheServiceNonLocal();
        ZombieCacheServiceNonLocal zombie = new ZombieCacheServiceNonLocal(0);
        String cacheName = "testUpdate";
        CacheElement element = new CacheElement(cacheName, (Object)"key", (Object)"value");
        zombie.update((ICacheElement)element, 123L);
        zombie.propagateEvents(service);
        ZombieCacheServiceNonLocalUnitTest.assertNull((String)"Nothing should have been put to the service.", service.lastUpdate);
    }

    public void testRemoveThenWalk() throws Exception {
        MockCacheServiceNonLocal service = new MockCacheServiceNonLocal();
        ZombieCacheServiceNonLocal zombie = new ZombieCacheServiceNonLocal(10);
        String cacheName = "testRemoveThenWalk";
        String key = "myKey";
        zombie.remove(cacheName, (Object)key, 123L);
        zombie.propagateEvents(service);
        ZombieCacheServiceNonLocalUnitTest.assertEquals((String)"Updated element is not as expected.", (String)key, (String)((String)service.lastRemoveKey));
    }

    public void testRemoveAllThenWalk() throws Exception {
        MockCacheServiceNonLocal service = new MockCacheServiceNonLocal();
        ZombieCacheServiceNonLocal zombie = new ZombieCacheServiceNonLocal(10);
        String cacheName = "testRemoveThenWalk";
        zombie.removeAll(cacheName, 123L);
        zombie.propagateEvents(service);
        ZombieCacheServiceNonLocalUnitTest.assertEquals((String)"Updated element is not as expected.", (String)cacheName, (String)service.lastRemoveAllCacheName);
    }
}

