/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral.socket.tcp;

import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.LateralTCPService;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.TCPLateralCacheAttributes;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs.engine.CacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheElement;

public class LateralTCPConcurrentRandomTestUtil
extends TestCase {
    private static boolean isSysOut = false;

    public LateralTCPConcurrentRandomTestUtil(String testName) {
        super(testName);
    }

    public void setUp() {
        JCS.setConfigFilename((String)"/TestTCPLateralCacheConcurrent.ccf");
    }

    public void runTestForRegion(String region, int range, int numOps, int testNum) throws Exception {
        boolean show = true;
        CacheAccess cache = JCS.getInstance((String)region);
        TCPLateralCacheAttributes lattr2 = new TCPLateralCacheAttributes();
        lattr2.setTcpListenerPort(1103);
        lattr2.setTransmissionTypeName("TCP");
        lattr2.setTcpServer("localhost:1102");
        LateralTCPService service = new LateralTCPService((ITCPLateralCacheAttributes)lattr2);
        service.setListenerId(123456L);
        try {
            for (int i = 1; i < numOps; ++i) {
                Random ran = new Random(i);
                int n = ran.nextInt(4);
                int kn = ran.nextInt(range);
                String key = "key" + kn;
                if (n == 1) {
                    CacheElement element = new CacheElement(region, (Object)key, (Object)(region + ":data" + i + " junk asdfffffffadfasdfasf " + kn + ":" + n));
                    service.update((ICacheElement)element);
                    if (show) {
                        LateralTCPConcurrentRandomTestUtil.p("put " + key);
                    }
                } else if (n == 2) {
                    service.remove(region, (Object)key);
                    if (show) {
                        LateralTCPConcurrentRandomTestUtil.p("removed " + key);
                    }
                } else {
                    try {
                        ICacheElement obj = service.get(region, (Object)key);
                        if (show && obj != null) {
                            LateralTCPConcurrentRandomTestUtil.p(obj.toString());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (i % 100 != 0) continue;
                LateralTCPConcurrentRandomTestUtil.p(cache.getStats());
            }
            LateralTCPConcurrentRandomTestUtil.p("Finished random cycle of " + numOps);
        }
        catch (Exception e) {
            LateralTCPConcurrentRandomTestUtil.p(e.toString());
            e.printStackTrace(System.out);
            throw e;
        }
        CacheAccess jcs = JCS.getInstance((String)region);
        String key = "testKey" + testNum;
        String data = "testData" + testNum;
        jcs.put((Object)key, (Object)data);
        String value = (String)jcs.get((Object)key);
        LateralTCPConcurrentRandomTestUtil.assertEquals((String)"Couldn't put normally.", (String)data, (String)value);
        for (int i = 1; i < numOps; ++i) {
            String keyL = "key" + i;
            String dataL = (String)jcs.get((Object)keyL);
            if (dataL == null) continue;
            LateralTCPConcurrentRandomTestUtil.assertTrue((String)"Incorrect region detected.", (boolean)dataL.startsWith(region));
        }
    }

    public static void p(String s) {
        if (isSysOut) {
            System.out.println(s);
        }
    }
}

