/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.indexed;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.jcs.auxiliary.MockCacheEventLogger;
import org.apache.commons.jcs.auxiliary.disk.DiskTestObject;
import org.apache.commons.jcs.auxiliary.disk.indexed.DiskTestObjectUtil;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCache;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskElementDescriptor;
import org.apache.commons.jcs.engine.CacheElement;
import org.apache.commons.jcs.engine.ElementAttributes;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.control.group.GroupId;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.utils.timing.SleepUtil;

public abstract class IndexDiskCacheUnitTestAbstract
extends TestCase {
    public abstract IndexedDiskCacheAttributes getCacheAttributes();

    public void testSimplePutAndGet() throws IOException {
        int i;
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testSimplePutAndGet");
        cattr.setMaxKeySize(1000);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        disk.processRemoveAll();
        int cnt = 999;
        for (i = 0; i < cnt; ++i) {
            ElementAttributes eAttr = new ElementAttributes();
            eAttr.setIsSpool(true);
            CacheElement element = new CacheElement("testSimplePutAndGet", (Object)("key:" + i), (Object)("data:" + i));
            element.setElementAttributes((IElementAttributes)eAttr);
            disk.processUpdate((ICacheElement)element);
        }
        for (i = 0; i < cnt; ++i) {
            ICacheElement element = disk.processGet((Object)("key:" + i));
            IndexDiskCacheUnitTestAbstract.assertNotNull((String)"Should have received an element.", (Object)element);
            IndexDiskCacheUnitTestAbstract.assertEquals((String)"Element is wrong.", (String)("data:" + i), (String)((String)element.getVal()));
        }
        HashSet<String> keys = new HashSet<String>();
        for (int i2 = 0; i2 < cnt; ++i2) {
            keys.add("key:" + i2);
        }
        Map elements = disk.getMultiple(keys);
        for (int i3 = 0; i3 < cnt; ++i3) {
            ICacheElement element = (ICacheElement)elements.get("key:" + i3);
            IndexDiskCacheUnitTestAbstract.assertNotNull((String)("element " + i3 + ":key is missing"), (Object)element);
            IndexDiskCacheUnitTestAbstract.assertEquals((String)("value key:" + i3), (String)("data:" + i3), (String)((String)element.getVal()));
        }
    }

    public void testRemoveItems() throws IOException {
        int i;
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRemoveItems");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        disk.processRemoveAll();
        int cnt = 25;
        for (i = 0; i < cnt; ++i) {
            ElementAttributes eAttr = new ElementAttributes();
            eAttr.setIsSpool(true);
            CacheElement element = new CacheElement("testRemoveItems", (Object)("key:" + i), (Object)("data:" + i));
            element.setElementAttributes((IElementAttributes)eAttr);
            disk.processUpdate((ICacheElement)element);
        }
        for (i = 0; i < cnt; ++i) {
            disk.remove((Object)("key:" + i));
            ICacheElement element = disk.processGet((Object)("key:" + i));
            IndexDiskCacheUnitTestAbstract.assertNull((String)"Should not have received an element.", (Object)element);
        }
    }

    public void testCheckForDedOverlaps_noOverlap() {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testCheckForDedOverlaps_noOverlap");
        cattr.setDiskPath("target/test-sandbox/UnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        int numDescriptors = 5;
        int pos = 0;
        IndexedDiskElementDescriptor[] sortedDescriptors = new IndexedDiskElementDescriptor[numDescriptors];
        for (int i = 0; i < numDescriptors; ++i) {
            IndexedDiskElementDescriptor descriptor = new IndexedDiskElementDescriptor((long)pos, i * 2);
            pos = pos + i * 2 + 4;
            sortedDescriptors[i] = descriptor;
        }
        boolean result = disk.checkForDedOverlaps(sortedDescriptors);
        IndexDiskCacheUnitTestAbstract.assertTrue((String)"There should be no overlap. it should be ok", (boolean)result);
    }

    public void testCheckForDedOverlaps_overlaps() {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testCheckForDedOverlaps_overlaps");
        cattr.setDiskPath("target/test-sandbox/UnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        int numDescriptors = 5;
        int pos = 0;
        IndexedDiskElementDescriptor[] sortedDescriptors = new IndexedDiskElementDescriptor[numDescriptors];
        for (int i = 0; i < numDescriptors; ++i) {
            IndexedDiskElementDescriptor descriptor = new IndexedDiskElementDescriptor((long)pos, i * 2);
            pos += i * 2;
            sortedDescriptors[i] = descriptor;
        }
        boolean result = disk.checkForDedOverlaps(sortedDescriptors);
        IndexDiskCacheUnitTestAbstract.assertFalse((String)"There should be overlaps. it should be not ok", (boolean)result);
    }

    public void testFileSize() throws IOException, InterruptedException {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testFileSize");
        cattr.setDiskPath("target/test-sandbox/UnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        int numberToInsert = 20;
        int bytes = 24;
        ICacheElement<Integer, DiskTestObject>[] elements = DiskTestObjectUtil.createCacheElementsWithTestObjects(numberToInsert, bytes, cattr.getCacheName());
        for (int i = 0; i < elements.length; ++i) {
            disk.processUpdate(elements[i]);
        }
        Thread.yield();
        Thread.sleep(100L);
        Thread.yield();
        long expectedSize = DiskTestObjectUtil.totalSize(elements, numberToInsert);
        long resultSize = disk.getDataFileSize();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Wrong file size", (long)expectedSize, (long)resultSize);
    }

    public void testRecyleBinSize() throws IOException, InterruptedException {
        int numberToInsert = 20;
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRecyleBinSize");
        cattr.setDiskPath("target/test-sandbox/UnitTest");
        cattr.setOptimizeAtRemoveCount(numberToInsert);
        cattr.setMaxKeySize(numberToInsert * 2);
        cattr.setMaxPurgatorySize(numberToInsert);
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        int bytes = 1;
        ICacheElement<Integer, DiskTestObject>[] elements = DiskTestObjectUtil.createCacheElementsWithTestObjects(numberToInsert, bytes, cattr.getCacheName());
        for (int i = 0; i < elements.length; ++i) {
            disk.processUpdate(elements[i]);
        }
        Thread.yield();
        Thread.sleep(100L);
        Thread.yield();
        int numberToRemove = elements.length / 2;
        for (int i = 0; i < numberToRemove; ++i) {
            disk.processRemove(elements[i].getKey());
        }
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"The recycle bin should have the number removed.", (int)numberToRemove, (int)disk.getRecyleBinSize());
    }

    public void testRecyleBinUsage() throws IOException, InterruptedException {
        int numberToInsert = 20;
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRecyleBinUsage");
        cattr.setDiskPath("target/test-sandbox/UnitTest");
        cattr.setOptimizeAtRemoveCount(numberToInsert);
        cattr.setMaxKeySize(numberToInsert * 2);
        cattr.setMaxPurgatorySize(numberToInsert);
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        int bytes = 1;
        ICacheElement<Integer, DiskTestObject>[] elements = DiskTestObjectUtil.createCacheElementsWithTestObjects(numberToInsert, bytes, cattr.getCacheName());
        for (int i = 0; i < elements.length; ++i) {
            disk.processUpdate(elements[i]);
        }
        Thread.yield();
        Thread.sleep(100L);
        Thread.yield();
        int numberToRemove = elements.length / 2;
        for (int i = 0; i < numberToRemove; ++i) {
            disk.processRemove(elements[i].getKey());
        }
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"The recycle bin should have the number removed.", (int)numberToRemove, (int)disk.getRecyleBinSize());
        int numberToAdd = numberToRemove / 2;
        for (int i = 0; i < numberToAdd; ++i) {
            disk.processUpdate(elements[i]);
        }
        IndexDiskCacheUnitTestAbstract.assertEquals((String)("The recycle bin should have the number removed." + disk.getStats()), (int)numberToAdd, (int)disk.getRecyleCount());
    }

    public void testBytesFreeSize() throws IOException, InterruptedException {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testBytesFreeSize");
        cattr.setDiskPath("target/test-sandbox/UnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        int numberToInsert = 20;
        int bytes = 24;
        ICacheElement<Integer, DiskTestObject>[] elements = DiskTestObjectUtil.createCacheElementsWithTestObjects(numberToInsert, bytes, cattr.getCacheName());
        for (int i = 0; i < elements.length; ++i) {
            disk.processUpdate(elements[i]);
        }
        Thread.yield();
        Thread.sleep(100L);
        Thread.yield();
        int numberToRemove = elements.length / 2;
        for (int i = 0; i < numberToRemove; ++i) {
            disk.processRemove(elements[i].getKey());
        }
        long expectedSize = DiskTestObjectUtil.totalSize(elements, numberToRemove);
        long resultSize = disk.getBytesFree();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)("Wrong bytes free size" + disk.getStats()), (long)expectedSize, (long)resultSize);
        int numberToAdd = numberToRemove / 2;
        for (int i = 0; i < numberToAdd; ++i) {
            disk.processUpdate(elements[i]);
        }
        long expectedSize2 = DiskTestObjectUtil.totalSize(elements, numberToAdd);
        long resultSize2 = disk.getBytesFree();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)("Wrong bytes free size" + disk.getStats()), (long)expectedSize2, (long)resultSize2);
    }

    public void testRemove_PartialKey() throws IOException {
        ICacheElement element;
        int i;
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRemove_PartialKey");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        disk.processRemoveAll();
        int cnt = 25;
        for (i = 0; i < cnt; ++i) {
            ElementAttributes eAttr = new ElementAttributes();
            eAttr.setIsSpool(true);
            CacheElement element2 = new CacheElement("testRemove_PartialKey", (Object)(i + ":key"), (Object)("data:" + i));
            element2.setElementAttributes((IElementAttributes)eAttr);
            disk.processUpdate((ICacheElement)element2);
        }
        for (i = 0; i < cnt; ++i) {
            element = disk.processGet((Object)(i + ":key"));
            IndexDiskCacheUnitTestAbstract.assertNotNull((String)"Shoulds have received an element.", (Object)element);
        }
        for (i = 0; i < cnt; ++i) {
            disk.remove((Object)(i + ":"));
            element = disk.processGet((Object)(i + ":key"));
            IndexDiskCacheUnitTestAbstract.assertNull((String)"Should not have received an element.", (Object)element);
        }
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Recylenbin should not have more elements than we removed. Check for JCS-67", (int)cnt, (int)disk.getRecyleBinSize());
    }

    public void testRemove_Group() throws IOException {
        ICacheElement element;
        GroupAttrName<String> groupAttrName;
        int i;
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRemove_Group");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        disk.processRemoveAll();
        String cacheName = "testRemove_Group_Region";
        String groupName = "testRemove_Group";
        int cnt = 25;
        for (i = 0; i < cnt; ++i) {
            groupAttrName = this.getGroupAttrName(cacheName, groupName, i + ":key");
            element = new CacheElement(cacheName, groupAttrName, (Object)("data:" + i));
            ElementAttributes eAttr = new ElementAttributes();
            eAttr.setIsSpool(true);
            element.setElementAttributes((IElementAttributes)eAttr);
            disk.processUpdate(element);
        }
        for (i = 0; i < cnt; ++i) {
            groupAttrName = this.getGroupAttrName(cacheName, groupName, i + ":key");
            element = disk.processGet(groupAttrName);
            IndexDiskCacheUnitTestAbstract.assertNotNull((String)"Should have received an element.", (Object)element);
        }
        disk.remove(this.getGroupAttrName(cacheName, groupName, null));
        for (i = 0; i < cnt; ++i) {
            groupAttrName = this.getGroupAttrName(cacheName, groupName, i + ":key");
            element = disk.processGet(groupAttrName);
            IndexDiskCacheUnitTestAbstract.assertNull((String)"Should not have received an element.", (Object)element);
        }
    }

    private GroupAttrName<String> getGroupAttrName(String cacheName, String group, String name) {
        GroupId gid = new GroupId(cacheName, group);
        return new GroupAttrName(gid, (Object)name);
    }

    public void testUpdate_EventLogging_simple() throws Exception {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testUpdate_EventLogging_simple");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTestCEL");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        diskCache.processRemoveAll();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        diskCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        CacheElement item = new CacheElement("region", (Object)"key", (Object)"value");
        diskCache.update((ICacheElement)item);
        SleepUtil.sleepAtLeast(200L);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testGet_EventLogging_simple() throws Exception {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testGet_EventLogging_simple");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTestCEL");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        diskCache.processRemoveAll();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        diskCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        diskCache.get((Object)"key");
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testGetMultiple_EventLogging_simple() throws Exception {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testGetMultiple_EventLogging_simple");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTestCEL");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        diskCache.processRemoveAll();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        diskCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        HashSet<String> keys = new HashSet<String>();
        keys.add("junk");
        diskCache.getMultiple(keys);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Start should have been called.", (int)2, (int)cacheEventLogger.startICacheEventCalls);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"End should have been called.", (int)2, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testRemove_EventLogging_simple() throws Exception {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRemoveAll_EventLogging_simple");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTestCEL");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        diskCache.processRemoveAll();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        diskCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        diskCache.remove((Object)"key");
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testRemoveAll_EventLogging_simple() throws Exception {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRemoveAll_EventLogging_simple");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTestCEL");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        diskCache.processRemoveAll();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        diskCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        diskCache.remove((Object)"key");
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testPutGetMatching_SmallWait() throws Exception {
        int items = 200;
        String cacheName = "testPutGetMatching_SmallWait";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        for (int i = 0; i <= items; ++i) {
            diskCache.update((ICacheElement)new CacheElement(cacheName, (Object)(i + ":key"), (Object)(cacheName + " data " + i)));
        }
        Thread.sleep(500L);
        Map matchingResults = diskCache.getMatching("1.8.+");
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Wrong number returned", (int)10, (int)matchingResults.size());
    }

    public void testPutGetMatching_NoWait() throws Exception {
        int items = 200;
        String cacheName = "testPutGetMatching_NoWait";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        for (int i = 0; i <= items; ++i) {
            diskCache.update((ICacheElement)new CacheElement(cacheName, (Object)(i + ":key"), (Object)(cacheName + " data " + i)));
        }
        Map matchingResults = diskCache.getMatching("1.8.+");
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Wrong number returned", (int)10, (int)matchingResults.size());
    }

    public void testUTF8String() throws Exception {
        String string = "I\u00d2t\u00cern\u201ati\u00d9n\u2021liz\u00cati\u00afn";
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        for (int i = 0; i < 4; ++i) {
            sb.append(sb.toString());
        }
        string = sb.toString();
        String cacheName = "testUTF8String";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        diskCache.update((ICacheElement)new CacheElement(cacheName, (Object)"x", (Object)string));
        IndexDiskCacheUnitTestAbstract.assertNotNull((Object)diskCache.get((Object)"x"));
        Thread.sleep(1000L);
        ICacheElement afterElement = diskCache.get((Object)"x");
        IndexDiskCacheUnitTestAbstract.assertNotNull((Object)afterElement);
        String after = (String)afterElement.getVal();
        IndexDiskCacheUnitTestAbstract.assertNotNull((Object)after);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"wrong string after retrieval", (String)string, (String)after);
    }

    public void testUTF8ByteArray() throws Exception {
        String string = "I\u00d2t\u00cern\u201ati\u00d9n\u2021liz\u00cati\u00afn";
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        for (int i = 0; i < 4; ++i) {
            sb.append(sb.toString());
        }
        string = sb.toString();
        String UTF8 = "UTF-8";
        byte[] bytes = string.getBytes(UTF8);
        String cacheName = "testUTF8ByteArray";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        diskCache.update((ICacheElement)new CacheElement(cacheName, (Object)"x", (Object)bytes));
        IndexDiskCacheUnitTestAbstract.assertNotNull((Object)diskCache.get((Object)"x"));
        Thread.sleep(1000L);
        ICacheElement afterElement = diskCache.get((Object)"x");
        IndexDiskCacheUnitTestAbstract.assertNotNull((Object)afterElement);
        byte[] after = (byte[])afterElement.getVal();
        IndexDiskCacheUnitTestAbstract.assertNotNull((Object)after);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"wrong bytes after retrieval", (String)string, (String)new String(after, UTF8));
    }

    public void testProcessUpdate_Simple() throws IOException {
        String cacheName = "testProcessUpdate_Simple";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        String key = "myKey";
        String value = "myValue";
        CacheElement ce = new CacheElement(cacheName, (Object)key, (Object)value);
        diskCache.processUpdate((ICacheElement)ce);
        ICacheElement result = diskCache.processGet((Object)key);
        IndexDiskCacheUnitTestAbstract.assertNotNull((String)"Should have a result", (Object)result);
        long fileSize = diskCache.getDataFileSize();
        IndexDiskCacheUnitTestAbstract.assertTrue((String)"File should be greater than 0", (fileSize > 0L ? 1 : 0) != 0);
    }

    public void testProcessUpdate_SameKeySameSize() throws IOException {
        String cacheName = "testProcessUpdate_SameKeySameSize";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        String key = "myKey";
        String value = "myValue";
        CacheElement ce1 = new CacheElement(cacheName, (Object)key, (Object)value);
        diskCache.processUpdate((ICacheElement)ce1);
        long fileSize1 = diskCache.getDataFileSize();
        CacheElement ce2 = new CacheElement(cacheName, (Object)key, (Object)value);
        diskCache.processUpdate((ICacheElement)ce2);
        ICacheElement result = diskCache.processGet((Object)key);
        IndexDiskCacheUnitTestAbstract.assertNotNull((String)"Should have a result", (Object)result);
        long fileSize2 = diskCache.getDataFileSize();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"File should be the same", (long)fileSize1, (long)fileSize2);
        int binSize = diskCache.getRecyleBinSize();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Should be nothing in the bin.", (int)0, (int)binSize);
    }

    public void testProcessUpdate_SameKeySmallerSize() throws IOException {
        String cacheName = "testProcessUpdate_SameKeySmallerSize";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        String key = "myKey";
        String value = "myValue";
        String value2 = "myValu";
        CacheElement ce1 = new CacheElement(cacheName, (Object)key, (Object)value);
        diskCache.processUpdate((ICacheElement)ce1);
        long fileSize1 = diskCache.getDataFileSize();
        CacheElement ce2 = new CacheElement(cacheName, (Object)key, (Object)value2);
        diskCache.processUpdate((ICacheElement)ce2);
        ICacheElement result = diskCache.processGet((Object)key);
        IndexDiskCacheUnitTestAbstract.assertNotNull((String)"Should have a result", (Object)result);
        long fileSize2 = diskCache.getDataFileSize();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"File should be the same", (long)fileSize1, (long)fileSize2);
        int binSize = diskCache.getRecyleBinSize();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Should be nothing in the bin.", (int)0, (int)binSize);
    }

    public void testProcessUpdate_SameKeyBiggerSize() throws IOException {
        String cacheName = "testProcessUpdate_SameKeyBiggerSize";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        String key = "myKey";
        String value = "myValue";
        String value2 = "myValue2";
        CacheElement ce1 = new CacheElement(cacheName, (Object)key, (Object)value);
        diskCache.processUpdate((ICacheElement)ce1);
        long fileSize1 = diskCache.getDataFileSize();
        CacheElement ce2 = new CacheElement(cacheName, (Object)key, (Object)value2);
        diskCache.processUpdate((ICacheElement)ce2);
        ICacheElement result = diskCache.processGet((Object)key);
        IndexDiskCacheUnitTestAbstract.assertNotNull((String)"Should have a result", (Object)result);
        long fileSize2 = diskCache.getDataFileSize();
        IndexDiskCacheUnitTestAbstract.assertTrue((String)"File should be greater.", (fileSize1 < fileSize2 ? 1 : 0) != 0);
        int binSize = diskCache.getRecyleBinSize();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Should be one in the bin.", (int)1, (int)binSize);
    }

    public void testLoadFromDisk() throws Exception {
        for (int i = 0; i < 15; ++i) {
            this.oneLoadFromDisk();
        }
    }

    public void oneLoadFromDisk() throws Exception {
        int i;
        String string = "I\u00d2t\u00cern\u201ati\u00d9n\u2021liz\u00cati\u00afn";
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        for (int i2 = 0; i2 < 4; ++i2) {
            sb.append(sb.toString());
        }
        string = sb.toString();
        String cacheName = "testLoadFromDisk";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/BlockDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        for (i = 0; i < 50; ++i) {
            diskCache.update((ICacheElement)new CacheElement(cacheName, (Object)("x" + i), (Object)string));
        }
        diskCache.dispose();
        diskCache = new IndexedDiskCache(cattr);
        for (i = 0; i < 50; ++i) {
            ICacheElement afterElement = diskCache.get((Object)("x" + i));
            IndexDiskCacheUnitTestAbstract.assertNotNull((String)("Missing element from cache. Cache size: " + diskCache.getSize() + " element: x" + i), (Object)afterElement);
            IndexDiskCacheUnitTestAbstract.assertEquals((String)"wrong string after retrieval", (String)string, (String)((String)afterElement.getVal()));
        }
    }
}

