/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.block;

import junit.framework.TestCase;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskElementDescriptor;

public class BlockDiskElementDescriptorUnitTest
extends TestCase {
    public void testMemorySize() throws Exception {
        long memoryBefore = this.measureMemoryUse();
        int numElements = 25000;
        BlockDiskElementDescriptor[] elements = new BlockDiskElementDescriptor[numElements];
        long memoryStart = this.measureMemoryUse();
        for (int i = 0; i < numElements; ++i) {
            BlockDiskElementDescriptor descriptor = new BlockDiskElementDescriptor();
            descriptor.setKey((Object)i);
            descriptor.setBlocks(new int[]{1, 2});
            elements[i] = descriptor;
        }
        long memoryEnd = this.measureMemoryUse();
        long diff = memoryEnd - memoryStart;
        long perDiff = diff / (long)numElements;
        BlockDiskElementDescriptorUnitTest.assertTrue((String)("Too much was used: " + perDiff + " >= 75"), (perDiff < 75L ? 1 : 0) != 0);
    }

    protected long measureMemoryUse() throws InterruptedException {
        System.gc();
        Thread.sleep(3000L);
        System.gc();
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }
}

