/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.block;

import java.text.DecimalFormat;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.auxiliary.disk.DiskTestObject;

public class BlockDiskCacheSteadyLoadTest
extends TestCase {
    private static final String LOG_DIVIDER = "---------------------------";
    private static Runtime rt = Runtime.getRuntime();
    private static DecimalFormat format = new DecimalFormat("#,###");

    public void testRunSteadyLoadTest() throws Exception {
        JCS.setConfigFilename((String)"/TestBlockDiskCacheSteadyLoad.ccf");
        BlockDiskCacheSteadyLoadTest.logMemoryUsage();
        int numPerRun = 250;
        long pauseBetweenRuns = 1000L;
        int runCount = 0;
        int runs = 1000;
        int upperKB = 50;
        CacheAccess jcs = JCS.getInstance((String)(numPerRun / 2 + "aSecond"));
        int numToGet = numPerRun * (runs / 10);
        for (int i = 0; i < numToGet; ++i) {
            jcs.get((Object)String.valueOf(i));
        }
        BlockDiskCacheSteadyLoadTest.logMemoryUsage();
        jcs.clear();
        Thread.sleep(3000L);
        int totalPut = 0;
        Random random = new Random(89L);
        while (runCount < runs) {
            int j;
            ++runCount;
            for (int i = 0; i < numPerRun; ++i) {
                int kiloBytes = Math.max(upperKB / 2, random.nextInt(upperKB));
                int bytes = kiloBytes * 1024;
                DiskTestObject object = new DiskTestObject(i, new byte[bytes]);
                jcs.put((Object)String.valueOf(++totalPut), (Object)object);
            }
            if (runCount > 1) {
                for (j = totalPut - numPerRun - numPerRun / 2; j < totalPut - numPerRun; ++j) {
                    jcs.get((Object)String.valueOf(j));
                }
            }
            if (runCount > 1) {
                for (j = totalPut - numPerRun - numPerRun / 2; j < totalPut - numPerRun; ++j) {
                    jcs.remove((Object)String.valueOf(j));
                }
            }
            Thread.sleep(pauseBetweenRuns);
            if (runCount % 100 != 0) continue;
            BlockDiskCacheSteadyLoadTest.logMemoryUsage();
        }
        Thread.sleep(3000L);
        BlockDiskCacheSteadyLoadTest.logMemoryUsage();
        Thread.sleep(10000L);
        BlockDiskCacheSteadyLoadTest.logMemoryUsage();
        System.gc();
        Thread.sleep(3000L);
        System.gc();
        BlockDiskCacheSteadyLoadTest.logMemoryUsage();
    }

    private static void logMemoryUsage() {
        long byte2MB = 0x100000L;
        long total = rt.totalMemory() / byte2MB;
        long free = rt.freeMemory() / byte2MB;
        long used = total - free;
        System.out.println(LOG_DIVIDER);
        System.out.println("Memory: Used:" + format.format(used) + "MB" + " Free:" + format.format(free) + "MB" + " Total:" + format.format(total) + "MB");
    }
}

