/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.admin;

import junit.framework.TestCase;
import org.apache.commons.jcs.admin.CountingOnlyOutputStream;

public class CountingStreamUnitTest
extends TestCase {
    public void testSingleByte() throws Exception {
        CountingOnlyOutputStream out = new CountingOnlyOutputStream();
        out.write(1);
        CountingStreamUnitTest.assertEquals((String)"Wrong number of bytes written.", (int)1, (int)out.getCount());
        out.write(1);
        CountingStreamUnitTest.assertEquals((String)"Wrong number of bytes written.", (int)2, (int)out.getCount());
        out.close();
    }

    public void testByteArray() throws Exception {
        CountingOnlyOutputStream out = new CountingOnlyOutputStream();
        byte[] array = new byte[]{1, 2, 3, 4, 5};
        out.write(array);
        CountingStreamUnitTest.assertEquals((String)"Wrong number of bytes written.", (int)array.length, (int)out.getCount());
        out.close();
    }

    public void testByteArrayLenCount() throws Exception {
        CountingOnlyOutputStream out = new CountingOnlyOutputStream();
        byte[] array = new byte[]{1, 2, 3, 4, 5};
        int len = 3;
        out.write(array, 0, len);
        CountingStreamUnitTest.assertEquals((String)"Wrong number of bytes written.", (int)len, (int)out.getCount());
        out.close();
    }
}

