/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.access;

import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.access.exception.ObjectExistsException;
import org.apache.commons.jcs.engine.CompositeCacheAttributes;
import org.apache.commons.jcs.engine.ElementAttributes;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;

public class CacheAccessUnitTest
extends TestCase {
    public void testPutSafe() throws Exception {
        CacheAccess access = JCS.getInstance((String)"test");
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        String key = "mykey";
        String value = "myvalue";
        access.put((Object)key, (Object)value);
        String returnedValue1 = (String)access.get((Object)key);
        CacheAccessUnitTest.assertEquals((String)"Wrong value returned.", (String)value, (String)returnedValue1);
        try {
            access.putSafe((Object)key, (Object)"someothervalue");
            CacheAccessUnitTest.fail((String)"We should have received an exception since this key is already in the cache.");
        }
        catch (CacheException e) {
            CacheAccessUnitTest.assertTrue((String)"Wrong type of exception.", (boolean)(e instanceof ObjectExistsException));
            CacheAccessUnitTest.assertTrue((String)"Should have the key in the error message.", (e.getMessage().indexOf("[" + key + "]") != -1 ? 1 : 0) != 0);
        }
        String returnedValue2 = (String)access.get((Object)key);
        CacheAccessUnitTest.assertEquals((String)"Wrong value returned.  Should still be the original.", (String)value, (String)returnedValue2);
    }

    public void testPutNullKey() throws Exception {
        CacheAccess access = JCS.getInstance((String)"test");
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        Object key = null;
        String value = "myvalue";
        try {
            access.put(key, (Object)value);
            CacheAccessUnitTest.fail((String)"Should not have been able to put a null key.");
        }
        catch (CacheException e) {
            CacheAccessUnitTest.assertTrue((String)"Should have the word null in the error message.", (e.getMessage().indexOf("null") != -1 ? 1 : 0) != 0);
        }
    }

    public void testPutNullValue() throws Exception {
        CacheAccess access = JCS.getInstance((String)"test");
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        String key = "myKey";
        Object value = null;
        try {
            access.put((Object)key, value);
            CacheAccessUnitTest.fail((String)"Should not have been able to put a null object.");
        }
        catch (CacheException e) {
            CacheAccessUnitTest.assertTrue((String)"Should have the word null in the error message.", (e.getMessage().indexOf("null") != -1 ? 1 : 0) != 0);
        }
    }

    public void testSetDefaultElementAttributes() throws Exception {
        CacheAccess access = JCS.getInstance((String)"test");
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        long maxLife = 9876L;
        ElementAttributes attr = new ElementAttributes();
        attr.setMaxLife(maxLife);
        access.setDefaultElementAttributes((IElementAttributes)attr);
        CacheAccessUnitTest.assertEquals((String)"Wrong element attributes.", (long)attr.getMaxLife(), (long)access.getDefaultElementAttributes().getMaxLife());
        String key = "mykey";
        String value = "myvalue";
        access.put((Object)key, (Object)value);
        ICacheElement element = access.getCacheElement((Object)key);
        CacheAccessUnitTest.assertEquals((String)"Wrong max life.  Should have the new value.", (long)maxLife, (long)element.getElementAttributes().getMaxLife());
    }

    public void testGetCacheElements() throws Exception {
        CacheAccess access = JCS.getInstance((String)"test");
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        String keyOne = "mykeyone";
        String keyTwo = "mykeytwo";
        String keyThree = "mykeythree";
        String valueOne = "myvalueone";
        String valueTwo = "myvaluetwo";
        String valueThree = "myvaluethree";
        access.put((Object)keyOne, (Object)valueOne);
        access.put((Object)keyTwo, (Object)valueTwo);
        access.put((Object)keyThree, (Object)valueThree);
        HashSet<String> input = new HashSet<String>();
        input.add(keyOne);
        input.add(keyTwo);
        Map result = access.getCacheElements(input);
        CacheAccessUnitTest.assertEquals((String)"map size", (int)2, (int)result.size());
        ICacheElement elementOne = (ICacheElement)result.get(keyOne);
        CacheAccessUnitTest.assertEquals((String)"value one", (String)keyOne, (String)((String)elementOne.getKey()));
        CacheAccessUnitTest.assertEquals((String)"value one", (String)valueOne, (String)((String)elementOne.getVal()));
        ICacheElement elementTwo = (ICacheElement)result.get(keyTwo);
        CacheAccessUnitTest.assertEquals((String)"value two", (String)keyTwo, (String)((String)elementTwo.getKey()));
        CacheAccessUnitTest.assertEquals((String)"value two", (String)valueTwo, (String)((String)elementTwo.getVal()));
    }

    public void testRegionDefiniton() throws Exception {
        CacheAccess access = JCS.defineRegion((String)"test");
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
    }

    public void testRegionDefinitonWithAttributes() throws Exception {
        CompositeCacheAttributes ca = new CompositeCacheAttributes();
        long maxIdleTime = 8765L;
        ca.setMaxMemoryIdleTimeSeconds(maxIdleTime);
        CacheAccess access = JCS.defineRegion((String)"testRegionDefinitonWithAttributes", (ICompositeCacheAttributes)ca);
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        ICompositeCacheAttributes ca2 = access.getCacheAttributes();
        CacheAccessUnitTest.assertEquals((String)"Wrong idle time setting.", (long)ca.getMaxMemoryIdleTimeSeconds(), (long)ca2.getMaxMemoryIdleTimeSeconds());
    }

    public void testRegionDefinitonWithBothAttributes() throws Exception {
        CompositeCacheAttributes ca = new CompositeCacheAttributes();
        long maxIdleTime = 8765L;
        ca.setMaxMemoryIdleTimeSeconds(maxIdleTime);
        long maxLife = 9876L;
        ElementAttributes attr = new ElementAttributes();
        attr.setMaxLife(maxLife);
        CacheAccess access = JCS.defineRegion((String)"testRegionDefinitonWithAttributes", (ICompositeCacheAttributes)ca, (IElementAttributes)attr);
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        ICompositeCacheAttributes ca2 = access.getCacheAttributes();
        CacheAccessUnitTest.assertEquals((String)"Wrong idle time setting.", (long)ca.getMaxMemoryIdleTimeSeconds(), (long)ca2.getMaxMemoryIdleTimeSeconds());
    }

    public void testGetMatching_Normal() throws Exception {
        int maxMemorySize = 1000;
        String keyprefix1 = "MyPrefix1";
        String keyprefix2 = "MyPrefix2";
        String memoryCacheClassName = "org.apache.commons.jcs.engine.memory.lru.LRUMemoryCache";
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setMemoryCacheName(memoryCacheClassName);
        cattr.setMaxObjects(maxMemorySize);
        long maxLife = 9876L;
        ElementAttributes attr = new ElementAttributes();
        attr.setMaxLife(maxLife);
        CacheAccess access = JCS.defineRegion((String)"testGetMatching_Normal", (ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        int numToInsertPrefix1 = 10;
        for (int i = 0; i < numToInsertPrefix1; ++i) {
            access.put((Object)(keyprefix1 + String.valueOf(i)), (Object)i);
        }
        int numToInsertPrefix2 = 50;
        for (int i = 0; i < numToInsertPrefix2; ++i) {
            access.put((Object)(keyprefix2 + String.valueOf(i)), (Object)i);
        }
        Map result1 = access.getMatching(keyprefix1 + ".+");
        Map result2 = access.getMatching(keyprefix2 + "\\S+");
        CacheAccessUnitTest.assertEquals((String)"Wrong number returned 1:", (int)numToInsertPrefix1, (int)result1.size());
        CacheAccessUnitTest.assertEquals((String)"Wrong number returned 2:", (int)numToInsertPrefix2, (int)result2.size());
        for (Map.Entry entry : result1.entrySet()) {
            Object value = entry.getValue();
            CacheAccessUnitTest.assertFalse((String)"Should not be a cache element.", (boolean)(value instanceof ICacheElement));
        }
    }

    public void testGetMatchingElements_Normal() throws Exception {
        int maxMemorySize = 1000;
        String keyprefix1 = "MyPrefix1";
        String keyprefix2 = "MyPrefix2";
        String memoryCacheClassName = "org.apache.commons.jcs.engine.memory.lru.LRUMemoryCache";
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setMemoryCacheName(memoryCacheClassName);
        cattr.setMaxObjects(maxMemorySize);
        long maxLife = 9876L;
        ElementAttributes attr = new ElementAttributes();
        attr.setMaxLife(maxLife);
        CacheAccess access = JCS.defineRegion((String)"testGetMatching_Normal", (ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        int numToInsertPrefix1 = 10;
        for (int i = 0; i < numToInsertPrefix1; ++i) {
            access.put((Object)(keyprefix1 + String.valueOf(i)), (Object)i);
        }
        int numToInsertPrefix2 = 50;
        for (int i = 0; i < numToInsertPrefix2; ++i) {
            access.put((Object)(keyprefix2 + String.valueOf(i)), (Object)i);
        }
        Map result1 = access.getMatchingCacheElements(keyprefix1 + "\\S+");
        Map result2 = access.getMatchingCacheElements(keyprefix2 + ".+");
        CacheAccessUnitTest.assertEquals((String)"Wrong number returned 1:", (int)numToInsertPrefix1, (int)result1.size());
        CacheAccessUnitTest.assertEquals((String)"Wrong number returned 2:", (int)numToInsertPrefix2, (int)result2.size());
        for (Map.Entry entry : result1.entrySet()) {
            Object value = entry.getValue();
            CacheAccessUnitTest.assertTrue((String)"Should be a cache element.", (boolean)(value instanceof ICacheElement));
        }
    }
}

