/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs;

import junit.framework.TestCase;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;

public class RemovalTestUtil
extends TestCase {
    public RemovalTestUtil(String testName) {
        super(testName);
    }

    public void runTestPutThenRemoveCategorical(int start, int end) throws Exception {
        int i;
        CacheAccess jcs = JCS.getInstance((String)"testCache1");
        for (i = start; i <= end; ++i) {
            jcs.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = end; i >= start; --i) {
            String res = (String)jcs.get((Object)(i + ":key"));
            RemovalTestUtil.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
        for (i = start; i <= end; ++i) {
            jcs.remove((Object)(i + ":"));
            RemovalTestUtil.assertNull((Object)jcs.get((Object)(i + ":key")));
        }
    }

    public void runPutInRange(int start, int end) throws Exception {
        int i;
        CacheAccess jcs = JCS.getInstance((String)"testCache1");
        for (i = start; i <= end; ++i) {
            jcs.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = end; i >= start; --i) {
            String res = (String)jcs.get((Object)(i + ":key"));
            RemovalTestUtil.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
    }

    public void runGetInRange(int start, int end, boolean check) throws Exception {
        CacheAccess jcs = JCS.getInstance((String)"testCache1");
        for (int i = end; i >= start; --i) {
            String res = (String)jcs.get((Object)(i + ":key"));
            if (!check) continue;
            RemovalTestUtil.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
    }
}

