/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.engine.stats.behavior.IStatElement;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCSThrashTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)JCSThrashTest.class.getName());
    protected CacheAccess<String, Serializable> jcs;

    public static void main(String[] args) {
        TestRunner.run(JCSThrashTest.class);
    }

    public JCSThrashTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        JCS.setConfigFilename((String)"/TestThrash.ccf");
        this.jcs = JCS.getInstance((String)"testcache");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.jcs.clear();
        this.jcs.dispose();
    }

    public void testPut() throws Exception {
        String value = "value";
        String key = "key";
        JCSThrashTest.assertEquals((int)0, (int)this.getListSize());
        JCSThrashTest.assertNull((Object)this.jcs.get((Object)"key"));
        this.jcs.put((Object)"key", (Object)"value");
        LOG.info((Object)("jcs.getStats(): " + this.jcs.getStatistics()));
        JCSThrashTest.assertEquals((int)1, (int)this.getListSize());
        JCSThrashTest.assertNotNull((Object)this.jcs.get((Object)"key"));
        JCSThrashTest.assertEquals((Object)"value", (Object)this.jcs.get((Object)"key"));
    }

    public void testRemove() throws Exception {
        this.jcs.put((Object)"key1", (Object)"value1");
        JCSThrashTest.assertEquals((int)1, (int)this.getListSize());
        this.jcs.remove((Object)"key1");
        JCSThrashTest.assertEquals((int)0, (int)this.getListSize());
        this.jcs.put((Object)"key2", (Object)"value2");
        this.jcs.put((Object)"key3", (Object)"value3");
        JCSThrashTest.assertEquals((int)2, (int)this.getListSize());
        this.jcs.remove((Object)"key2");
        JCSThrashTest.assertEquals((int)1, (int)this.getListSize());
        this.jcs.remove((Object)"key4");
        JCSThrashTest.assertEquals((int)1, (int)this.getListSize());
    }

    public void testForMemoryLeaks() throws Exception {
        long differenceMemoryCache = this.thrashCache();
        LOG.info((Object)("Memory Difference is: " + differenceMemoryCache));
        JCSThrashTest.assertTrue((differenceMemoryCache < 500000L ? 1 : 0) != 0);
    }

    protected long thrashCache() throws Exception {
        Executable executable;
        int i;
        long startingSize = this.measureMemoryUse();
        LOG.info((Object)("Memory Used is: " + startingSize));
        String value = "value";
        String key = "key";
        this.jcs.put((Object)"key", (Object)"value");
        ArrayList<Executable> executables = new ArrayList<Executable>();
        for (i = 0; i < 15; ++i) {
            executable = new Executable(){

                @Override
                public void execute() throws Exception {
                    for (int j = 0; j < 500; ++j) {
                        String keyj = "key" + j;
                        JCSThrashTest.this.jcs.get((Object)keyj);
                    }
                    JCSThrashTest.this.jcs.get((Object)"key");
                }
            };
            executables.add(executable);
        }
        for (i = 0; i < 15; ++i) {
            executable = new Executable(){

                @Override
                public void execute() throws Exception {
                    for (int j = 0; j < 500; ++j) {
                        String keyj = "key" + j;
                        byte[] valuej = new byte[10000];
                        JCSThrashTest.this.jcs.put((Object)keyj, (Object)valuej);
                    }
                }
            };
            executables.add(executable);
        }
        this.runThreads(executables);
        this.jcs.clear();
        long finishingSize = this.measureMemoryUse();
        LOG.info((Object)("Memory Used is: " + finishingSize));
        return finishingSize - startingSize;
    }

    protected void runThreads(List<Executable> executables) throws Exception {
        int i;
        final long endTime = System.currentTimeMillis() + 10000L;
        final Throwable[] errors = new Throwable[1];
        Thread[] threads = new Thread[executables.size()];
        for (i = 0; i < threads.length; ++i) {
            final Executable executable = executables.get(i);
            threads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        while (System.currentTimeMillis() < endTime) {
                            executable.execute();
                        }
                    }
                    catch (Throwable t) {
                        errors[0] = t;
                    }
                }
            };
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        if (errors[0] != null) {
            throw new Exception("Test thread failed.", errors[0]);
        }
    }

    protected long measureMemoryUse() throws InterruptedException {
        System.gc();
        Thread.sleep(3000L);
        System.gc();
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    private int getListSize() {
        String listSize = "List Size";
        String lruMemoryCache = "LRU Memory Cache";
        String result = "0";
        List istats = this.jcs.getStatistics().getAuxiliaryCacheStats();
        block0: for (IStats istat : istats) {
            List statElements = istat.getStatElements();
            if (!"LRU Memory Cache".equals(istat.getTypeName())) continue;
            for (IStatElement statElement : statElements) {
                if (!"List Size".equals(statElement.getName())) continue;
                result = statElement.getData().toString();
                continue block0;
            }
        }
        return Integer.parseInt(result);
    }

    protected static interface Executable {
        public void execute() throws Exception;
    }
}

