/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.reloading;

import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.apache.commons.configuration2.reloading.ReloadingDetector;
import org.apache.commons.configuration2.reloading.ReloadingEvent;
import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestReloadingController {
    private ReloadingDetector detector;

    private static EventListener<ReloadingEvent> createListenerMock() {
        return (EventListener)Mockito.mock(EventListener.class);
    }

    private ReloadingController createController() {
        return new ReloadingController(this.detector);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.detector = (ReloadingDetector)Mockito.mock(ReloadingDetector.class);
    }

    private void setupEvent(EventListener<ReloadingEvent> l, MutableObject<ReloadingEvent> evRef) {
        ((EventListener)Mockito.doAnswer(invocation -> {
            evRef.setValue((Object)((ReloadingEvent)invocation.getArgument(0, ReloadingEvent.class)));
            return null;
        }).when(l)).onEvent((Event)((ReloadingEvent)ArgumentMatchers.any()));
    }

    @Test
    public void testCheckForReloadingFalse() {
        EventListener<ReloadingEvent> l = TestReloadingController.createListenerMock();
        Mockito.when((Object)this.detector.isReloadingRequired()).thenReturn((Object)Boolean.FALSE);
        ReloadingController ctrl = this.createController();
        ctrl.addEventListener(ReloadingEvent.ANY, l);
        Assertions.assertFalse((boolean)ctrl.checkForReloading(null));
        Assertions.assertFalse((boolean)ctrl.isInReloadingState());
        ((ReloadingDetector)Mockito.verify((Object)this.detector)).isReloadingRequired();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.detector, l});
    }

    @Test
    public void testCheckForReloadingInReloadingState() {
        EventListener<ReloadingEvent> l = TestReloadingController.createListenerMock();
        Mockito.when((Object)this.detector.isReloadingRequired()).thenReturn((Object)Boolean.TRUE);
        ReloadingController ctrl = this.createController();
        ctrl.addEventListener(ReloadingEvent.ANY, l);
        Assertions.assertTrue((boolean)ctrl.checkForReloading((Object)1));
        Assertions.assertTrue((boolean)ctrl.checkForReloading((Object)2));
        ((ReloadingDetector)Mockito.verify((Object)this.detector)).isReloadingRequired();
        this.verifyEvent(l);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.detector, l});
    }

    @Test
    public void testCheckForReloadingTrue() {
        EventListener<ReloadingEvent> l = TestReloadingController.createListenerMock();
        EventListener<ReloadingEvent> lRemoved = TestReloadingController.createListenerMock();
        MutableObject evRef = new MutableObject();
        this.setupEvent(l, (MutableObject<ReloadingEvent>)evRef);
        Mockito.when((Object)this.detector.isReloadingRequired()).thenReturn((Object)Boolean.TRUE);
        ReloadingController ctrl = this.createController();
        ctrl.addEventListener(ReloadingEvent.ANY, lRemoved);
        ctrl.addEventListener(ReloadingEvent.ANY, l);
        Assertions.assertTrue((boolean)ctrl.removeEventListener(ReloadingEvent.ANY, lRemoved));
        String testData = "Some test data";
        Assertions.assertTrue((boolean)ctrl.checkForReloading((Object)testData));
        Assertions.assertTrue((boolean)ctrl.isInReloadingState());
        Assertions.assertSame((Object)ctrl, (Object)((ReloadingEvent)evRef.getValue()).getSource());
        Assertions.assertSame((Object)ctrl, (Object)((ReloadingEvent)evRef.getValue()).getController());
        Assertions.assertEquals((Object)testData, (Object)((ReloadingEvent)evRef.getValue()).getData());
        this.verifyEvent(l);
        ((ReloadingDetector)Mockito.verify((Object)this.detector)).isReloadingRequired();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{l, lRemoved, this.detector});
    }

    @Test
    public void testInitNoDetector() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ReloadingController(null));
    }

    @Test
    public void testReloadingEventType() {
        Assertions.assertEquals((Object)Event.ANY, (Object)ReloadingEvent.ANY.getSuperType());
    }

    @Test
    public void testReloadingStateAfterInit() {
        Assertions.assertFalse((boolean)this.createController().isInReloadingState());
    }

    @Test
    public void testResetReloadingNotInReloadingState() {
        this.createController().resetReloadingState();
    }

    @Test
    public void testResetReloadingState() {
        Mockito.when((Object)this.detector.isReloadingRequired()).thenReturn((Object)Boolean.TRUE);
        ReloadingController ctrl = this.createController();
        ctrl.checkForReloading(null);
        ctrl.resetReloadingState();
        Assertions.assertFalse((boolean)ctrl.isInReloadingState());
        ((ReloadingDetector)Mockito.verify((Object)this.detector)).isReloadingRequired();
        ((ReloadingDetector)Mockito.verify((Object)this.detector)).reloadingPerformed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.detector});
    }

    private void verifyEvent(EventListener<ReloadingEvent> l) {
        ((EventListener)Mockito.verify(l)).onEvent((Event)((ReloadingEvent)ArgumentMatchers.any()));
    }
}

