/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.event;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration2.event.ConfigurationErrorEvent;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConfigurationEventTypes {
    private void checkErrorEvent(EventType<ConfigurationErrorEvent> type) {
        Assertions.assertSame((Object)ConfigurationErrorEvent.ANY, (Object)type.getSuperType(), (String)("Wrong super type for " + type));
    }

    private void checkHierarchicalEvent(EventType<ConfigurationEvent> eventType) {
        Assertions.assertSame((Object)ConfigurationEvent.ANY_HIERARCHICAL, (Object)eventType.getSuperType(), (String)("Wrong super type for " + eventType));
    }

    private void checkUpdateEvent(EventType<ConfigurationEvent> eventType) {
        Assertions.assertSame((Object)ConfigurationEvent.ANY, (Object)eventType.getSuperType(), (String)("Wrong super type for " + eventType));
    }

    @Test
    public void testAddNodesEventType() {
        this.checkHierarchicalEvent((EventType<ConfigurationEvent>)ConfigurationEvent.ADD_NODES);
    }

    @Test
    public void testAddPropertyEventType() {
        this.checkUpdateEvent((EventType<ConfigurationEvent>)ConfigurationEvent.ADD_PROPERTY);
    }

    @Test
    public void testBaseErrorEventType() {
        Assertions.assertEquals((Object)Event.ANY, (Object)ConfigurationErrorEvent.ANY.getSuperType());
    }

    @Test
    public void testClearEventType() {
        this.checkUpdateEvent((EventType<ConfigurationEvent>)ConfigurationEvent.CLEAR);
    }

    @Test
    public void testClearPropertyEventType() {
        this.checkUpdateEvent((EventType<ConfigurationEvent>)ConfigurationEvent.CLEAR_PROPERTY);
    }

    @Test
    public void testClearTreeEventType() {
        this.checkHierarchicalEvent((EventType<ConfigurationEvent>)ConfigurationEvent.CLEAR_TREE);
    }

    @Test
    public void testConfigurationEventType() {
        Assertions.assertSame((Object)Event.ANY, (Object)ConfigurationEvent.ANY.getSuperType());
    }

    @Test
    public void testFetchSuperEventTypesForBaseType() {
        Set superTypes = EventType.fetchSuperEventTypes((EventType)Event.ANY);
        Assertions.assertEquals(Collections.singleton(Event.ANY), (Object)superTypes);
    }

    @Test
    public void testFetchSuperEventTypesNull() {
        Set superTypes = EventType.fetchSuperEventTypes(null);
        Assertions.assertTrue((boolean)superTypes.isEmpty());
    }

    @Test
    public void testFetchSuperEventTypesOfType() {
        Set superTypes = EventType.fetchSuperEventTypes((EventType)ConfigurationEvent.ADD_NODES);
        HashSet<EventType> expected = new HashSet<EventType>();
        expected.add(ConfigurationEvent.ADD_NODES);
        expected.add(ConfigurationEvent.ANY_HIERARCHICAL);
        expected.add(ConfigurationEvent.ANY);
        expected.add(Event.ANY);
        Assertions.assertEquals(expected, (Object)superTypes);
    }

    @Test
    public void testHierarchicalEventType() {
        this.checkUpdateEvent((EventType<ConfigurationEvent>)ConfigurationEvent.ANY_HIERARCHICAL);
    }

    @Test
    public void testIsInstanceOfBaseNull() {
        Assertions.assertFalse((boolean)EventType.isInstanceOf((EventType)ConfigurationEvent.ANY, null));
    }

    @Test
    public void testIsInstanceOfDerivedNull() {
        Assertions.assertFalse((boolean)EventType.isInstanceOf(null, (EventType)Event.ANY));
    }

    @Test
    public void testIsInstanceOfFalse() {
        Assertions.assertFalse((boolean)EventType.isInstanceOf((EventType)ConfigurationErrorEvent.READ, (EventType)ConfigurationEvent.ANY));
    }

    @Test
    public void testIsInstanceOfTrue() {
        Assertions.assertTrue((boolean)EventType.isInstanceOf((EventType)ConfigurationEvent.ADD_NODES, (EventType)ConfigurationEvent.ANY_HIERARCHICAL));
        Assertions.assertTrue((boolean)EventType.isInstanceOf((EventType)ConfigurationEvent.ADD_NODES, (EventType)ConfigurationEvent.ANY));
        Assertions.assertTrue((boolean)EventType.isInstanceOf((EventType)ConfigurationEvent.ADD_NODES, (EventType)Event.ANY));
        Assertions.assertTrue((boolean)EventType.isInstanceOf((EventType)ConfigurationEvent.ADD_NODES, (EventType)ConfigurationEvent.ADD_NODES));
    }

    @Test
    public void testReadErrorEventType() {
        this.checkErrorEvent((EventType<ConfigurationErrorEvent>)ConfigurationErrorEvent.READ);
    }

    @Test
    public void testSetPropertyEventType() {
        this.checkUpdateEvent((EventType<ConfigurationEvent>)ConfigurationEvent.SET_PROPERTY);
    }

    @Test
    public void testSubnodeChangedEventType() {
        this.checkHierarchicalEvent((EventType<ConfigurationEvent>)ConfigurationEvent.SUBNODE_CHANGED);
    }

    @Test
    public void testWriteErrorEventType() {
        this.checkErrorEvent((EventType<ConfigurationErrorEvent>)ConfigurationErrorEvent.WRITE);
    }
}

