/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.JSONConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestJSONConfiguration {
    private final String testJson = ConfigurationAssert.getTestFile("test.json").getAbsolutePath();
    private JSONConfiguration jsonConfiguration;

    @BeforeEach
    public void setUp() throws Exception {
        this.jsonConfiguration = new JSONConfiguration();
        this.jsonConfiguration.read((Reader)new FileReader(this.testJson));
    }

    @Test
    public void testCopyConstructor() {
        BaseHierarchicalConfiguration c = new BaseHierarchicalConfiguration();
        c.addProperty("foo", (Object)"bar");
        this.jsonConfiguration = new JSONConfiguration((HierarchicalConfiguration)c);
        Assertions.assertEquals((Object)"bar", (Object)this.jsonConfiguration.getString("foo"));
    }

    public void testGetListNestedWithList() {
        Assertions.assertEquals(Arrays.asList("col1", "col2"), (Object)this.jsonConfiguration.getList(String.class, "key4.key5"));
    }

    @Test
    public void testGetPropertyDictionary() {
        Assertions.assertEquals((Object)"Martin D'vloper", (Object)this.jsonConfiguration.getProperty("martin.name"));
        Assertions.assertEquals((Object)"Developer", (Object)this.jsonConfiguration.getProperty("martin.job"));
        Assertions.assertEquals((Object)"Elite", (Object)this.jsonConfiguration.getProperty("martin.skill"));
    }

    @Test
    public void testGetPropertyDictionaryInList() {
        Assertions.assertEquals((Object)"UK", (Object)this.jsonConfiguration.getString("capitals(1).country"));
        Assertions.assertEquals((Object)"Washington", (Object)this.jsonConfiguration.getString("capitals(0).capital"));
    }

    @Test
    public void testGetPropertyInteger() {
        Object property = this.jsonConfiguration.getProperty("int1");
        Assertions.assertInstanceOf(Integer.class, (Object)property);
        Assertions.assertEquals((Object)37, (Object)property);
    }

    @Test
    public void testGetPropertyNested() {
        Assertions.assertEquals((Object)"value23", (Object)this.jsonConfiguration.getProperty("key2.key3"));
    }

    @Test
    public void testGetPropertyNestedWithList() {
        Assertions.assertEquals(Arrays.asList("col1", "col2"), (Object)this.jsonConfiguration.getProperty("key4.key5"));
    }

    @Test
    public void testGetPropertySimple() {
        Assertions.assertEquals((Object)"value1", (Object)this.jsonConfiguration.getProperty("key1"));
    }

    @Test
    public void testGetPropertySubset() {
        Configuration subset = this.jsonConfiguration.subset("key4");
        Assertions.assertEquals(Arrays.asList("col1", "col2"), (Object)subset.getProperty("key5"));
    }

    @Test
    public void testGetPropertyVeryNestedProperties() {
        Object property = this.jsonConfiguration.getProperty("very.nested.properties");
        Assertions.assertEquals(Arrays.asList("nested1", "nested2", "nested3"), (Object)property);
    }

    @Disabled
    @Test
    public void testListOfObjects() {
        Configuration subset = this.jsonConfiguration.subset("capitals");
        Assertions.assertNotNull((Object)subset);
        Assertions.assertEquals((int)2, (int)subset.size());
        List list = this.jsonConfiguration.getList("capitals");
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)2, (int)list.size());
    }

    @Test
    public void testSave() throws IOException, ConfigurationException {
        StringWriter sw = new StringWriter();
        this.jsonConfiguration.write((Writer)sw);
        String output = sw.toString();
        ObjectMapper mapper = new ObjectMapper();
        MapType type = mapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
        Map parsed = (Map)mapper.readValue(output, (JavaType)type);
        Assertions.assertEquals((int)7, (int)parsed.entrySet().size());
        Assertions.assertEquals((Object)"value1", parsed.get("key1"));
        Map key2 = (Map)parsed.get("key2");
        Assertions.assertEquals((Object)"value23", key2.get("key3"));
        List key5 = (List)((Map)parsed.get("key4")).get("key5");
        Assertions.assertEquals(Arrays.asList("col1", "col2"), (Object)key5);
        List capitals = (List)parsed.get("capitals");
        Map capUk = (Map)capitals.get(1);
        Assertions.assertEquals((Object)"London", capUk.get("capital"));
    }
}

