/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.Collections;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.commons.configuration2.sync.NoOpSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestAbstractConfigurationSynchronization {
    private static final String PROP = "configuration.loaded";
    private SynchronizerTestImpl sync;
    private AbstractConfiguration config;

    private static Configuration prepareConfigurationMockForCopy() {
        Configuration config2 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)config2.getKeys()).thenReturn(Collections.emptySet().iterator());
        return config2;
    }

    private static void verifyConfigurationMockAfterCopy(Configuration mock) {
        ((Configuration)Mockito.verify((Object)mock)).lock(LockMode.READ);
        ((Configuration)Mockito.verify((Object)mock)).getKeys();
        ((Configuration)Mockito.verify((Object)mock)).unlock(LockMode.READ);
    }

    @BeforeEach
    public void setUp() throws Exception {
        PropertiesConfiguration c = new PropertiesConfiguration();
        new FileHandler((FileBased)c).load(ConfigurationAssert.getTestFile("test.properties"));
        this.sync = new SynchronizerTestImpl();
        c.setSynchronizer((Synchronizer)this.sync);
        this.config = c;
    }

    @Test
    public void testAddPropertySynchronized() {
        this.config.addProperty(PROP, (Object)"of course");
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testAppendSynchronized() {
        Configuration config2 = TestAbstractConfigurationSynchronization.prepareConfigurationMockForCopy();
        this.config.append(config2);
        TestAbstractConfigurationSynchronization.verifyConfigurationMockAfterCopy(config2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{config2});
    }

    @Test
    public void testClearPropertySynchronized() {
        this.config.clearProperty(PROP);
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testClearSynchronized() {
        this.config.clear();
        this.sync.verifyStart(SynchronizerTestImpl.Methods.BEGIN_WRITE);
        this.sync.verifyEnd(SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testContainsKeySychronized() {
        Assertions.assertTrue((boolean)this.config.containsKey(PROP));
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testCopySynchronized() {
        Configuration config2 = TestAbstractConfigurationSynchronization.prepareConfigurationMockForCopy();
        this.config.copy(config2);
        TestAbstractConfigurationSynchronization.verifyConfigurationMockAfterCopy(config2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{config2});
    }

    @Test
    public void testDefaultSynchronizer() {
        Assertions.assertSame((Object)NoOpSynchronizer.INSTANCE, (Object)new PropertiesConfiguration().getSynchronizer());
    }

    @Test
    public void testGetKeysPrefixSynchronized() {
        this.config.getKeys("test");
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testGetKeysSynchronized() {
        Assertions.assertTrue((boolean)this.config.getKeys().hasNext());
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testGetPropertySynchronized() {
        Assertions.assertEquals((Object)"true", (Object)this.config.getProperty(PROP));
        Assertions.assertTrue((boolean)this.config.getBoolean(PROP));
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ, SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testIsEmptySynchronized() {
        Assertions.assertFalse((boolean)this.config.isEmpty());
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testLockNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.config.lock(null));
    }

    @Test
    public void testLockRead() {
        this.config.lock(LockMode.READ);
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ);
    }

    @Test
    public void testLockWrite() {
        this.config.lock(LockMode.WRITE);
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE);
    }

    @Test
    public void testSetPropertySynchronized() {
        this.config.setProperty(PROP, (Object)"yes");
        this.sync.verifyStart(SynchronizerTestImpl.Methods.BEGIN_WRITE);
        this.sync.verifyEnd(SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testSizeSynchronized() {
        Assertions.assertFalse((boolean)this.config.isEmpty());
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testSubsetSynchronized() {
        AbstractConfiguration subset = (AbstractConfiguration)this.config.subset("configuration");
        this.sync.verify(new SynchronizerTestImpl.Methods[0]);
        Assertions.assertEquals((Object)NoOpSynchronizer.INSTANCE, (Object)subset.getSynchronizer());
    }

    @Test
    public void testUnlockRead() {
        this.config.unlock(LockMode.READ);
        this.sync.verify(SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testUnlockWrite() {
        this.config.unlock(LockMode.WRITE);
        this.sync.verify(SynchronizerTestImpl.Methods.END_WRITE);
    }
}

