/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import com.github.marschall.memoryfilesystem.MemoryFileSystemBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TarMemoryFileSystemTest {
    TarMemoryFileSystemTest() {
    }

    @Test
    void testCheckUserInformationInTarEntry() throws IOException, ArchiveException {
        String user = "commons";
        String group = "compress";
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().addUser("commons").addGroup("compress").build();){
            Path pathSource = fileSystem.getPath("original-file.txt", new String[0]);
            Files.write(pathSource, "Test".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Files.setAttribute(pathSource, "posix:owner", () -> "commons", new LinkOption[0]);
            Files.setAttribute(pathSource, "posix:group", () -> "compress", new LinkOption[0]);
            Path target = fileSystem.getPath("original-file.tar", new String[0]);
            try (OutputStream out = Files.newOutputStream(target, new OpenOption[0]);
                 ArchiveOutputStream tarOut = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", out);){
                TarArchiveEntry entry = new TarArchiveEntry(pathSource);
                tarOut.putArchiveEntry((ArchiveEntry)entry);
                tarOut.write(pathSource);
                tarOut.closeArchiveEntry();
            }
            try (InputStream input = Files.newInputStream(target, new OpenOption[0]);
                 TarArchiveInputStream tarIn = new TarArchiveInputStream(input);){
                TarArchiveEntry nextTarEntry = tarIn.getNextTarEntry();
                Assertions.assertEquals((Object)"commons", (Object)nextTarEntry.getUserName());
                Assertions.assertEquals((Object)"compress", (Object)nextTarEntry.getGroupName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testTarFromMemoryFileSystem() throws IOException, ArchiveException {
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path p = fileSystem.getPath("test.txt", new String[0]);
            Files.write(p, "Test".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            File f = File.createTempFile("commons-compress-memoryfs", ".tar");
            try (OutputStream out = Files.newOutputStream(f.toPath(), new OpenOption[0]);
                 ArchiveOutputStream tarOut = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", out);){
                TarArchiveEntry entry = new TarArchiveEntry(p);
                tarOut.putArchiveEntry((ArchiveEntry)entry);
                tarOut.write(p);
                tarOut.closeArchiveEntry();
                Assertions.assertEquals((long)f.length(), (long)tarOut.getBytesWritten());
            }
            finally {
                AbstractTest.forceDelete(f);
            }
        }
    }

    @Test
    void testTarToMemoryFileSystem() throws IOException, ArchiveException {
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path p = fileSystem.getPath("target.tar", new String[0]);
            try (OutputStream out = Files.newOutputStream(p, new OpenOption[0]);
                 ArchiveOutputStream tarOut = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", out);){
                String content = "Test";
                TarArchiveEntry entry = new TarArchiveEntry("test.txt");
                entry.setSize((long)"Test".length());
                tarOut.putArchiveEntry((ArchiveEntry)entry);
                tarOut.writeUtf8("Test");
                tarOut.closeArchiveEntry();
                Assertions.assertTrue((boolean)Files.exists(p, new LinkOption[0]));
                Assertions.assertEquals((long)Files.size(p), (long)tarOut.getBytesWritten());
            }
        }
    }
}

