/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.trie;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.map.AbstractSortedMapTest;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.junit.Assert;

public class PatriciaTrieTest<V>
extends AbstractSortedMapTest<String, V> {
    public PatriciaTrieTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(PatriciaTrieTest.class);
    }

    @Override
    public SortedMap<String, V> makeObject() {
        return new PatriciaTrie();
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    public void testPrefixMap() {
        Object o2;
        String[] keys;
        PatriciaTrie trie = new PatriciaTrie();
        for (String key : keys = new String[]{"", "Albert", "Xavier", "XyZ", "Anna", "Alien", "Alberto", "Alberts", "Allie", "Alliese", "Alabama", "Banane", "Blabla", "Amber", "Ammun", "Akka", "Akko", "Albertoo", "Amma"}) {
            trie.put((Object)key, (Object)key);
        }
        SortedMap map = trie.prefixMap((Object)"Al");
        Assert.assertEquals((long)8L, (long)map.size());
        Assert.assertEquals((Object)"Alabama", map.firstKey());
        Assert.assertEquals((Object)"Alliese", map.lastKey());
        Assert.assertEquals((Object)"Albertoo", map.get("Albertoo"));
        Assert.assertNotNull((Object)trie.get((Object)"Xavier"));
        Assert.assertNull(map.get("Xavier"));
        Assert.assertNull((Object)trie.get((Object)"Alice"));
        Assert.assertNull(map.get("Alice"));
        Iterator<Object> iterator = map.values().iterator();
        Assert.assertEquals((Object)"Alabama", iterator.next());
        Assert.assertEquals((Object)"Albert", iterator.next());
        Assert.assertEquals((Object)"Alberto", iterator.next());
        Assert.assertEquals((Object)"Albertoo", iterator.next());
        Assert.assertEquals((Object)"Alberts", iterator.next());
        Assert.assertEquals((Object)"Alien", iterator.next());
        Assert.assertEquals((Object)"Allie", iterator.next());
        Assert.assertEquals((Object)"Alliese", iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"Albert");
        iterator = map.keySet().iterator();
        Assert.assertEquals((Object)"Albert", (Object)iterator.next());
        Assert.assertEquals((Object)"Alberto", (Object)iterator.next());
        Assert.assertEquals((Object)"Albertoo", (Object)iterator.next());
        Assert.assertEquals((Object)"Alberts", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((long)4L, (long)map.size());
        Assert.assertEquals((Object)"Albert", map.firstKey());
        Assert.assertEquals((Object)"Alberts", map.lastKey());
        Assert.assertNull((Object)trie.get((Object)"Albertz"));
        map.put("Albertz", "Albertz");
        Assert.assertEquals((Object)"Albertz", (Object)trie.get((Object)"Albertz"));
        Assert.assertEquals((long)5L, (long)map.size());
        Assert.assertEquals((Object)"Albertz", map.lastKey());
        iterator = map.keySet().iterator();
        Assert.assertEquals((Object)"Albert", (Object)iterator.next());
        Assert.assertEquals((Object)"Alberto", (Object)iterator.next());
        Assert.assertEquals((Object)"Albertoo", (Object)iterator.next());
        Assert.assertEquals((Object)"Alberts", (Object)iterator.next());
        Assert.assertEquals((Object)"Albertz", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"Albertz", map.remove("Albertz"));
        map = trie.prefixMap((Object)"Alberto");
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"Alberto", map.firstKey());
        Assert.assertEquals((Object)"Albertoo", map.lastKey());
        Iterator entryIterator = map.entrySet().iterator();
        Map.Entry entry = entryIterator.next();
        Assert.assertEquals((Object)"Alberto", entry.getKey());
        Assert.assertEquals((Object)"Alberto", entry.getValue());
        entry = entryIterator.next();
        Assert.assertEquals((Object)"Albertoo", entry.getKey());
        Assert.assertEquals((Object)"Albertoo", entry.getValue());
        Assert.assertFalse((boolean)entryIterator.hasNext());
        trie.put((Object)"Albertoad", (Object)"Albertoad");
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((Object)"Alberto", map.firstKey());
        Assert.assertEquals((Object)"Albertoo", map.lastKey());
        entryIterator = map.entrySet().iterator();
        entry = entryIterator.next();
        Assert.assertEquals((Object)"Alberto", entry.getKey());
        Assert.assertEquals((Object)"Alberto", entry.getValue());
        entry = entryIterator.next();
        Assert.assertEquals((Object)"Albertoad", entry.getKey());
        Assert.assertEquals((Object)"Albertoad", entry.getValue());
        entry = entryIterator.next();
        Assert.assertEquals((Object)"Albertoo", entry.getKey());
        Assert.assertEquals((Object)"Albertoo", entry.getValue());
        Assert.assertFalse((boolean)entryIterator.hasNext());
        Assert.assertEquals((Object)"Albertoo", (Object)trie.remove((Object)"Albertoo"));
        Assert.assertEquals((Object)"Alberto", map.firstKey());
        Assert.assertEquals((Object)"Albertoad", map.lastKey());
        Assert.assertEquals((long)2L, (long)map.size());
        entryIterator = map.entrySet().iterator();
        entry = entryIterator.next();
        Assert.assertEquals((Object)"Alberto", entry.getKey());
        Assert.assertEquals((Object)"Alberto", entry.getValue());
        entry = entryIterator.next();
        Assert.assertEquals((Object)"Albertoad", entry.getKey());
        Assert.assertEquals((Object)"Albertoad", entry.getValue());
        Assert.assertFalse((boolean)entryIterator.hasNext());
        Assert.assertEquals((Object)"Albertoad", (Object)trie.remove((Object)"Albertoad"));
        trie.put((Object)"Albertoo", (Object)"Albertoo");
        map = trie.prefixMap((Object)"X");
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertFalse((boolean)map.containsKey("Albert"));
        Assert.assertTrue((boolean)map.containsKey("Xavier"));
        Assert.assertFalse((boolean)map.containsKey("Xalan"));
        iterator = map.values().iterator();
        Assert.assertEquals((Object)"Xavier", (Object)iterator.next());
        Assert.assertEquals((Object)"XyZ", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"An");
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"Anna", map.firstKey());
        Assert.assertEquals((Object)"Anna", map.lastKey());
        iterator = map.keySet().iterator();
        Assert.assertEquals((Object)"Anna", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"Ban");
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"Banane", map.firstKey());
        Assert.assertEquals((Object)"Banane", map.lastKey());
        iterator = map.keySet().iterator();
        Assert.assertEquals((Object)"Banane", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"Am");
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((Object)"Amber", (Object)trie.remove((Object)"Amber"));
        iterator = map.keySet().iterator();
        Assert.assertEquals((Object)"Amma", (Object)iterator.next());
        Assert.assertEquals((Object)"Ammun", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = map.keySet().iterator();
        map.put("Amber", "Amber");
        Assert.assertEquals((long)3L, (long)map.size());
        try {
            iterator.next();
            Assert.fail((String)"CME expected");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"Amber", map.firstKey());
        Assert.assertEquals((Object)"Ammun", map.lastKey());
        map = trie.prefixMap((Object)"Ak\u0000");
        Assert.assertTrue((boolean)map.isEmpty());
        map = trie.prefixMap((Object)"Ak");
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"Akka", map.firstKey());
        Assert.assertEquals((Object)"Akko", map.lastKey());
        map.put("Ak", "Ak");
        Assert.assertEquals((Object)"Ak", map.firstKey());
        Assert.assertEquals((Object)"Akko", map.lastKey());
        Assert.assertEquals((long)3L, (long)map.size());
        trie.put((Object)"Al", (Object)"Al");
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((Object)"Ak", map.remove("Ak"));
        Assert.assertEquals((Object)"Akka", map.firstKey());
        Assert.assertEquals((Object)"Akko", map.lastKey());
        Assert.assertEquals((long)2L, (long)map.size());
        iterator = map.keySet().iterator();
        Assert.assertEquals((Object)"Akka", (Object)iterator.next());
        Assert.assertEquals((Object)"Akko", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"Al", (Object)trie.remove((Object)"Al"));
        map = trie.prefixMap((Object)"Akka");
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"Akka", map.firstKey());
        Assert.assertEquals((Object)"Akka", map.lastKey());
        iterator = map.keySet().iterator();
        Assert.assertEquals((Object)"Akka", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"Ab");
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((long)0L, (long)map.size());
        try {
            o2 = map.firstKey();
            Assert.fail((String)("got a first key: " + o2));
        }
        catch (NoSuchElementException o2) {
            // empty catch block
        }
        try {
            o2 = map.lastKey();
            Assert.fail((String)("got a last key: " + o2));
        }
        catch (NoSuchElementException o3) {
            // empty catch block
        }
        iterator = map.values().iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"Albertooo");
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((long)0L, (long)map.size());
        try {
            o2 = map.firstKey();
            Assert.fail((String)("got a first key: " + o2));
        }
        catch (NoSuchElementException o4) {
            // empty catch block
        }
        try {
            o2 = map.lastKey();
            Assert.fail((String)("got a last key: " + o2));
        }
        catch (NoSuchElementException o5) {
            // empty catch block
        }
        iterator = map.values().iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"");
        Assert.assertSame((Object)trie, (Object)map);
        map = trie.prefixMap((Object)"\u0000");
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((long)0L, (long)map.size());
        try {
            o2 = map.firstKey();
            Assert.fail((String)("got a first key: " + o2));
        }
        catch (NoSuchElementException o6) {
            // empty catch block
        }
        try {
            o2 = map.lastKey();
            Assert.fail((String)("got a last key: " + o2));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        iterator = map.values().iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testPrefixMapRemoval() {
        String[] keys;
        PatriciaTrie trie = new PatriciaTrie();
        for (String key : keys = new String[]{"Albert", "Xavier", "XyZ", "Anna", "Alien", "Alberto", "Alberts", "Allie", "Alliese", "Alabama", "Banane", "Blabla", "Amber", "Ammun", "Akka", "Akko", "Albertoo", "Amma"}) {
            trie.put((Object)key, (Object)key);
        }
        SortedMap map = trie.prefixMap((Object)"Al");
        Assert.assertEquals((long)8L, (long)map.size());
        Iterator iter = map.keySet().iterator();
        Assert.assertEquals((Object)"Alabama", iter.next());
        Assert.assertEquals((Object)"Albert", iter.next());
        Assert.assertEquals((Object)"Alberto", iter.next());
        Assert.assertEquals((Object)"Albertoo", iter.next());
        Assert.assertEquals((Object)"Alberts", iter.next());
        Assert.assertEquals((Object)"Alien", iter.next());
        iter.remove();
        Assert.assertEquals((long)7L, (long)map.size());
        Assert.assertEquals((Object)"Allie", iter.next());
        Assert.assertEquals((Object)"Alliese", iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
        map = trie.prefixMap((Object)"Ak");
        Assert.assertEquals((long)2L, (long)map.size());
        iter = map.keySet().iterator();
        Assert.assertEquals((Object)"Akka", iter.next());
        iter.remove();
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"Akko", iter.next());
        if (iter.hasNext()) {
            Assert.fail((String)("shouldn't have next (but was: " + (String)iter.next() + ")"));
        }
        Assert.assertFalse((boolean)iter.hasNext());
    }

    public void testPrefixMapSizes() {
        PatriciaTrie aTree = new PatriciaTrie();
        aTree.put((Object)"\u00e7\u0082\u00b9\u00e8\u00af\u0084", (Object)"\u00e6\u00b5\u008b\u00e8\u00af\u0095");
        aTree.put((Object)"\u00e4\u00b9\u00a6\u00e8\u00af\u0084", (Object)"\u00e6\u00b5\u008b\u00e8\u00af\u0095");
        PatriciaTrieTest.assertTrue((boolean)aTree.prefixMap((Object)"\u00e7\u0082\u00b9").containsKey("\u00e7\u0082\u00b9\u00e8\u00af\u0084"));
        PatriciaTrieTest.assertEquals((String)"\u00e6\u00b5\u008b\u00e8\u00af\u0095", (String)((String)aTree.prefixMap((Object)"\u00e7\u0082\u00b9").get("\u00e7\u0082\u00b9\u00e8\u00af\u0084")));
        PatriciaTrieTest.assertFalse((boolean)aTree.prefixMap((Object)"\u00e7\u0082\u00b9").isEmpty());
        PatriciaTrieTest.assertEquals((int)1, (int)aTree.prefixMap((Object)"\u00e7\u0082\u00b9").size());
        PatriciaTrieTest.assertEquals((int)1, (int)aTree.prefixMap((Object)"\u00e7\u0082\u00b9").keySet().size());
        PatriciaTrieTest.assertEquals((int)1, (int)aTree.prefixMap((Object)"\u00e7\u0082\u00b9").entrySet().size());
        PatriciaTrieTest.assertEquals((int)1, (int)aTree.prefixMap((Object)"\u00e7\u0082\u00b9\u00e8\u00af\u0084").values().size());
        aTree.clear();
        aTree.put((Object)"\u00e7\u0082\u00b9\u00e8\u00af\u0084", (Object)"\u00e8\u0081\u0094\u00e7\u009b\u009f");
        aTree.put((Object)"\u00e7\u0082\u00b9\u00e7\u0089\u0088", (Object)"\u00e5\u00ae\u009a\u00e5\u0090\u0091");
        PatriciaTrieTest.assertEquals((int)2, (int)aTree.prefixMap((Object)"\u00e7\u0082\u00b9").keySet().size());
        PatriciaTrieTest.assertEquals((int)2, (int)aTree.prefixMap((Object)"\u00e7\u0082\u00b9").values().size());
    }

    public void testPrefixMapSizes2() {
        char u8000 = Character.toChars(32768)[0];
        int char_b = 98;
        PatriciaTrie trie = new PatriciaTrie();
        String prefixString = "b";
        String longerString = "b" + u8000;
        PatriciaTrieTest.assertEquals((int)1, (int)"b".length());
        PatriciaTrieTest.assertEquals((int)2, (int)longerString.length());
        PatriciaTrieTest.assertTrue((boolean)longerString.startsWith("b"));
        trie.put((Object)"b", (Object)"prefixString");
        trie.put((Object)longerString, (Object)"longerString");
        PatriciaTrieTest.assertEquals((int)2, (int)trie.prefixMap((Object)"b").size());
        PatriciaTrieTest.assertTrue((boolean)trie.prefixMap((Object)"b").containsKey(longerString));
    }

    public void testPrefixMapClear() {
        PatriciaTrie trie = new PatriciaTrie();
        trie.put((Object)"Anna", (Object)1);
        trie.put((Object)"Anael", (Object)2);
        trie.put((Object)"Analu", (Object)3);
        trie.put((Object)"Andreas", (Object)4);
        trie.put((Object)"Andrea", (Object)5);
        trie.put((Object)"Andres", (Object)6);
        trie.put((Object)"Anatole", (Object)7);
        SortedMap prefixMap = trie.prefixMap((Object)"And");
        PatriciaTrieTest.assertEquals(new HashSet<String>(Arrays.asList("Andrea", "Andreas", "Andres")), prefixMap.keySet());
        PatriciaTrieTest.assertEquals(Arrays.asList(5, 4, 6), new ArrayList(prefixMap.values()));
        prefixMap.clear();
        PatriciaTrieTest.assertTrue((boolean)prefixMap.isEmpty());
        PatriciaTrieTest.assertTrue((boolean)prefixMap.keySet().isEmpty());
        PatriciaTrieTest.assertTrue((boolean)prefixMap.values().isEmpty());
        PatriciaTrieTest.assertEquals(new HashSet<String>(Arrays.asList("Anael", "Analu", "Anatole", "Anna")), (Object)trie.keySet());
        PatriciaTrieTest.assertEquals(Arrays.asList(2, 3, 7, 1), new ArrayList(trie.values()));
    }

    public void testPrefixMapClearNothing() {
        PatriciaTrie trie = new PatriciaTrie();
        SortedMap prefixMap = trie.prefixMap((Object)"And");
        PatriciaTrieTest.assertEquals(new HashSet(), prefixMap.keySet());
        PatriciaTrieTest.assertEquals(new ArrayList(0), new ArrayList(prefixMap.values()));
        prefixMap.clear();
        PatriciaTrieTest.assertTrue((boolean)prefixMap.isEmpty());
        PatriciaTrieTest.assertTrue((boolean)prefixMap.keySet().isEmpty());
        PatriciaTrieTest.assertTrue((boolean)prefixMap.values().isEmpty());
        PatriciaTrieTest.assertEquals(new HashSet(), (Object)trie.keySet());
        PatriciaTrieTest.assertEquals(new ArrayList(0), new ArrayList(trie.values()));
    }

    public void testPrefixMapClearUsingRemove() {
        PatriciaTrie trie = new PatriciaTrie();
        trie.put((Object)"Anna", (Object)1);
        trie.put((Object)"Anael", (Object)2);
        trie.put((Object)"Analu", (Object)3);
        trie.put((Object)"Andreas", (Object)4);
        trie.put((Object)"Andrea", (Object)5);
        trie.put((Object)"Andres", (Object)6);
        trie.put((Object)"Anatole", (Object)7);
        SortedMap prefixMap = trie.prefixMap((Object)"And");
        PatriciaTrieTest.assertEquals(new HashSet<String>(Arrays.asList("Andrea", "Andreas", "Andres")), prefixMap.keySet());
        PatriciaTrieTest.assertEquals(Arrays.asList(5, 4, 6), new ArrayList(prefixMap.values()));
        HashSet keys = new HashSet(prefixMap.keySet());
        for (String key : keys) {
            prefixMap.remove(key);
        }
        PatriciaTrieTest.assertTrue((boolean)prefixMap.keySet().isEmpty());
        PatriciaTrieTest.assertTrue((boolean)prefixMap.values().isEmpty());
        PatriciaTrieTest.assertEquals(new HashSet<String>(Arrays.asList("Anael", "Analu", "Anatole", "Anna")), (Object)trie.keySet());
        PatriciaTrieTest.assertEquals(Arrays.asList(2, 3, 7, 1), new ArrayList(trie.values()));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

