/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.set.AbstractSetTest;

public abstract class AbstractSortedSetTest<E>
extends AbstractSetTest<E> {
    public AbstractSortedSetTest(String name) {
        super(name);
    }

    @Override
    public void verify() {
        super.verify();
        Iterator colliter = this.getCollection().iterator();
        Iterator confiter = this.getConfirmed().iterator();
        Object first = null;
        Object last = null;
        while (colliter.hasNext()) {
            last = first == null ? (first = colliter.next()) : colliter.next();
            AbstractSortedSetTest.assertEquals((String)"Element appears to be out of order.", last, confiter.next());
        }
        if (this.getCollection().size() > 0) {
            AbstractSortedSetTest.assertEquals((String)"Incorrect element returned by first().", first, this.getCollection().first());
            AbstractSortedSetTest.assertEquals((String)"Incorrect element returned by last().", last, this.getCollection().last());
        }
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    @Override
    public abstract SortedSet<E> makeObject();

    @Override
    public SortedSet<E> makeFullCollection() {
        return (SortedSet)super.makeFullCollection();
    }

    @Override
    public SortedSet<E> makeConfirmedCollection() {
        return new TreeSet();
    }

    @Override
    public E[] getFullNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 1;
        }
        return elements;
    }

    @Override
    public E[] getOtherNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 2;
        }
        return elements;
    }

    public BulkTest bulkTestSortedSetSubSet() {
        int length = this.getFullElements().length;
        int lobound = length / 3;
        int hibound = lobound * 2;
        return new TestSortedSetSubSet(lobound, hibound);
    }

    public BulkTest bulkTestSortedSetHeadSet() {
        int length = this.getFullElements().length;
        int lobound = length / 3;
        int hibound = lobound * 2;
        return new TestSortedSetSubSet(hibound, true);
    }

    public BulkTest bulkTestSortedSetTailSet() {
        int length = this.getFullElements().length;
        int lobound = length / 3;
        return new TestSortedSetSubSet(lobound, false);
    }

    @Override
    public SortedSet<E> getCollection() {
        return (SortedSet)super.getCollection();
    }

    @Override
    public SortedSet<E> getConfirmed() {
        return (SortedSet)super.getConfirmed();
    }

    public class TestSortedSetSubSet
    extends AbstractSortedSetTest<E> {
        private int m_Type;
        private int m_LowBound;
        private int m_HighBound;
        private E[] m_FullElements;
        private E[] m_OtherElements;
        static final int TYPE_SUBSET = 0;
        static final int TYPE_TAILSET = 1;
        static final int TYPE_HEADSET = 2;

        public TestSortedSetSubSet(int bound, boolean head) {
            super("TestSortedSetSubSet");
            if (head) {
                this.m_Type = 2;
                this.m_HighBound = bound;
                this.m_FullElements = new Object[bound];
                System.arraycopy(AbstractSortedSetTest.this.getFullElements(), 0, this.m_FullElements, 0, bound);
                this.m_OtherElements = new Object[bound - 1];
                System.arraycopy(AbstractSortedSetTest.this.getOtherElements(), 0, this.m_OtherElements, 0, bound - 1);
            } else {
                this.m_Type = 1;
                this.m_LowBound = bound;
                E[] allelements = AbstractSortedSetTest.this.getFullElements();
                this.m_FullElements = new Object[allelements.length - bound];
                System.arraycopy(allelements, bound, this.m_FullElements, 0, allelements.length - bound);
                this.m_OtherElements = new Object[allelements.length - bound - 1];
                System.arraycopy(AbstractSortedSetTest.this.getOtherElements(), bound, this.m_OtherElements, 0, allelements.length - bound - 1);
            }
        }

        public TestSortedSetSubSet(int lobound, int hibound) {
            super("TestSortedSetSubSet");
            this.m_Type = 0;
            this.m_LowBound = lobound;
            this.m_HighBound = hibound;
            int length = hibound - lobound;
            this.m_FullElements = new Object[length];
            System.arraycopy(AbstractSortedSetTest.this.getFullElements(), lobound, this.m_FullElements, 0, length);
            this.m_OtherElements = new Object[length - 1];
            System.arraycopy(AbstractSortedSetTest.this.getOtherElements(), lobound, this.m_OtherElements, 0, length - 1);
        }

        @Override
        public boolean isNullSupported() {
            return AbstractSortedSetTest.this.isNullSupported();
        }

        @Override
        public boolean isAddSupported() {
            return AbstractSortedSetTest.this.isAddSupported();
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractSortedSetTest.this.isRemoveSupported();
        }

        @Override
        public boolean isFailFastSupported() {
            return AbstractSortedSetTest.this.isFailFastSupported();
        }

        @Override
        public E[] getFullElements() {
            return this.m_FullElements;
        }

        @Override
        public E[] getOtherElements() {
            return this.m_OtherElements;
        }

        private SortedSet<E> getSubSet(SortedSet<E> set) {
            E[] elements = AbstractSortedSetTest.this.getFullElements();
            switch (this.m_Type) {
                case 0: {
                    return set.subSet(elements[this.m_LowBound], elements[this.m_HighBound]);
                }
                case 2: {
                    return set.headSet(elements[this.m_HighBound]);
                }
                case 1: {
                    return set.tailSet(elements[this.m_LowBound]);
                }
            }
            return null;
        }

        @Override
        public SortedSet<E> makeObject() {
            return this.getSubSet((SortedSet)AbstractSortedSetTest.this.makeObject());
        }

        @Override
        public SortedSet<E> makeFullCollection() {
            return this.getSubSet((SortedSet)AbstractSortedSetTest.this.makeFullCollection());
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public BulkTest bulkTestSortedSetSubSet() {
            return null;
        }

        @Override
        public BulkTest bulkTestSortedSetHeadSet() {
            return null;
        }

        @Override
        public BulkTest bulkTestSortedSetTailSet() {
            return null;
        }
    }
}

