/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.LazyMap;
import org.junit.Test;

public class LazyMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    private static final Factory<Integer> oneFactory = FactoryUtils.constantFactory((Object)1);

    public LazyMapTest(String testName) {
        super(testName);
    }

    @Override
    public LazyMap<K, V> makeObject() {
        return LazyMap.lazyMap(new HashMap(), (Factory)FactoryUtils.nullFactory());
    }

    @Override
    public void testMapGet() {
    }

    @Test
    public void mapGetWithFactory() {
        LazyMap map = LazyMap.lazyMap(new HashMap(), oneFactory);
        LazyMapTest.assertEquals((int)0, (int)map.size());
        Number i1 = (Number)map.get("Five");
        LazyMapTest.assertEquals((Object)1, (Object)i1);
        LazyMapTest.assertEquals((int)1, (int)map.size());
        Number i2 = (Number)map.get(new String(new char[]{'F', 'i', 'v', 'e'}));
        LazyMapTest.assertEquals((Object)1, (Object)i2);
        LazyMapTest.assertEquals((int)1, (int)map.size());
        LazyMapTest.assertSame((Object)i1, (Object)i2);
        map = LazyMap.lazyMap(new HashMap(), (Factory)FactoryUtils.nullFactory());
        Object o = map.get("Five");
        LazyMapTest.assertEquals(null, o);
        LazyMapTest.assertEquals((int)1, (int)map.size());
    }

    @Test
    public void mapGetWithTransformer() {
        Transformer<Number, Integer> intConverter = new Transformer<Number, Integer>(){

            public Integer transform(Number input) {
                return input.intValue();
            }
        };
        LazyMap map = LazyMap.lazyMap(new HashMap(), (Transformer)intConverter);
        LazyMapTest.assertEquals((int)0, (int)map.size());
        Number i1 = (Number)map.get(123L);
        LazyMapTest.assertEquals((Object)123, (Object)i1);
        LazyMapTest.assertEquals((int)1, (int)map.size());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

