/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractListIteratorTest;
import org.apache.commons.collections4.iterators.SingletonListIterator;

public class SingletonListIteratorTest<E>
extends AbstractListIteratorTest<E> {
    private static final Object testValue = "foo";

    public SingletonListIteratorTest(String testName) {
        super(testName);
    }

    @Override
    public SingletonListIterator<E> makeEmptyIterator() {
        SingletonListIterator<E> iter = this.makeObject();
        iter.next();
        iter.remove();
        iter.reset();
        return iter;
    }

    @Override
    public SingletonListIterator<E> makeObject() {
        return new SingletonListIterator(testValue);
    }

    @Override
    public boolean supportsAdd() {
        return false;
    }

    @Override
    public boolean supportsRemove() {
        return true;
    }

    @Override
    public boolean supportsEmptyIterator() {
        return true;
    }

    public void testIterator() {
        SingletonListIterator<E> iter = this.makeObject();
        SingletonListIteratorTest.assertTrue((String)"Iterator should have next item", (boolean)iter.hasNext());
        SingletonListIteratorTest.assertTrue((String)"Iterator should have no previous item", (!iter.hasPrevious() ? 1 : 0) != 0);
        SingletonListIteratorTest.assertEquals((String)"Iteration next index", (int)0, (int)iter.nextIndex());
        SingletonListIteratorTest.assertEquals((String)"Iteration previous index", (int)-1, (int)iter.previousIndex());
        Object iterValue = iter.next();
        SingletonListIteratorTest.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        SingletonListIteratorTest.assertTrue((String)"Iterator should have no next item", (!iter.hasNext() ? 1 : 0) != 0);
        SingletonListIteratorTest.assertTrue((String)"Iterator should have previous item", (boolean)iter.hasPrevious());
        SingletonListIteratorTest.assertEquals((String)"Iteration next index", (int)1, (int)iter.nextIndex());
        SingletonListIteratorTest.assertEquals((String)"Iteration previous index", (int)0, (int)iter.previousIndex());
        iterValue = iter.previous();
        SingletonListIteratorTest.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        SingletonListIteratorTest.assertTrue((String)"Iterator should have next item", (boolean)iter.hasNext());
        SingletonListIteratorTest.assertTrue((String)"Iterator should have no previous item", (!iter.hasPrevious() ? 1 : 0) != 0);
        SingletonListIteratorTest.assertEquals((String)"Iteration next index", (int)0, (int)iter.nextIndex());
        SingletonListIteratorTest.assertEquals((String)"Iteration previous index", (int)-1, (int)iter.previousIndex());
        iterValue = iter.next();
        SingletonListIteratorTest.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        SingletonListIteratorTest.assertTrue((String)"Iterator should have no next item", (!iter.hasNext() ? 1 : 0) != 0);
        SingletonListIteratorTest.assertTrue((String)"Iterator should have previous item", (boolean)iter.hasPrevious());
        SingletonListIteratorTest.assertEquals((String)"Iteration next index", (int)1, (int)iter.nextIndex());
        SingletonListIteratorTest.assertEquals((String)"Iteration previous index", (int)0, (int)iter.previousIndex());
        try {
            iter.next();
        }
        catch (Exception e) {
            SingletonListIteratorTest.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
        iter.previous();
        try {
            iter.previous();
        }
        catch (Exception e) {
            SingletonListIteratorTest.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
    }

    public void testReset() {
        SingletonListIterator<E> it = this.makeObject();
        SingletonListIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        SingletonListIteratorTest.assertEquals((boolean)false, (boolean)it.hasPrevious());
        SingletonListIteratorTest.assertEquals((Object)testValue, (Object)it.next());
        SingletonListIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
        SingletonListIteratorTest.assertEquals((boolean)true, (boolean)it.hasPrevious());
        it.reset();
        SingletonListIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        SingletonListIteratorTest.assertEquals((boolean)false, (boolean)it.hasPrevious());
        SingletonListIteratorTest.assertEquals((Object)testValue, (Object)it.next());
        SingletonListIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
        SingletonListIteratorTest.assertEquals((boolean)true, (boolean)it.hasPrevious());
        it.reset();
        it.reset();
        SingletonListIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
    }
}

