/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.junit.Test;

public class PeekingIteratorTest<E>
extends AbstractIteratorTest<E> {
    private final String[] testArray = new String[]{"a", "b", "c"};
    private List<E> testList;

    public PeekingIteratorTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testList = new ArrayList<Object>(Arrays.asList((Object[])this.testArray));
    }

    @Override
    public Iterator<E> makeEmptyIterator() {
        return PeekingIterator.peekingIterator(Collections.emptyList().iterator());
    }

    @Override
    public PeekingIterator<E> makeObject() {
        return PeekingIterator.peekingIterator(this.testList.iterator());
    }

    @Override
    public boolean supportsRemove() {
        return true;
    }

    @Test
    public void testEmpty() {
        Iterator<E> it = this.makeEmptyIterator();
        PeekingIteratorTest.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testSinglePeek() {
        PeekingIterator<E> it = this.makeObject();
        PeekingIteratorTest.assertEquals((Object)"a", (Object)it.peek());
        PeekingIteratorTest.assertEquals((Object)"a", (Object)it.element());
        this.validate((Iterator<E>)it, (E[])this.testArray);
    }

    @Test
    public void testMultiplePeek() {
        PeekingIterator<E> it = this.makeObject();
        PeekingIteratorTest.assertEquals((Object)"a", (Object)it.peek());
        PeekingIteratorTest.assertEquals((Object)"a", (Object)it.peek());
        PeekingIteratorTest.assertEquals((Object)"a", (Object)it.next());
        PeekingIteratorTest.assertTrue((boolean)it.hasNext());
        PeekingIteratorTest.assertEquals((Object)"b", (Object)it.peek());
        PeekingIteratorTest.assertEquals((Object)"b", (Object)it.peek());
        PeekingIteratorTest.assertEquals((Object)"b", (Object)it.next());
        PeekingIteratorTest.assertTrue((boolean)it.hasNext());
        PeekingIteratorTest.assertEquals((Object)"c", (Object)it.peek());
        PeekingIteratorTest.assertEquals((Object)"c", (Object)it.peek());
        PeekingIteratorTest.assertEquals((Object)"c", (Object)it.next());
        PeekingIteratorTest.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIteratorExhausted() {
        PeekingIterator<E> it = this.makeObject();
        it.next();
        it.next();
        it.next();
        PeekingIteratorTest.assertFalse((boolean)it.hasNext());
        PeekingIteratorTest.assertNull((Object)it.peek());
        try {
            it.element();
            PeekingIteratorTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testIllegalRemove() {
        PeekingIterator<E> it = this.makeObject();
        it.next();
        it.remove();
        PeekingIteratorTest.assertTrue((boolean)it.hasNext());
        PeekingIteratorTest.assertEquals((Object)"b", (Object)it.peek());
        try {
            it.remove();
            PeekingIteratorTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void validate(Iterator<E> iter, E ... items) {
        for (E x : items) {
            PeekingIteratorTest.assertTrue((boolean)iter.hasNext());
            PeekingIteratorTest.assertEquals(x, iter.next());
        }
        PeekingIteratorTest.assertFalse((boolean)iter.hasNext());
    }
}

